/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.PhoneType;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientPhone;

import org.jdom.Element;

/**
 * class that represents an Kmehr telecom object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmTelecom.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:22  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmTelecom implements KmConstants{

	private static final String TELECOM = "telecom";
	private static final String TEXT = "text";

	public static final String PHONE = "phone";
	public static final String MOBILE = "mobile";
	public static final String FAX = "fax";
	public static final String EMAIL = "email";
	
	
	/**
	 * creates the Kmehr xml element
	 * @param type
	 * @param value
	 * @return
	 */
	public static Element create(String type, String value) {
		Element telecom = new Element(TELECOM);
		telecom.addContent(KmCD.create(CD_TELECOM, type));
	    Element text = new Element(TEXT);
	    text.setText(value);
	    telecom.addContent(text);
	    return telecom;
	}

	/**
	 * creates the Kmehr xml element
	 * @param pp
	 * @return
	 */
	public static Element create(PatientPhone pp) {
		return create(matchType(pp.getType()), pp.getNumber());
	}
	
	private static String matchType(String type) {
		if (type == null) 
			return PHONE;
		if (type.equals(PhoneType.HOME))
			return PHONE; 
		if (type.equals(PhoneType.MOBILE))
			return MOBILE; 
		if (type.equals(PhoneType.FAX))
			return FAX; 
		return PHONE; 
	}

}

