/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * class that creates a Kmehr xml message
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmehrWriter.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmehrWriter  implements KmConstants{
	
	private static final String KMEHRMESSAGE = "kmehrmessage";
	private static final String FOLDER = "folder";
	
	private Element kmehrMessage;
	private Element folder;
	private int folderNr = 1;


	public KmehrWriter() {
		kmehrMessage = new Element(KMEHRMESSAGE);
	}
	
	/**
	 * creates a new folder object in the kmehr message
	 */
	public void newFolder() {
	    folder = new Element(FOLDER);
	    folder.addContent(KmID.create(KmID.ID_KMEHR, folderNr+""));
	    kmehrMessage.addContent(folder);
	    folderNr  ++;
	}
	
	public void addTransaction(KmTransaction trans) {
		folder.addContent(trans.getElement());
	}

	public void setHeader(KmHeader header) {
		kmehrMessage.addContent(header.getElement());
	}

	public void setPatient(Patient p) {
		folder.addContent(KmPatient.create(p));
	}
  
  /**
   * writes the kmehr message as xml 
 * @return
 */
public byte[]  writeMessage() {
	  Document doc = new Document(kmehrMessage);
	  ByteArrayOutputStream bOut = new ByteArrayOutputStream();
	    try {
	      XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
	      serializer.output(doc, bOut);
	    }
	    catch (IOException e) {
	      System.err.println(e);
	    }
	    return bOut.toByteArray();
  }

  
  
}
