package lu.tudor.santec.gecamed.patient.gui.fileimport;

import java.awt.Component;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.gui.history.FileHandler;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ChooseIncidentBox.java,v $
 * <br>Revision 1.1  2013-02-14 08:15:18  ferring
 * <br>incident selection added to new letters and improved for files
 * <br>
 */

public class ChooseIncidentBox extends JComboBox implements ListCellRenderer
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID			= 1L;
	
	private static final String	NEW_INCIDENT_TRANSLATION	= Translatrix.getTranslationString("fileimport.dialog.addNewIncident");
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private DefaultComboBoxModel	model;
	
	private LineColorListRenderer	superRenderer;
	
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public ChooseIncidentBox()
	{
		super(new DefaultComboBoxModel());
		model	= (DefaultComboBoxModel) super.getModel();
		
		superRenderer	= new LineColorListRenderer();
		this.setRenderer(this);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void fill (Collection<Incident> incidents)
	{
		Calendar	cal	= new GregorianCalendar();
		Date		today;
		Date		tomorrow;
		Incident	selectedIncident	= null;
		
		
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		today		= cal.getTime();
		
		cal.add(Calendar.DAY_OF_MONTH, 1);
		tomorrow	= cal.getTime();
		
		model.removeAllElements();
		
		model.addElement(null);
		for (Incident i : incidents)
		{
			model.addElement(i);
			if (selectedIncident == null 
					&& i.getIncidentDate().before(tomorrow)
					&& i.getIncidentDate().after(today))
			{
				selectedIncident	= i;
			}
		}
		
		model.setSelectedItem(selectedIncident);
	}
	
	
	public Component getListCellRendererComponent(JList list, Object value, 
			int index, boolean isSelected, boolean cellHasFocus)
	{
		Component	c;
		String		text;
		
		
		if (value == null)
			text	= NEW_INCIDENT_TRANSLATION;
		else
			text	= FileHandler.getHistoryText((Incident)value);
		
		c	= superRenderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
		
		return c;
	}
}
