/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.fileimport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

/**
 * @author martin.heinemann@tudor.lu 11.03.2008 12:57:11
 * 
 * 
 * @version <br>
 *          $Log: FileImportDialog.java,v $
 *          Revision 1.29  2014-01-17 11:48:08  ferring
 *          Files are now attached correctly, with original file name and can be uploaded again
 *
 *          Revision 1.28  2013-12-27 18:09:25  donak
 *          Cleanup of imports
 *
 *          Revision 1.27  2013-07-15 06:18:36  ferring
 *          logging changed
 *
 *          Revision 1.26  2013-02-28 13:03:03  ferring
 *          File will not spread over the panel anymore, but will be displayed right beneath each other
 *
 *          Revision 1.25  2013-02-22 08:46:50  kutscheid
 *          remove the tupel classes (please redeploy)
 *
 *          Revision 1.24  2013-02-14 08:35:23  ferring
 *          incident chooser moved to same line as buttons
 *
 *          Revision 1.23  2013-02-14 08:15:18  ferring
 *          incident selection added to new letters and improved for files
 *
 *          Revision 1.22  2013-01-17 14:39:22  troth
 *          Code clearup.
 *
 *          Revision 1.21  2013-01-17 14:09:41  troth
 *          Fix some Bugs in Scanner Dialog.
 *
 *          Revision 1.20  2013-01-17 09:50:52  troth
 *          Scanner control version 1.
 *
 *          Revision 1.19  2013-01-16 16:42:50  troth
 *          add new Scanner dialog.
 *
 *          Revision 1.18  2013-01-16 11:32:48  ferring
 *          *** empty log message ***
 *
 *          Revision 1.17  2013-01-15 17:57:42  ferring
 *          Add new scan dialog for mac.
 *
 *          Revision 1.16  2013-01-15 14:22:55  troth
 *          Add scanner function for mac os, now it is configure over the user settings. (Testversion)
 *
 *          Revision 1.15  2013-01-15 12:44:16  ferring
 *          add scanner function for mac test version 2
 *
 *          Revision 1.14  2013-01-15 11:50:53  troth
 *          Add scanner function for mac os. (Testversion)
 *
 *          Revision 1.13  2013-01-10 12:54:46  ferring
 *          system exit method changed
 *
 *          Revision 1.12  2012-11-16 10:34:55  ferring
 *          Drag and Drop of files into the patient module will call the FileImportDialog with this files included
 *
 *          Revision 1.11  2010-04-26 16:43:13  troth
 *          Redesign of the prescription view
 *
 *          Revision 1.10  2010-03-25 11:25:29  troth
 *          fix bug attach file dialog not open under apple system
 *
 *          Revision 1.9  2010-03-12 14:17:42  hermen
 *          cleanup of panel layouts and icons
 *
 *          Revision 1.8  2010-02-19 11:00:28  troth
 *          fixed delete problems of temporarily scanner files
 *
 *          Revision 1.7  2010-02-18 16:47:54  troth
 *          add and implement the method startScan to scan documents as JPG, PNG or PDF
 * <br>
 *          Revision 1.6 2008-12-15 15:28:51 hermen <br>
 *          don't show import dialog if filechooser is canceled <br>
 * <br>
 *          Revision 1.5 2008-09-25 09:43:06 heinemann <br>
 *          fixed copyrights <br>
 * <br>
 *          Revision 1.4 2008-07-03 11:59:57 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.3 2008-04-10 14:43:05 heinemann <br>
 *          fixed filechooser problem <br>
 * <br>
 *          Revision 1.2 2008-03-12 10:14:07 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1 2008-03-11 17:17:11 heinemann <br>
 *          *** empty log message *** <br>
 * 
 */
public class FileImportDialog extends GECAMedBaseDialog implements
		ActionListener, PropertyChangeListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JPanel mainPanel;
	private ChooseIncidentBox incidentBox;
	private JButton addButton;
	private JPanel scrollPanel;
	private JFileChooser fileChooser;
	private JPanel filePanel;
	private ArrayList<FileEditPanel> filePanels = new ArrayList<FileEditPanel>();
	private FormLayout fileLayout;
	private CellConstraints cc;
	private JScrollPane paine;
	private ArrayList<File> deleteFiles = new ArrayList<File>();
	
	private Scanner scanner;
	private JButton scanPNGButton;
	private JButton scanJPGButton;
	private JButton scanPDFButton;
	private JButton scanButton;
	private File scanFile = null; 
	private String scanFileType;
	private Integer scannerSupportFlag = NONE;
	private boolean state;
	
	private static final int NONE = 0;
	private static final int SUPPORT_TWAIN = 1;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(FileImportDialog.class.getName());
	

	/**
	 * @param title
	 */
	public FileImportDialog() {
		/* ================================================== */
		super(Translatrix.getTranslationString("fileimport.dialog.title"), true);
		this.fileChooser = MainFrame.getFileChooser();
		
		initScanner();
		buildPanel();
		initActions();
		/* ================================================== */
	}

	/**
	 * @param incident
	 */
	public boolean showDialog(Incident incident, Collection<File> files) 
	{
		/* ================================================== */
		initIncidentBox();
//		selectIncident(incident);
		if (files != null && files.size() > 0)
		{
			for (File f : files)
				createFileEditor(f);
		}
//		else
//		{
//			if(scannerSupportFlag == NONE) 
//			{
//				if (!startFileSelection())
//					return false;
//			}
//		}
		
		return showDialog();
		/* ================================================== */
	}

//	/**
//	 * @param file
//	 */
//	public void showEditor(File file) {
//		/* ================================================== */
//		showEditor(file, null);
//		/* ================================================== */
//	}
//
//	public void showEditor(List<File> files) {
//		/* ================================================== */
//		showEditor(files, null);
//		/* ================================================== */
//	}
//
//	public void showEditor(File file, Incident incident) {
//		/* ================================================== */
//		initIncidentBox();
//		selectIncident(incident);
//		/* ------------------------------------------------------- */
//		// create panels for each file
//		/* ------------------------------------------------------- */
//		createFileEditor(file);
//		showDialog();
//		/* ================================================== */
//	}
//
//	public void showEditor(List<File> files, Incident incident) {
//		/* ================================================== */
//		initIncidentBox();
//		selectIncident(incident);
//		/* ------------------------------------------------------- */
//		// create panels for each file
//		/* ------------------------------------------------------- */
//		for (File f : files)
//			createFileEditor(f);
//
//		showDialog();
//		/* ================================================== */
//	}

	private boolean showDialog() {
		/* ================================================== */
		// try to open the first
		/* ------------------------------------------------------- */
		try {
			/* --------------------------------------------- */
			this.filePanels.get(0).setCollapsed(false);
			/* --------------------------------------------- */
		} catch (Exception e) {
		}

		this.setSize(550, 600);
		MainFrame.showDialogCentered(this);
		/* ================================================== */
		return state;
	}

	/**
	 * @param file
	 */
	private void createFileEditor(File file) {
		/* ================================================== */
		if (file == null)
			return;
		/* ------------------------------------------------------- */
		FileEditPanel edit = new FileEditPanel(fileChooser);
		edit.setFile(file);
		
		this.fileLayout.appendRow(new RowSpec(RowSpec.FILL, Sizes.PREFERRED, RowSpec.NO_GROW));
		edit.addPropertyChangeListener(this);
		edit.setCollapsed(true);
		this.filePanels.add(edit);
		
		filePanel.add(edit, cc.xy(1, fileLayout.getRowCount()));
		filePanel.validate();
		filePanel.updateUI();
		
		paine.getViewport().validate();
		paine.getViewport().updateUI();
		/* ================================================== */
	}

	/**
	 * Select the incident in the combobox
	 * 
	 * @param incident
	 */
//	private void selectIncident(Incident incident) {
//		/* ================================================== */
//		// if null, select the "New Incident"
//		/* ------------------------------------------------------- */
//		if (incident == null) {
//			incidentBox.setSelectedIndex(0);
//			return;
//		}
//		/* ------------------------------------------------------- */
//		incidentBox.setSelectedItem(incident);
//		/* ================================================== */
//	}

	private void initIncidentBox() {
		/* ================================================== */
		// Get the incidents from the history table model
		/* ------------------------------------------------------- */
		HashMap<Integer, Incident> incidents = PatientManagerModule
				.getInstance().getPatientPanel().getHistoryDataAgent()
				.getIncidents();
		/* ------------------------------------------------------- */
		// add a "New" entry to the box
		/* ------------------------------------------------------- */
//		this.incidentBox.addItem(Translatrix
//				.getTranslationString("fileimport.dialog.addNewIncident"));
//		for (Incident i : incidents.values())
//			incidentBox.addItem(i);
//		
//		incidentBox.setRenderer(new IncidentListBoxRenderer());
		incidentBox.fill(incidents.values());
		/* ================================================== */
	}

	private void initActions() {
		/* ====================================================== */
		this.okButton.addActionListener(this);
		this.cancelButton.addActionListener(this);

		this.addButton.addActionListener(this);
		this.scanJPGButton.addActionListener(this);
		this.scanPNGButton.addActionListener(this);
		this.scanPDFButton.addActionListener(this);
		this.scanButton.addActionListener(this);
		/* ====================================================== */
	}

	/**
	 * 
	 */
	private void buildPanel() {
		/* ====================================================== */
		this.mainPanel = new JPanel(new FormLayout(
				// columns
				"3dlu,f:p," +	// consultation label		-|
				"5px,f:p," +	// consultation chooser		 |-	file overview
				"10px:g,f:p," +	// button panel				-|
				"3dlu",
				
				// rows
				"3dlu,f:p," +			// consultation chooser & button panel
				"3dlu,f:200dlu:g," +	// template list
				"10dlu"));
		this.mainPanel.setOpaque(false);
		this.cc = new CellConstraints();
		/* ------------------------------------------------------- */
		JLabel	incidentLabel = new JLabel(
				Translatrix.getTranslationString("fileimport.incident"));
		this.incidentBox = new ChooseIncidentBox();
		this.addButton = new JButton(GECAMedModule
				.getMediumIcon(GECAMedModule.IMPORT));
		this.addButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
		/* ------------------------------------------------------- */
		
		this.scanJPGButton = new JButton(GECAMedModule
				.getMediumIcon(GECAMedModule.SCAN_JPG));
		this.scanJPGButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
		this.scanJPGButton.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.scanJPG"));
		this.scanPNGButton = new JButton(GECAMedModule
				.getMediumIcon(GECAMedModule.SCAN_PNG));
		this.scanPNGButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
		this.scanPNGButton.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.scanPNG"));
		this.scanPDFButton = new JButton(GECAMedModule
				.getMediumIcon(GECAMedModule.SCAN_PDF));
		this.scanPDFButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
		this.scanPDFButton.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.scanPDF"));
		this.scanButton = new JButton(GECAMedModule
				.getMediumIcon(GECAMedModule.SCAN));
		this.scanButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
		this.scanButton.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.scan"));

		/* ------------------------------------------------------- */
		this.scrollPanel = new JPanel(new BorderLayout());
		this.scrollPanel.setBorder(BorderFactory.createTitledBorder(Translatrix
				.getTranslationString("fileimport.files")));
		this.scrollPanel.setBackground(Color.WHITE);
		/* ------------------------------------------------------- */
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addUnrelatedGap();
		bb.addGlue();
		bb.addFixed(this.addButton);
		
		// add scan buttons if scanner driver is available over twain-interface
		if (scannerSupportFlag == SUPPORT_TWAIN) {
			bb.addRelatedGap();
			bb.addFixed(this.scanJPGButton);
			bb.addRelatedGap();
			bb.addFixed(this.scanPNGButton);
			bb.addRelatedGap();
			bb.addFixed(this.scanPDFButton);
		}
		// add scan button to open external scanner software
		bb.addRelatedGap();
		bb.addFixed(this.scanButton);
		
		
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// assemble the mainpanel
		/* ------------------------------------------------------- */
		this.mainPanel.add(incidentLabel,	cc.xy (2, 2));
		this.mainPanel.add(incidentBox,		cc.xy (4, 2, CellConstraints.LEFT, CellConstraints.CENTER));
		this.mainPanel.add(bb.getPanel(),	cc.xy (6, 2));
		/* ------------------------------------------------------- */
		this.mainPanel.add(this.scrollPanel,	cc.xyw(2, 4, 5));

		/* ------------------------------------------------------- */
		// the panel for the files
		/* ------------------------------------------------------- */
		this.fileLayout = new FormLayout("fill:pref:grow");

		this.filePanel = new JPanel(fileLayout);
		this.filePanel.setOpaque(false);
		this.paine = new JScrollPane(filePanel);

		paine.getViewport().setBackground(Color.WHITE);

		scrollPanel.add(paine, BorderLayout.CENTER);

		/* ------------------------------------------------------- */
		this.addMainPanel(this.mainPanel);

		/* ------------------------------------------------------- */
		addButton.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.addFile"));
		incidentBox.setToolTipText(Translatrix
				.getTranslationString("fileimport.dialog.tooltip.incidentSelect"));
		/* ====================================================== */
	}

	private void doImport() {
		/* ================================================== */
		// we need TuTupel objects for the importer
		// so we do.
		/* ------------------------------------------------------- */
		Map<File, String> fileData = new HashMap<File, String>();
		Map<File, String> defectiveFiles = new HashMap<File, String>();
		/* ------------------------------------------------------- */
		// iterate over all FileEditPanels
		/* ------------------------------------------------------- */
		for (FileEditPanel panel : filePanels) {
			/* ------------------------------------------------------- */
			// if state is deleted, skip
			/* ------------------------------------------------------- */
			if (panel.getState() == FileEditPanel.STATE_DELETED)
				continue;
			/* ------------------------------------------------------- */
			// if state is ok, do add to list
			/* ------------------------------------------------------- */
			if (panel.getState() == FileImporter.STATE_OK) {
				/* ------------------------------------------------------- */
				fileData.put(panel.getFile(), panel.getDescription());
				/* ------------------------------------------------------- */
			} else {
				/* ------------------------------------------------------- */
				// add to defective list. for optional report
				/* ------------------------------------------------------- */
				defectiveFiles.put(panel.getFile(), panel.getDescription());
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
		}
		/* ------------------------------------------------------- */
		// push the files to the importer
		/* ------------------------------------------------------- */
		// first get the incident
		/* ------------------------------------------------------- */
		Incident selectedIncident = (Incident) incidentBox.getSelectedItem();
		/* ------------------------------------------------------- */
//		if (selectedIncident instanceof String)
//			selectedIncident = null;
		/* ------------------------------------------------------- */
		boolean b = FileImporter.importFiles(fileData,
				(Incident) selectedIncident);
		logger.info("import was " + b);

		/* ================================================== */
	}

	/**
	 * Clears all data
	 */
	private void cleanUp() {
		/* ================================================== */
		this.filePanels.clear();
		this.filePanel.removeAll();
		fileLayout = new FormLayout("fill:pref:grow");
		filePanel.setLayout(fileLayout);
		
		// delete temporarily scanFile
		for (File delFile : deleteFiles) {
			if (delFile != null) {
				if (delFile.exists()) {
					if (!delFile.delete())
						delFile.deleteOnExit();
				}
			}
		}
		/* ================================================== */
	}

	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		if (okButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			// Start import
			/* ------------------------------------------------------- */
			doImport();

			this.cleanUp();
			this.state = true;
			this.setVisible(false);
			/* ------------------------------------------------------- */
		}
		if (cancelButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			// cleanup and close
			/* ------------------------------------------------------- */
			this.cleanUp();
			this.state = false;
			this.setVisible(false);
			/* ------------------------------------------------------- */
		}
		if (addButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			startFileSelection();
			/* ------------------------------------------------------- */
		}
		if (scanJPGButton.equals(e.getSource())) {
			scanFileType = "jpg";
			startScan();
		}
		if (scanPNGButton.equals(e.getSource())) {
			scanFileType = "png";
			startScan();
		}
		if (scanPDFButton.equals(e.getSource())) {
			scanFileType = "pdf";
			startScan();
		}
		if (scanButton.equals(e.getSource()))
		{
			ScannerDialog scannerDialog = new ScannerDialog();
			// Get File list from Dialog
			ArrayList<File> resultFiles = scannerDialog.showDialog();
			
			for (File file : resultFiles)
			{
				createFileEditor(file);
			}
		}
	}

	private boolean startFileSelection() {
		/* ================================================== */
		fileChooser.setMultiSelectionEnabled(true);
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

		this.fileChooser.showOpenDialog(this);

		File[] files = fileChooser.getSelectedFiles();
		/* ------------------------------------------------------- */
		if (files == null || files.length < 1)
			return false;
		/* ------------------------------------------------------- */
		// create new editors
		/* ------------------------------------------------------- */
		for (File f : files) {
			/* ------------------------------------------------------- */
			createFileEditor(f);
			/* ------------------------------------------------------- */
		}
		return true;
		/* ================================================== */
	}

	/**
	 * check if scanner driver are available and init scanner
	 * 
	 */
	private void initScanner()
	{	
		this.scanner = Scanner.getDevice();
		
		this.scannerSupportFlag = NONE; // normal NONE
		
		// check if scanner available over twain interface
		try {
			System.out.println("ScannerLenght: " + scanner.getDeviceNames().length);
			if (this.scanner != null && this.scanner.getDeviceNames() != null && this.scanner.getDeviceNames().length != 0){
				this.scannerSupportFlag = SUPPORT_TWAIN;
				scanner.addListener(new ScannerListener() {
					public void update(ScannerIOMetadata.Type type,
							ScannerIOMetadata metadata) {

						if (type.equals(ScannerIOMetadata.ACQUIRED)) {
							BufferedImage image = metadata.getImage();
							
							try {
								ImageIO.write(image, scanFileType, scanFile);	
							} catch (Exception e) {
								logger.log(Level.WARN, "scanned image can not be save", e);
							}

							createFileEditor(scanFile);
							
							deleteFiles.add(scanFile);
							scanFile = null;
							
							try {
								scanner.setCancel(true);	
							} catch (Exception e) {
								logger.log(Level.WARN, "scanner object can not be close", e);
							}
							
						} else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
							System.out.println("Sane Device ???");
							// ScannerDevice device = metadata.getDevice();
							try {
								// device.setShowUserInterface(true);
								// device.setShowProgressBar(true);
								// device.setResolution(100);
							} catch (Exception e) {
								e.printStackTrace();
							}
						} else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
							logger.info(metadata.getStateStr());
							//System.err.println(metadata.getStateStr());
							if (metadata.isFinished()) {
								// MainFrame.exit(0);
							}
						} else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
							logger.log(Level.WARN, "exception from ScannerListener", metadata.getException());
						}
					}
				});
			}
		} catch (Exception e1) {
			//e1.printStackTrace();
			
		}
		
		
	}
	/**
	 * scan documents as JPG, PNG or PDF and save it in a temporarily file
	 * @return true if scanFile was not null else false
	 */
	private boolean startScan() {
		
		try {
			scanFile = File.createTempFile("gecamedscan_", "." + scanFileType);
		} catch (IOException e) {
			logger.log(Level.WARN, "temporarily file can not be create", e);
		}
		
		//scanner = Scanner.getDevice();
		
		try {
			scanner.acquire();
		} catch (ScannerIOException e) { 
			logger.log(Level.WARN, "scanner can not scan document", e);
		}

		if (scanFile == null)
			return false;
		
		return true;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		/* ====================================================== */
		// TODO Auto-generated method stub
		/* ====================================================== */
	}

	/**
	 * @author martin.heinemann@tudor.lu 12.03.2008 09:12:10
	 * 
	 * 
	 * @version <br>
	 *          $Log: FileImportDialog.java,v $
	 *          Revision 1.29  2014-01-17 11:48:08  ferring
	 *          Files are now attached correctly, with original file name and can be uploaded again
	 *
	 *          Revision 1.28  2013-12-27 18:09:25  donak
	 *          Cleanup of imports
	 *
	 *          Revision 1.27  2013-07-15 06:18:36  ferring
	 *          logging changed
	 *
	 *          Revision 1.26  2013-02-28 13:03:03  ferring
	 *          File will not spread over the panel anymore, but will be displayed right beneath each other
	 *
	 *          Revision 1.25  2013-02-22 08:46:50  kutscheid
	 *          remove the tupel classes (please redeploy)
	 *
	 *          Revision 1.24  2013-02-14 08:35:23  ferring
	 *          incident chooser moved to same line as buttons
	 *
	 *          Revision 1.23  2013-02-14 08:15:18  ferring
	 *          incident selection added to new letters and improved for files
	 *
	 *          Revision 1.22  2013-01-17 14:39:22  troth
	 *          Code clearup.
	 *
	 *          Revision 1.21  2013-01-17 14:09:41  troth
	 *          Fix some Bugs in Scanner Dialog.
	 *
	 *          Revision 1.20  2013-01-17 09:50:52  troth
	 *          Scanner control version 1.
	 *
	 *          Revision 1.19  2013-01-16 16:42:50  troth
	 *          add new Scanner dialog.
	 *
	 *          Revision 1.18  2013-01-16 11:32:48  ferring
	 *          *** empty log message ***
	 *
	 *          Revision 1.17  2013-01-15 17:57:42  ferring
	 *          Add new scan dialog for mac.
	 *
	 *          Revision 1.16  2013-01-15 14:22:55  troth
	 *          Add scanner function for mac os, now it is configure over the user settings. (Testversion)
	 *
	 *          Revision 1.15  2013-01-15 12:44:16  ferring
	 *          add scanner function for mac test version 2
	 *
	 *          Revision 1.14  2013-01-15 11:50:53  troth
	 *          Add scanner function for mac os. (Testversion)
	 *
	 *          Revision 1.13  2013-01-10 12:54:46  ferring
	 *          system exit method changed
	 *
	 *          Revision 1.12  2012-11-16 10:34:55  ferring
	 *          Drag and Drop of files into the patient module will call the FileImportDialog with this files included
	 *
	 *          Revision 1.11  2010-04-26 16:43:13  troth
	 *          Redesign of the prescription view
	 *
	 *          Revision 1.10  2010-03-25 11:25:29  troth
	 *          fix bug attach file dialog not open under apple system
	 *
	 *          Revision 1.9  2010-03-12 14:17:42  hermen
	 *          cleanup of panel layouts and icons
	 *
	 *          Revision 1.8  2010-02-19 11:00:28  troth
	 *          fixed delete problems of temporarily scanner files
	 *
	 *          Revision 1.7  2010-02-18 16:47:54  troth
	 *          add and implement the method startScan to scan documents as JPG, PNG or PDF
	 * <br>
	 *          Revision 1.6 2008-12-15 15:28:51 hermen <br>
	 *          don't show import dialog if filechooser is canceled <br>
	 * <br>
	 *          Revision 1.5 2008-09-25 09:43:06 heinemann <br>
	 *          fixed copyrights <br>
	 * <br>
	 *          Revision 1.4 2008-07-03 11:59:57 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.3 2008-04-10 14:43:05 heinemann <br>
	 *          fixed filechooser problem <br>
	 * <br>
	 *          Revision 1.2 2008-03-12 10:14:07 heinemann <br>
	 *          *** empty log message *** <br>
	 * 
	 */
	class IncidentListBoxRenderer extends DefaultListCellRenderer {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private final DateFormat timeFormatter = DateFormat
				.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing
		 * .JList, java.lang.Object, int, boolean, boolean)
		 */
		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			/* ====================================================== */
			if (value instanceof Incident) {
				/* ------------------------------------------------------- */

				return super.getListCellRendererComponent(list, timeFormatter
						.format(((Incident) value).getIncidentDate()), index,
						isSelected, cellHasFocus);
				/* ------------------------------------------------------- */
			}

			return super.getListCellRendererComponent(list, value, index,
					isSelected, cellHasFocus);
			/* ====================================================== */
		}

	}

}
