/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.patient.gui.fileimport;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

import lu.tudor.santec.gecamed.prescription.gui.util.SystemProperties;

/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 */
/**
 * Advenced  JTextArea with style features
 */
public class NiceTextArea extends JTextArea  {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    
    private LineBorder blackBorder = null;
    private LineBorder whiteBorder = null;
    
    private String initText = ""; 
    
    
    private final Color GREY_COLOR = new Color(240, 240, 240);
    private final Color LIGHT_GREY_COLOR = new Color(254, 254, 254);
    
    public NiceTextArea() {
        this("");
    }
    
    public NiceTextArea(String text) {
        super(text);
        this.initText = text;
        
        super.setFont(SystemProperties.textFieldFont);
        
        // init Borders
        blackBorder = new LineBorder(Color.BLACK);
        whiteBorder = new LineBorder(Color.LIGHT_GRAY);
        setForeground(Color.LIGHT_GRAY);
        
        // init color
        this.setBackground(GREY_COLOR);
        this.setBorder(whiteBorder);
        
        
    
    NiceTextArea.this.addFocusListener(new FocusListener() {
       
        public void focusGained(FocusEvent e) {
//            NiceTextArea.this.setBackground(Color.WHITE);
//            NiceTextArea.this.setForeground(Color.BLACK);
//            NiceTextArea.this.setBorder(blackBorder);
//            if (NiceTextArea.this.getText().equals(NiceTextArea.this.initText)) {
//                // clear the textfield
//                NiceTextArea.this.setText("");
//            }
            onFocusGained();
        }
        
        public void focusLost(FocusEvent e) {
            NiceTextArea.this.setBackground(LIGHT_GREY_COLOR);
            NiceTextArea.this.setBorder(whiteBorder);
            
            if (NiceTextArea.this.getText().equals("")) {
                // put initText
                NiceTextArea.this.setBackground(GREY_COLOR);
                NiceTextArea.this.setText(NiceTextArea.this.initText);
                NiceTextArea.this.setForeground(Color.LIGHT_GRAY);
            }
        }
    });
    
    // prevents tab in the textarea
    this.addKeyListener(new KeyAdapter() {
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == KeyEvent.VK_TAB) {
                evt.consume();
                NiceTextArea.this.transferFocus();
//                NiceTextArea.this.getFocusCycleRootAncestor().requestFocus();
            }
        }
     });
    }
    
    private void onFocusGained() {
        /* ===================================================== */
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setBorder(blackBorder);
        
        // mark all
        this.setSelectionStart(0);
        this.setSelectionEnd(super.getText().length());
        
        if (super.getText().equals(this.initText)) {
            // clear the textfield
            this.setText("");
        }
        /* ===================================================== */
    }
    
    /* --------------------------------------------------------------- */
    
    
    
    
    @Override
    public void setText(String t) {
        super.setText(t);
        if (t != null) {
            if (t.equals(this.initText)) {
                this.setForeground(Color.LIGHT_GRAY);
                this.setBackground(GREY_COLOR);
            }
            else {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_GREY_COLOR);
            }
        }
        else {
            super.setText(initText);
        }
    } 
    
    
    @Override
    public String getText() {
        /* =========================================================== */
        if (super.getText().equals(initText))
            return "";
        else
            return super.getText();
        /* =========================================================== */
    }

    /**
     * Checks whether the textarea is empty or not
     * 
     * @return
     */
    public boolean isEmpty() {
        if (this.getText().equals(this.initText))
            return true;
        else if (this.getText().equals(""))
            return true;
        else 
            return false;
    }
    
    
    /**
     * Resets the textarea
     */
    public void reset() {
        setForeground(Color.LIGHT_GRAY);
        
        // init color
        this.setBackground(GREY_COLOR);
        this.setBorder(whiteBorder);
        
        this.setText(this.initText);
        
    }
    
    
}
