/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.listener.IEntryPrintRenderer;
import lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler;
import lu.tudor.santec.gecamed.core.gui.plugin.filehandler.DefaultEntryDeleteAction;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.core.gui.utils.StringHelper;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.history.table.HistoryTableRenderer;
import lu.tudor.santec.gecamed.patient.gui.settings.ConsultationEntryConfig;
import lu.tudor.santec.gecamed.patient.gui.settings.PatientModuleSettings;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Handler for the SOAP IncidentEntryTypes
 * 
 * @author martin.heinemann@tudor.lu
 * 04.03.2008
 * 10:36:20
 *
 *
 * @version
 * <br>$Log: SoapHandler.java,v $
 * <br>Revision 1.12  2013-09-04 15:33:26  troth
 * <br>The new consultation view with more entries and the sickleave version 2 history view work now.
 * <br>
 * <br>Revision 1.11  2013-02-05 13:15:18  ferring
 * <br>letter status added
 * <br>
 * <br>Revision 1.10  2011-09-26 15:32:23  troth
 * <br>Ticket #824 (new defect) SOAP History shows only one row.
 * <br>
 * <br>Revision 1.9  2011-03-02 12:53:10  ferring
 * <br>history behavior changed
 * <br>
 * <br>Revision 1.8  2010-09-20 13:38:37  troth
 * <br>add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
 * <br>
 * <br>Revision 1.7  2010-09-06 14:28:55  troth
 * <br>Incomplete - # 624: Probleme mit  History-Display von '<'-Zeichen in S.O.A.P. Eintr�gen
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/624
 * <br>
 * <br>Revision 1.6  2009-05-06 15:58:51  heinemann
 * <br>added method to generate printable output of the incident entrys
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-07-10 10:21:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-03-06 15:34:27  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class SoapHandler implements IEntryTypeHandler, IEntryPrintRenderer{

	
//	public static final String SOAP_S = "soap.s";
//	public static final String SOAP_O = "soap.o";
//	public static final String SOAP_A = "soap.a";
//	public static final String SOAP_P = "soap.p";
//	
//	private static HashMap<String, String> shortcut = new HashMap<String, String>();
//	
//	static {
//		
//		
//		/* ------------------------------------------------------- */
//		shortcut.put(SOAP_S, "S");
//		shortcut.put(SOAP_O, "O");
//		shortcut.put(SOAP_A, "A");
//		shortcut.put(SOAP_P, "P");
//		/* ------------------------------------------------------- */
//	}
//	
	
	private SoapRenderer renderer = new SoapRenderer();
	
	private DefaultEntryDeleteAction deleteAction;
	
	public SoapHandler() {
				
		this.deleteAction = new DefaultEntryDeleteAction(
				Translatrix.getTranslationString("patient.incident.soap.buttons.delete"),
				Translatrix.getTranslationString("patient.incident.soap.deleteDialog.title"),
				Translatrix.getTranslationString("patient.incident.soap.deleteDialog.text")
				);
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getRenderer(java.lang.String)
	 */
	public TableCellRenderer getRenderer(String entryType) {
		/* ====================================================== */
		return renderer;
		/* ====================================================== */
	}

	public HashMap<Integer, Object> getSpecialEntries(String entryType, Integer patientId) {
		/* ====================================================== */
		// As the soap is just plain text, except measurments, we do not have to do anything here.
		return null;
		/* ====================================================== */
	}

	
	/**
	 * @author martin.heinemann@tudor.lu
	 * 04.03.2008
	 * 10:46:21
	 *
	 *
	 * @version
	 * <br>$Log: SoapHandler.java,v $
	 * <br>Revision 1.12  2013-09-04 15:33:26  troth
	 * <br>The new consultation view with more entries and the sickleave version 2 history view work now.
	 * <br>
	 * <br>Revision 1.11  2013-02-05 13:15:18  ferring
	 * <br>letter status added
	 * <br>
	 * <br>Revision 1.10  2011-09-26 15:32:23  troth
	 * <br>Ticket #824 (new defect) SOAP History shows only one row.
	 * <br>
	 * <br>Revision 1.9  2011-03-02 12:53:10  ferring
	 * <br>history behavior changed
	 * <br>
	 * <br>Revision 1.8  2010-09-20 13:38:37  troth
	 * <br>add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
	 * <br>
	 * <br>Revision 1.7  2010-09-06 14:28:55  troth
	 * <br>Incomplete - # 624: Probleme mit  History-Display von '<'-Zeichen in S.O.A.P. Eintr�gen
	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/624
	 * <br>
	 * <br>Revision 1.6  2009-05-06 15:58:51  heinemann
	 * <br>added method to generate printable output of the incident entrys
	 * <br>
	 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
	 * <br>fixed copyrights
	 * <br>
	 * <br>Revision 1.4  2008-07-10 10:21:26  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.3  2008-04-09 09:39:43  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.2  2008-03-20 16:08:14  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.1  2008-03-06 15:34:27  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 *   
	 */
	class SoapRenderer extends LineColorCellRenderer {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		
		private final static int fontSize = 9;
		
		/* (non-Javadoc)
		 * @see lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		@Override
		public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {
			/* ====================================================== */
			if (value instanceof IncidentEntry) {
				/* ------------------------------------------------------- */
				IncidentEntry entry = (IncidentEntry) value;
//				IncidentEntryType type = entry.getEntryType();
				// type name
				if (p_Column == 2)
				{
					// get the acronym for the entry
					ConsultationEntryConfig entryConfig	= null;
					PatientModuleSettings patientGlobalSettings = PatientManagerModule.getInstance().patientSettings;
					
					entryConfig = new ConsultationEntryConfig((String) patientGlobalSettings.getValue(entry.getEntryType().getName()));
					/* ------------------------------------------------------- */
					return super.getTableCellRendererComponent(p_Table, entryConfig.getAcronym(), p_IsSelected,
							hasFocus, p_Row, p_Column);
					/* ------------------------------------------------------- */
				} else {
					if (p_Column == 3)
					{
						if (entry.getTextContent() != null)
						{
							String code = "";
							// get the codelabel for the entry
							ConsultationEntryConfig entryConfig	= null;
							PatientModuleSettings patientGlobalSettings = PatientManagerModule.getInstance().patientSettings;
							
							entryConfig = new ConsultationEntryConfig((String) patientGlobalSettings.getValue(entry.getEntryType().getName()));
							if(entry.getCode() != null)
							{
								if(!entry.getCode().equals(""))
									code = "<b>" + entryConfig.getCodeLabel() + ": " + entry.getCode()+"<b><br>";
							}
							
							String s = "";
							if (entry.getTextContent().trim().startsWith("<html>"))
								s = code + entry.getTextContent();
							else
								s = "<html><span style=\"font-family:Arial;font-size:"
									+ fontSize + "px;\">"
									+ code
									+ HistoryTableRenderer.stringFormater(entry.getTextContent());

							return super.getTableCellRendererComponent(p_Table, s,  p_IsSelected,
									hasFocus, p_Row, p_Column);
						}
					}
				}
			}
			return super.getTableCellRendererComponent(p_Table, value, p_IsSelected,
					hasFocus, p_Row, p_Column);
		}
	}


	public Collection<Action> getActions(IncidentEntry entry) {
		List<Action> actions = new ArrayList<Action>();
		this.deleteAction.setEntry(entry);
		actions.add(this.deleteAction);
		
		return actions;
	}
	
	
	public JPopupMenu getPopup(IncidentEntry entry)
	{
		return null;
	}

	public boolean openEntry(IncidentEntry entry) {
		/* ====================================================== */
		PatientManagerModule.getInstance().getPatientPanel().openConsultation(entry);
		return true;
		/* ====================================================== */
	}

	public IEntryPrintRenderer getPrintRenderer(String entryType) {
		/* ====================================================== */
		return this;
		/* ====================================================== */
	}
 
	public String renderPrintEntry(IncidentEntry entry) {
		/* ====================================================== */
		if (entry == null || entry.getTextContent() == null)
			return null;
		/* ------------------------------------------------------- */
		// get the acronym for the entry
		ConsultationEntryConfig entryConfig	= null;
		PatientModuleSettings patientGlobalSettings = PatientManagerModule.getInstance().patientSettings;
		
		entryConfig = new ConsultationEntryConfig((String) patientGlobalSettings.getValue(entry.getEntryType().getName()));
		// remove all html tags from the text
		return entryConfig.getAcronym() + ":\t" + 
				StringHelper.getText(entry.getTextContent());
		/* ====================================================== */
	}

	
}
