/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.antecedents;

import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Antecedents;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.HistoryManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.HistoryManager;

import org.apache.log4j.Logger;

/**
 * List model for the antecedents JList.
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AntecedentsListModel.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:27  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2013-07-15 06:18:39  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.2  2012-12-13 12:35:19  ferring
 * <br>bug in antecedents fixed that created duplicate entries
 * <br>
 * <br>Revision 1.1  2010-03-23 15:13:40  troth
 * <br>Redesign of the patient view history -
 * <br>List model for the antecedents JList
 * <br>
 */
public class AntecedentsListModel extends AbstractListModel {
	
	private static final long serialVersionUID = 1L;
 	 	
 	private HistoryManager manager;

	private static Logger m_Logger = Logger.getLogger ("lu.tudor.santec.gecamed.patient.gui.history.antecedents");

	private Vector<Antecedents> elements = new Vector<Antecedents>();

	private Patient patient;

 	/**
 	 * 
 	 */
 	public AntecedentsListModel() {
 		/* ================================================== */
 		try {
 			/* ------------------------------------------------------- */
 			manager = (HistoryManager) ManagerFactory.getRemote(HistoryManagerBean.class);
 		//	loginManager = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
 			/* ------------------------------------------------------- */
		}
 		catch (Exception p_Exception) {
 			m_Logger.warn(p_Exception.getLocalizedMessage());
 		}
 		/* ================================================== */
 	}

 	/**
	 * @param a
	 * @param pos
	 */
	public void saveAntecedents(Antecedents ant, int pos) 
	{
		try
		{
			ant = manager.saveAntecedents(ant);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			fireIntervalAdded(ant, pos, pos);
		}
	}
	
 	/**
	 * @param a
	 * @param pos
	 */
	public void addAntecedents(Antecedents ant , int pos) 
	{
		try
		{
			if (!ant.isPersistent()) 
 				ant.setPatientId(patient.getId());
			ant = manager.saveAntecedents(ant);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally 
		{
			elements.add(pos, ant);
			fireIntervalAdded(ant, pos, pos);
		}
	}

	/**
	 * @param p
	 */
	public void setPatient(Patient p) {
		/* ================================================== */
		this.patient = p;
		this.elements.removeAllElements();
		try {
			this.elements.addAll(manager.getAntecedentsByPatientID(p.getId()));
		} catch (Exception e) {
			e.printStackTrace();
		}
		fireIntervalAdded(this, 0, elements.size());
		/* ================================================== */
	}
		
	public Vector<Antecedents> getAntecedentsList()
	{
		return elements;
	}

	/**
	 * @param selectedRow
	 */
	public void deleteAntecedent(int selectedRow) {
		/* ================================================== */
		Antecedents ant = elements.get(selectedRow);
		elements.remove(ant);
			try {
				if (ant.isPersistent())
					manager.deleteAntecedents(ant);
			} catch (Exception e) {
				e.printStackTrace();
			}
			fireIntervalRemoved(this, selectedRow, selectedRow);
		/* ================================================== */
	}

	public Object getElementAt(int index) {
		return elements.get(index);
	}

	public int getSize() {
		return elements.size();
	}

	public void repaintAntecedentList()
	{
		this.fireContentsChanged(this, 0, elements.size());
	}
}
