/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.antecedents;

import java.awt.Component;
import java.text.DateFormat;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Antecedents;
import lu.tudor.santec.gecamed.patient.gui.history.ImportantDataPanel;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;


/**
 * Renderer for the AntecedentsList in the ImportentDataPanel
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AntecedentsListRenderer.java,v $
 * <br>Revision 1.1  2010-03-23 15:14:05  troth
 * <br>Redesign of the patient view history -
 * <br>Create renderer for the antecedents list in the ImportentDataPanel
 * <br>
 */
public class AntecedentsListRenderer extends JLabel implements ListCellRenderer {

	private static final long serialVersionUID = 1L;
	
	private LoginInterface loginManager;
	
	private DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT );
    
	private String createdInfo = "";
	
	private String description = "";
	
	private Antecedents ant;
	
	public AntecedentsListRenderer()
	{
		super();
		loginManager = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
	}

	public Component getListCellRendererComponent(
	       JList list,
	       Object value,            // value to display
	       int index,               // cell index
	       boolean isSelected,      // is the cell selected
	       boolean cellHasFocus)    // the list and the cell have the focus
    {
    	
    	ant = (Antecedents) value;  
	    setText(ant.getShortcut());
	    
	    try {
	    	createdInfo = df.format(ant.getCreated()) + " - " + loginManager.getUser(ant.getCreatedBy()).getLogin();
	    } catch (Exception e) {
		}
		
		try {
			description = ant.getDescription().replaceAll("<head>","");
			description = description.replaceAll("</head>","");	
			description = description.replaceAll("<html>","");
			description = description.replaceAll("</html>","");
			description = description.replaceAll("<body>","");
			description = description.replaceAll("</body>","");
		} catch (Exception e) {
		}
		
		setToolTipText("<html><b>" + ant.getShortcut() + "</b><hr>" + description + "<hr><p><small>" + createdInfo + "</small></p></html>");
	    if (isSelected) {
	   		setBackground(list.getSelectionBackground());
		    setForeground(list.getSelectionForeground());
		} else {
			setBackground(list.getBackground());
		    setForeground(ImportantDataPanel.TEXT_COLOR);
		}
		setEnabled(list.isEnabled());
		setFont(list.getFont());
	    setOpaque(true);
	    return this;
	}
}

