/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.antecedents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Antecedents;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientPanel;
import lu.tudor.santec.gecamed.patient.gui.simpleview.OverviewPanel;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Dialog to show all antecedents. It is opened by ImportantDataPanel when the user
 * double-click on the antecedents list. The dialog contains a list with the content of all
 * antecedent attached to the current patient.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AntecedentsViewDialog.java,v $
 * <br>Revision 1.2  2010-10-19 14:37:15  troth
 * <br>rename class SimpleViewPanel in OverviewPanel
 * <br>
 * <br>Revision 1.1  2010-03-23 15:12:04  troth
 * <br>Redesign of the patient view history -
 * <br>Create AntecedentsViewDialog witch show a list with the content of all antecedent attached to the current patient
 * <br>
 */
public class AntecedentsViewDialog extends GECAMedBaseDialog implements ActionListener {

	private static final long serialVersionUID = 1L;

	private static final String CMD_ADD_ANTECEDENTS = "addAntecedents";

	private static final String CMD_DELETE_ANTECEDENTS = "delAntecedents";

	private static final String CMD_CLOSE = "close_windows";

	private static final int MAX_WIDTH = 800;

	private static final int MAX_HEIGHT = 600;

	private Patient patient;

	private JScrollPane scroll;

	private JButton addButton;

	private JButton delButton;

	private JList antecedantsList;

	private int selectIndex;
	
	private AntecedentsListModel antecedentsModel;

	private AntecedentsEditDialog antecedentsEditDialog;

	/**
	 * 
	 */
	public AntecedentsViewDialog(String title, PatientPanel simpleViewPanel,
			AntecedentsListModel antecedentsModel) {

		super(title, true, false);
		this.antecedentsModel = antecedentsModel;
		initComponent();
	}
	
	/**
	 * show and hide the dialog
	 * @param b if b is true show dialog else hide 
	 */
	public void showDialog(boolean b) {

		if (b) {
			antecedantsList.setSelectedIndex(selectIndex);
			antecedentsModel.repaintAntecedentList();
			this.setSize(MAX_WIDTH, MAX_HEIGHT);
			MainFrame.showDialogCentered(this);
		} else
			this.setVisible(false);
	}

	
	/**
	 * set the selected row of the list
	 * @param index specified the selected row of the list 
	 */
	public void setSelectIndex(int index) {
		this.selectIndex = index;
	}

	/**
	 * init all dialog components
	 */
	private void initComponent() {
		// ==================================================
		// create a panel for the antecedantsviews

		antecedantsList = new JList(antecedentsModel);
		antecedantsList.setCellRenderer(new AntecedentsViewDialogRenderer());
		antecedentsEditDialog = new AntecedentsEditDialog(Translatrix
				.getTranslationString("patient.antecedents"));

		antecedantsList.addMouseListener(new MouseListener() {

			public void mouseClicked(MouseEvent e) {

				Antecedents antecedents;
				if (e.getClickCount() >= 2) {
					antecedents = (Antecedents) antecedantsList
							.getSelectedValue();
					antecedentsEditDialog.showDialog(antecedents,
							antecedentsModel, false);
					antecedentsModel.repaintAntecedentList();
					antecedantsList.validate();
					antecedantsList.update(antecedantsList.getGraphics());
				}
			}

			public void mouseReleased(MouseEvent e) {}
			public void mousePressed(MouseEvent e) {}
			public void mouseExited(MouseEvent e) {}
			public void mouseEntered(MouseEvent e) {}
		});

		this.scroll = new JScrollPane(antecedantsList);

		this.addButton = OverviewPanel.createButton(GECAMedModule
				.getMediumIcon(GECAMedIconNames.ADD_LINE), CMD_ADD_ANTECEDENTS,
				this);

		this.delButton = OverviewPanel.createButton(GECAMedModule
				.getMediumIcon(GECAMedIconNames.REMOVE_LINE),
				CMD_DELETE_ANTECEDENTS, this);
		this.addButton(addButton);
		this.addButton(delButton);
		this.addMainPanel(scroll);

	}

	/**
	 * set the patient
	 * @param patient specified patient
	 */
	public void setPatient(Patient patient) {
		/* ================================================== */
		this.patient = patient;
		/* ================================================== */
	}

	/**
	 * add the selected antecedents of the list
	 */
	public void addAntecedents() {
		antecedentsEditDialog.showDialog(new Antecedents(),
				this.antecedentsModel, true);
	}

	/**
	 * delete the selected antecedents of the list
	 */
	public void delAntecedents() {
		int row = antecedantsList.getSelectedIndex();
		if (row >= 0)
			antecedentsModel.deleteAntecedent(antecedantsList
					.getSelectedIndex());
	}


	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		// ======================================================
		// Antecedents add
		if (CMD_ADD_ANTECEDENTS.equals(e.getActionCommand())) {
			addAntecedents();
		}
		// Antecedents delete
		if (CMD_DELETE_ANTECEDENTS.equals(e.getActionCommand())) {
			delAntecedents();
		}
		// Dialog close
		if (CMD_CLOSE.equals(e.getActionCommand())) {
			this.showDialog(false);
		}
		// ======================================================
	}
}
