/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.table;

import java.util.Vector;

import lu.tudor.santec.gecamed.core.gui.utils.IChangeListener;
import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.FilterTableModel;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.history.HistoryDataAgent;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

/**
 * Table model for the medicall history listing.
 * It is working on a vector of HistoryElements.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 21.01.2008
 * 15:27:35
 *
 *
 * @version
 * <br>$Log: HistoryTableModel.java,v $
 * <br>Revision 1.34  2014-02-17 14:04:31  ferring
 * <br>Editing file entries by clicking removed, context menu option to edit description and file name added instead
 * <br>
 * <br>Revision 1.33  2013-10-11 14:59:09  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.32  2012-03-13 12:11:22  ferring
 * <br>Form types are now separated by the code column in of the table incident_entry
 * <br>
 * <br>Revision 1.31  2010-10-19 09:54:29  troth
 * <br>change structure of updating history views to make the loading of patient faster
 * <br>
 * <br>Revision 1.30  2010-10-13 15:02:53  troth
 * <br>Add new dialog to the main menu bar for delete the incidents how have no incident entries.
 * <br>
 * <br>Revision 1.29  2010-10-07 12:50:43  troth
 * <br>Complete - # 617: Can't search for prescription text in history view
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/617
 * <br>
 * <br>Revision 1.28  2010-08-24 12:49:40  troth
 * <br>fix small bug - to open consultation over the accident entry in the patient history
 * <br>
 * <br>Revision 1.27  2010-06-15 07:57:36  troth
 * <br>bug fix - if last entry in table was deleted there was one null-line rendered
 * <br>
 * <br>Revision 1.26  2010-04-26 16:40:00  troth
 * <br>Redesign of the prescription view
 * <br>
 * <br>Revision 1.25  2009-12-14 15:34:31  hermen
 * <br>fixed NULL entries in history
 * <br>
 * <br>Revision 1.24  2009-06-03 09:23:40  hermen
 * <br>fixed npe on empty physician name
 * <br>
 * <br>Revision 1.23  2008-10-01 13:15:29  heinemann
 * <br>fixed possible nullpointer when the physician id of an incident is null
 * <br>
 * <br>Revision 1.22  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.21  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.20  2008-06-11 13:13:43  hermen
 * <br>fixed getHistoryData
 * <br>
 * <br>Revision 1.19  2008-06-03 12:59:11  weitz
 * <br>*letter package, release candidate
 * <br>
 * <br>Revision 1.18  2008-05-13 08:23:28  heinemann
 * <br>bug fix. Open consultation did not function very well in the case that an incident does not have any entries.
 * <br>
 * <br>Revision 1.17  2008-04-11 14:47:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.16  2008-04-09 14:47:05  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.15  2008-04-09 12:53:59  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.14  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.13  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.12  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-01-22 13:51:52  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class HistoryTableModel extends FilterTableModel implements IChangeListener {
	
 	private static final long serialVersionUID = 1L;
 	
 	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(HistoryTableModel.class.getName());

	/**
	 * Headers for the JTable
	 */
	private final static String[] columns = {
		Translatrix.getTranslationString("patient.history.date"),
		Translatrix.getTranslationString("patient.history.physician"),
		Translatrix.getTranslationString("patient.history.type"),
		Translatrix.getTranslationString("patient.history.description")
	};

//	private boolean isFiltered = false;

	private Vector<HistRow> cacheData =  new Vector<HistRow>(0);

	private HistoryDataAgent agent;

	private boolean debug;

//	private int instance;

//	private static int instances;
	

	/**
	 * 
	 */
	public HistoryTableModel(HistoryDataAgent agent) {
		/* ================================================== */
//		instances++;
//		this.instance = instances;
 		this.agent = agent;
 		this.agent.addUpdateListener(this);
		/* ================================================== */
	}
	

	/* (non-Javadoc)
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		
		if (debug) {
			System.out.println("---- ROWS: " + getFilteredRowCount() + " -----");
		}
		/* ================================================== */
//		return cacheData.size();
		return this.getFilteredRowCount();
		/* ================================================== */
	}

	public int getColumnCount() {
		/* ================================================== */
		return columns.length;
		/* ================================================== */
	}

	@Override
	public String getColumnName(int column) {
		return columns[column];
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		/* ================================================== */
//		if (columnIndex == 3)
//			return true;
		return false;
		/* ================================================== */
	}

	
	public Object getValueAt(int rowIndex, int columnIndex) {
		/* ================================================== */
		if (rowIndex < 0)
			return null;
		/* ------------------------------------------------------- */
		HistRow histRow = null;
		
		
		
		int row = 0;
		
		// get row index
		if (this.isFiltering()) {
			row = this.filteredToModel(rowIndex);			
		} else {
			row = rowIndex;			
		}
		 
		if (debug && columnIndex == 0) {
			System.out.println("HistoryFilter: " + this.isFiltering() + " " + rowIndex + " -> " + row);			
		}
		
		try {
			/* --------------------------------------------- */
			// model empty -> return null.
			if(cacheData.size() <= 0) {
				return null;				
			}
			
			histRow = cacheData.get(row);
			
			/* --------------------------------------------- */
		} catch (Exception e) {
			/* --------------------------------------------- */
		    logger.error("Error getting History Model Row", e);
			/* --------------------------------------------- */
		}
		if (histRow == null)
			return null;
		
		/* ------------------------------------------------------- */
		switch (columnIndex) {
		case 0:
			return histRow.getCol0();
		case 1:
			return histRow.getCol1();
		case 2:
			return histRow.getCol2();
		case 3:
			return histRow.getCol3();
		case 4:
			return histRow.getCol4();
		default:
			return "";
		}
		/* ================================================== */
	}
	
	
	/* (non-Javadoc)
	 * @see javax.swing.table.AbstractTableModel#setValueAt(java.lang.Object, int, int)
	 */
	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		/* ====================================================== */
		if (columnIndex == 3) {
			/* ------------------------------------------------------- */
			if (aValue instanceof IncidentEntry) {
				/* ------------------------------------------------------- */
				agent.saveEntry((IncidentEntry) aValue);
				/* ------------------------------------------------------- */
				// rebuild the view structure
				/* ------------------------------------------------------- */
//				createCacheData(agent.getIncidents().values());
				updateDate();
				
				/* ------------------------------------------------------- */
				// compute the filtered row
				/* ------------------------------------------------------- */
				
				int row = 0;
				if (this.isFiltering())
					row = this.filteredToModel(rowIndex);
				else
					row = rowIndex;
				
				/* ------------------------------------------------------- */
				// update row
				/* ------------------------------------------------------- */
				fireTableCellUpdated(row, columnIndex);
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
		}
		/* ====================================================== */
	}

	private void updateDate() {
		this.cacheData = agent.getCacheData();
		this.setTableData(cacheData);
	}


	public Incident getIncidentByRow(int row) {
		/* ================================================== */
		return agent.getIncidentByRow(row);
		/* ================================================== */
	}
	
	
//	/**
//	 * @param incidentList
//	 */
//	private void createCacheData(Collection<Incident> incidentList) {
//		long start = System.currentTimeMillis();
//		/* ================================================== */
//		this.cacheData.clear();
//		/* ------------------------------------------------------- */
//		if (incidentList == null)
//			return;
//		/* ------------------------------------------------------- */
//		for (Incident i : incidentList) {
//			/* ------------------------------------------------------- */
//			// create a row for the incident
//			HistRow row = null;
//			int startAt = 0;
//			if (i.getIsAccident()) {
//				/* ------------------------------------------------------- */
//				String docString = "";
//				if (i.getPhysicianId() != null)
//					docString = agent.getPhysicians().get(i.getPhysicianId()).getMnemonic();
//				/* ------------------------------------------------------- */
//				row = new HistRow(i.getIncidentDate(), 
////								  agent.getPhysicians().get(i.getPhysicianId()).getMnemonic(),
//								  docString,
//								  createAccident(i));
//				/* ------------------------------------------------------- */
//			} else {
//				/* ------------------------------------------------------- */
//				// we take the first entry for the first line
//				/* ------------------------------------------------------- */
//				if (i.getIncidentEntries() != null && i.getIncidentEntries().size() > 0) {
//					/* ------------------------------------------------------- */
//					String docString = "";
//					try {
//					    docString = agent.getPhysicians().get(i.getPhysicianId()).getMnemonic();
//					} catch (Exception e) {}
//					/* ------------------------------------------------------- */
//					
//					IncidentEntry entryCopy = new IncidentEntry(i.getIncidentEntries().get(0));
////					long subStart = System.currentTimeMillis();
////					entryCopy = modifyEntryIfPrescription(entryCopy);
////					logger.info("modifyEntryIfPrescription took: " + ( System.currentTimeMillis()-subStart));
//					
//					row = new HistRow(i.getIncidentDate(), 
////							agent.getPhysicians().get(i.getPhysicianId()).getMnemonic(),
//							docString,
//									  //i.getIncidentEntries().get(0));
//					entryCopy);
//					/* ------------------------------------------------------- */
//				} 
//				/* ------------------------------------------------------- */
//				// skip the first entry. We used it already
//				startAt = 1;
//				/* ------------------------------------------------------- */
//			}
//			if (row != null)
//			    cacheData.add(row);
//			else {
//			    logger.fine("incident " + i.getId() + ":" + i + " is not shown in history because it is no accident and has no attached IncidentEntries - this should not happen" );
//			}
//			/* ------------------------------------------------------- */
//			// now iterate over the rest entries
//			/* ------------------------------------------------------- */
//			int count = 0;
//			if (i.getIncidentEntries() != null) {
//				for (IncidentEntry entry : i.getIncidentEntries()) {
//					/* ------------------------------------------------------- */
//					if (count == startAt) {
//						/* ------------------------------------------------------- */
//						String docString = "";
//						if (i.getPhysicianId() != null)
//							docString = agent.getPhysicians().get(i.getPhysicianId()).getMnemonic();
//						
//						IncidentEntry entryCopy = new IncidentEntry(entry);
//						
////						long subStart = System.currentTimeMillis();
////						entryCopy = modifyEntryIfPrescription(entryCopy);
////						logger.info("modifyEntryIfPrescription took: " + ( System.currentTimeMillis()-subStart));
//						
//						
//						/* ------------------------------------------------------- */
//						row = new HistRow(i.getIncidentDate(), 
////								agent.getPhysicians().get(i.getPhysicianId()).getMnemonic(), 
//								docString,
//								entryCopy);
//						cacheData.add(row);
//						/* ------------------------------------------------------- */
//					} else
//						count++;
//					/* ------------------------------------------------------- */
//				}
//			}
//			/* ------------------------------------------------------- */
//		}
//		this.setTableData(cacheData);
//		logger.info("creatingCacheData in HistoryTableModel No." + instance + " of " + instances + " ID" + this.hashCode() + " took: " + ( System.currentTimeMillis()-start));
//		/* ================================================== */
//	}
	
//	/**
//	 * modify the incident entry if it is a prescription to search over it in the HistoryViewTab. the text content of the prescription entry
//	 * is copy to the text content of the incident entry.
//	 *  
//	 * @param incidentEntry to modify
//	 * @return incidentEntry the modified entry
//	 */
//	private IncidentEntry modifyEntryIfPrescription(IncidentEntry incidentEntry)
//	{
//		// look if entry is a prescription
//		if (incidentEntry.getEntryType().getName().equals(
//				PrescriptionManager.ENTRY_TYPE)) {
//
//			if (incidentEntry.getId() != null) {
//
//				// if yes modify it
//				PrescriptionManager manager = (PrescriptionManager) ManagerFactory
//						.getRemote(PrescriptionManagerBean.class);
//
//				List<Prescription> prescriptionList = manager
//						.getPrescriptionByIncidentEntry(incidentEntry.getId());
//
//				if (prescriptionList != null && prescriptionList.size() > 0) {
//					Prescription prescription = prescriptionList.get(0);
//					incidentEntry.setTextContent(prescription.getTextContent());
//				}
//			}
//		}
//		return incidentEntry;
//	}
//	/**
//	 * Creates an accident entry for the incident
//	 * 
//	 * @param incident
//	 */
//	private IncidentEntry createAccident(Incident incident) {
//		/* ================================================== */
//		
//		/* ------------------------------------------------------- */
//		IncidentEntry ae = new IncidentEntry();
//		
//		IncidentEntryType accType = new IncidentEntryType();
//		accType.setName("Ac");
//		ae.setEntryType(accType);
//		ae.setIncidentId(incident.getId());
//		
//		String s = incident.getAccidentNr();
//		if (incident.getAccidentDate() != null)
//			s += " " + incident.getAccidentDate();
//		
//		ae.setTextContent("<html><span style=\"font-family:Arial;font-size:"
//					+ "9" + "px;\">"
//					+ s.replaceAll("\n", "<br>"));
//		/* ------------------------------------------------------- */
//		return ae;
//		/* ================================================== */
//	}
//	
	
	/**
	 * @param entryId
	 * @return
	 */
	public Object getSpecialEntry(Integer entryId) {
		/* ================================================== */
		return agent.getExtendedEntries().get(entryId);
		/* ================================================== */
	}
	
	
	/**
	 * @param selectedRow
	 * @return
	 */
	public int getIncidentId(int selectedRow) {
		/* ================================================== */
		return agent.getIncidentByRow(selectedRow).getId();
		/* ================================================== */
	}
	
	/**
	 * @param selectedRow
	 * @return
	 */
	public IncidentEntry getIncidentEntry(int selectedRow) {
		/* ================================================== */
		return (IncidentEntry) getValueAt(selectedRow, 2);
		/* ================================================== */
	}

	
	public Vector<HistRow> getHistoryData() {
		/* ================================================== */
		return this.cacheData;
		/* ================================================== */
	}
	

	public void setFilterIncident(Incident incident) {
		/* ================================================== */
//		this.filterIncident = incident;
//		/* ------------------------------------------------------- */
//		if (filterIncident == null) {
//			this.isFiltered = false;
//			// reset
//			if (this.elementsSave != null && this.elementsSave.size() > 0) {
//				/* ------------------------------------------------------- */
//				this.elements.clear();
//				this.elements.addAll(elementsSave);
//				elementsSave.removeAllElements();
//
//				fireTableDataChanged();
//				/* ------------------------------------------------------- */
//			}
//		} else {
//			/* ------------------------------------------------------- */
//			if (filterIncident.getChildren() == null)
//				return;
//			this.isFiltered = true;
//			/* ------------------------------------------------------- */
//			// move elements
//			if (this.elementsSave == null)
//				elementsSave = new Vector<HistoryElement>();
//			/* ------------------------------------------------------- */
//			elementsSave.addAll(elements);
//			// clear vector
//			elements.clear();
//			/* ------------------------------------------------------- */
//			// find the current incident
//			for (HistoryElement hel : elementsSave)
//				if (hel.getIncidentId().equals(incident.getId()))
//					elements.add(hel);
//			/* ------------------------------------------------------- */
//			// find all children of the incident
//			for (HistoryElement he : elementsSave)
//				for (Incident i : filterIncident.getChildren())
//					if (i.getId().equals(he.getIncidentId()))
//						elements.add(he);
//			/* ------------------------------------------------------- */
//			fireTableDataChanged();
//		}
		/* ================================================== */
	}

	public boolean isFiltered() {
		/* ================================================== */
		return this.isFiltering();
		/* ================================================== */
	}
	
	
	public void fireEvent() {
		/* ====================================================== */
		if (debug) System.out.println(" UPDATE DATA ");
		
		updateDate();
		fireTableDataChanged();
		/* ====================================================== */
	}
	
//	protected void finalize() throws Throwable
//	{
//		instances--;
//	}

	
//	/**
//	 * @author martin.heinemann@tudor.lu
//	 * 10.03.2008
//	 * 10:01:31
//	 *
//	 *
//	 * @version
//	 * <br>$Log: HistoryTableModel.java,v $
//	 * <br>Revision 1.34  2014-02-17 14:04:31  ferring
//	 * <br>Editing file entries by clicking removed, context menu option to edit description and file name added instead
//	 * <br>
//	 * <br>Revision 1.33  2013-10-11 14:59:09  ferring
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.32  2012-03-13 12:11:22  ferring
//	 * <br>Form types are now separated by the code column in of the table incident_entry
//	 * <br>
//	 * <br>Revision 1.31  2010-10-19 09:54:29  troth
//	 * <br>change structure of updating history views to make the loading of patient faster
//	 * <br>
//	 * <br>Revision 1.30  2010-10-13 15:02:53  troth
//	 * <br>Add new dialog to the main menu bar for delete the incidents how have no incident entries.
//	 * <br>
//	 * <br>Revision 1.29  2010-10-07 12:50:43  troth
//	 * <br>Complete - # 617: Can't search for prescription text in history view
//	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/617
//	 * <br>
//	 * <br>Revision 1.28  2010-08-24 12:49:40  troth
//	 * <br>fix small bug - to open consultation over the accident entry in the patient history
//	 * <br>
//	 * <br>Revision 1.27  2010-06-15 07:57:36  troth
//	 * <br>bug fix - if last entry in table was deleted there was one null-line rendered
//	 * <br>
//	 * <br>Revision 1.26  2010-04-26 16:40:00  troth
//	 * <br>Redesign of the prescription view
//	 * <br>
//	 * <br>Revision 1.25  2009-12-14 15:34:31  hermen
//	 * <br>fixed NULL entries in history
//	 * <br>
//	 * <br>Revision 1.24  2009-06-03 09:23:40  hermen
//	 * <br>fixed npe on empty physician name
//	 * <br>
//	 * <br>Revision 1.23  2008-10-01 13:15:29  heinemann
//	 * <br>fixed possible nullpointer when the physician id of an incident is null
//	 * <br>
//	 * <br>Revision 1.22  2008-09-25 09:43:08  heinemann
//	 * <br>fixed copyrights
//	 * <br>
//	 * <br>Revision 1.21  2008-07-03 11:59:57  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.20  2008-06-11 13:13:43  hermen
//	 * <br>fixed getHistoryData
//	 * <br>
//	 * <br>Revision 1.19  2008-06-03 12:59:11  weitz
//	 * <br>*letter package, release candidate
//	 * <br>
//	 * <br>Revision 1.18  2008-05-13 08:23:28  heinemann
//	 * <br>bug fix. Open consultation did not function very well in the case that an incident does not have any entries.
//	 * <br>
//	 * <br>Revision 1.17  2008-04-11 14:47:41  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.16  2008-04-09 14:47:05  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.15  2008-04-09 12:53:59  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.14  2008-04-09 09:39:43  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.13  2008-03-20 16:08:14  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 * <br>Revision 1.12  2008-03-10 12:37:52  heinemann
//	 * <br>*** empty log message ***
//	 * <br>
//	 *   
//	 */
//	public class HistRow {
//		
//		
//		private Date date;
//		private String docMnemonic;
//		private IncidentEntry entry;
//		
//		
//		/**
//		 * @param date
//		 * @param doc
//		 * @param entry
//		 */
//		public HistRow(Date date, String doc, IncidentEntry entry) {
//			/* ================================================== */
//			this.date = date;
//			this.docMnemonic = doc;
//			this.entry = entry;
//			/* ================================================== */
//		}
//		
//		
//		/**
//		 * @return
//		 */
//		public Date getCol0() {
//			/* ================================================== */
//			return date;
//			/* ================================================== */
//		}
//		
//		/**
//		 * @return
//		 */
//		public String getCol1() {
//			/* ================================================== */
//			return docMnemonic;
//			/* ================================================== */
//		}
//		
//		/**
//		 * @return
//		 */
//		public IncidentEntry getCol2() {
//			/* ================================================== */
//			return entry;
//			/* ================================================== */
//		}
//		
//		/**
//		 * @return
//		 */
//		public IncidentEntry getCol3() {
//			/* ================================================== */
//			return entry;
//			/* ================================================== */
//		}
//
//
//		public IncidentEntry getEntry() {
//			/* ================================================== */
//			return entry;
//			/* ================================================== */
//		}
//
//
//		public void setEntry(IncidentEntry entry) {
//			/* ================================================== */
//			this.entry = entry;
//			/* ================================================== */
//		}
//		
//	}


 public void enableDebug() {
	 debug = true;
 }
 
 public String createLog() {
		StringBuffer sb = new StringBuffer("------------------	HistoryTableModel 	---------------------------\n");
		for (int i = 0; i < getRowCount(); i++) {
			int row = 0; 
			if (this.isFiltering()) {
				row = this.filteredToModel(i);			
			} else {
				row = i;			
			}
			HistRow histRow = cacheData.get(row);
			sb.append(i + "->" + row + "\t").append(histRow).append("\n");
		}
		sb.append("----------------------------------------------------------------------------\n");
		return sb.toString();
	}

}
