package lu.tudor.santec.gecamed.patient.gui.history.table;

import java.awt.Dimension;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: NoHandlerForEntryDialog.java,v $
 * <br>Revision 1.1  2013-02-28 13:19:42  ferring
 * <br>If a module for a history entry is not loaded, a message is shown telling the user and providing the option to delete this entry
 * <br>
 */

public class NoHandlerForEntryDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private IncidentEntry	entry;
	
	private JLabel			descriptionLabel;
	
	private JButton			deleteButton;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public NoHandlerForEntryDialog()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("History.NoPopupHandler.title"), 
				OK_BUTTON_MODE);
		
		descriptionLabel	= new JLabel();
		
		mainPanel.setLayout(new FormLayout("10px, f:p:g, 10px", "10px, f:p:g, 25px"));
		mainPanel.add(descriptionLabel, new CellConstraints(2, 2));
		
		deleteButton		= new JButton(new AbstractAction(
				Translatrix.getTranslationString("core.delete"),
				GECAMedModule.getMediumIcon(GECAMedIconNames.REMOVE))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
				deleteActionCalled();
			}
		});
		addButton(deleteButton);
		deleteButton.setPreferredSize(new Dimension(deleteButton.getPreferredSize().width, 28));
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void setEntry (IncidentEntry entry)
	{
		this.entry	= entry;
	}
	
	
	@Override
	public void prepareToShowUp()
	{
		super.prepareToShowUp();
		
		descriptionLabel.setText(
				Translatrix.getTranslationString("History.NoPopupHandler.message", 
				new String[] { entry.getEntryType().getName() }));
		
		pack();
		setLocationRelativeTo(getOwner());
		
		getOKButton().requestFocus();
	}
	
	
	public void deleteActionCalled ()
	{
		IncidentManager manager	= (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
		manager.deleteIncidentEntry(entry.getId());
		PatientManagerModule.getInstance().getPatientPanel().reloadHistory();
		
		super.okActionCalled();
	}
}
