package lu.tudor.santec.gecamed.patient.gui.history.table.filter;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

public class HistoryCodeFilter implements TableFilter
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String searchText = "";
	
	private boolean filter = false;
	
	
	
	/* ======================================== */
	// 		IMPLEMENTED METHODS
	/* ======================================== */
	
	public boolean accept(Object p_Value) 
	{
		String  		code;
		IncidentEntry 	entry;
		boolean 		accept;
		
		if (searchText == null || "".equals(searchText))
			accept 	= true;
		
		else if (p_Value instanceof String)
			accept 	= searchText.equals(p_Value);
		
		else if (p_Value instanceof IncidentEntry) 
		{
			entry 	= (IncidentEntry) p_Value;
			code 	= entry.getCode();
			accept 	= searchText.equals(code);
		}
		else accept = false;
		
		return accept;
	}
	
	
	public void compile() { }
	
	
	public boolean isFiltering() 
	{
		return filter;
	}
	
	
	public void setFiltering (boolean filter)
	{
		this.filter = filter;
	}
	
	
	public void setFilter(Object p_FilterValue) 
	{
		if (p_FilterValue instanceof String) 
			this.searchText = (String) p_FilterValue;
	}
}
