/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.table.filter;

import java.util.Date;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;

/**
 * @author martin.heinemann@tudor.lu
 * 27.06.2008
 * 10:18:59
 *
 *
 * @version
 * <br>$Log: HistoryDateFilter.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class HistoryDateFilter implements TableFilter{

	private Date fromDate = null;
	private Date toDate   = null;

	public boolean accept(Object p_Value) {
		/* ====================================================== */
		if (p_Value instanceof Date) {
			/* ------------------------------------------------------- */
			Date date = (Date) p_Value;
			/* ------------------------------------------------------- */
			// if both are set
			/* ------------------------------------------------------- */
			if (toDate != null && fromDate != null) {
				/* ------------------------------------------------------- */
				if (fromDate.after(date) && toDate.before(date))
					return true;
				/* ------------------------------------------------------- */
			} else {
				if (toDate != null)
					if (toDate.after(date))
						return true;
				if (fromDate != null)
					if (fromDate.before(date))
						return true;
			}
			/* ------------------------------------------------------- */
		}
		return false;
		/* ====================================================== */
	}

	public void compile() {
		/* ====================================================== */
		
		/* ====================================================== */
	}

	public boolean isFiltering() {
		/* ====================================================== */
		return true;
		/* ====================================================== */
	}

	/*** 
	 * @deprecated use setFromFilter and setToFilter instead
	 */
	public void setFilter(Object p_FilterValue) {
		/* ====================================================== */
		
		/* ====================================================== */
	}
	
	
	/**
	 * @param from
	 */
	public void setFromFilter(Date from) {
		/* ================================================== */
		this.fromDate = from;
		/* ================================================== */
	}
	
	/**
	 * @param to
	 */
	public void setToFilter(Date to) {
		/* ================================================== */
		this.toDate = to;
		/* ================================================== */
	}
	
	
	
	
}
