/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.table.filter;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * @author martin.heinemann@tudor.lu
 * 27.06.2008
 * 10:18:59
 *
 *
 * @version
 * <br>$Log: HistoryFulltextFilter.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class HistoryFulltextFilter implements TableFilter{

	private String searchText = "";

	public boolean accept(Object p_Value) {
		/* ====================================================== */
		if (p_Value instanceof IncidentEntry) {
			/* ------------------------------------------------------- */
			IncidentEntry entry 	= (IncidentEntry) p_Value;
			
			/* ------------------------------------------------------- */
			boolean matching = false;
			/* ------------------------------------------------------- */
			// empty string is not matching anything
			/* ------------------------------------------------------- */
			if ("".equals(searchText))
				return false;
			/* ------------------------------------------------------- */
			// lookup in the text content
			/* ------------------------------------------------------- */
			if (compare(entry.getTextContent(), searchText))
				matching = true;
			/* ------------------------------------------------------- */
			// file name lookup
			/* ------------------------------------------------------- */
			if (compare(entry.getFileName(), searchText))
				matching = true;
			/* ------------------------------------------------------- */
			// code
			/* ------------------------------------------------------- */
			if (compare(entry.getCode(), searchText))
				matching = true;
			/* ------------------------------------------------------- */
			// accident
			/* ------------------------------------------------------- */
			
			return matching;
			/* ------------------------------------------------------- */
		}
		return false;
		/* ====================================================== */
	}

	
	/**
	 * Checks if s1 contains s2
	 * 
	 * @param s1
	 * @param s2
	 * @return
	 */
	private boolean compare(String s1, String s2) {
		/* ================================================== */
		if (s1 == null || s2 == null)
			return false;
		/* ------------------------------------------------------- */
		return s1.toUpperCase().contains(s2.toUpperCase());
		/* ================================================== */
	}
	
	public void compile() {
		/* ====================================================== */
		
		/* ====================================================== */
	}

	public boolean isFiltering() {
		/* ====================================================== */
		return true;
		/* ====================================================== */
	}

	public void setFilter(Object p_FilterValue) {
		/* ====================================================== */
		if (p_FilterValue instanceof String) 
			this.searchText  = ((String) p_FilterValue).trim();
		/* ====================================================== */
	}

}
