/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.hospitalisation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.patient.ejb.entity.interfaces.HospitalisationElement;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;

public class HospitalisationTableRenderer extends JEditorPane implements TableCellRenderer 
	{

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final long serialVersionUID = 1L;
    private static final int   c_Gap   = 2;
    
	public static final Color c_OddColor  = new Color (237,243,254);
	public static final Color c_EvenColor = new Color (255,255,255);
    
	public static final ImageIcon ICON_HOSP = IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.HOSPITALISATION);
	public static final ImageIcon ICON_ACCIDENT = IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.ACCIDENT);
	public static final ImageIcon ICON_PASSAGE_VERIFIED = IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.PASSAGE_VERIFIED);
	public static final ImageIcon ICON_PASSAGE_UNVERIFIED = IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.PASSAGE_UNVERIFIED);
	public static final ImageIcon ICON_RX = IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.RX);
	
	
    private static final LineColorCellRenderer dateRenderer = new LineColorCellRenderer();
    private static final LineColorCellRenderer rxRenderer = new LineColorCellRenderer();
    private static final LineColorCellRenderer typeRenderer = new LineColorCellRenderer();
    private static final LineColorCellRenderer physicianRenderer = new LineColorCellRenderer();
    private static final LineColorCellRenderer descRenderer = new LineColorCellRenderer();
	private HospitalisationTableModel model;
	private Font f = new Font("Arial", Font.BOLD, 12);
	private Font f1 = new Font("Arial", Font.BOLD, 12);
	private Font f2 = new Font("Arial", Font.PLAIN, 14);
	DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT );
	private Border b = BorderFactory.createMatteBorder(1,0,0,0,Color.BLUE);
	
	
	
public HospitalisationTableRenderer(HospitalisationTableModel model) 
	{
	this.model = model;
	setContentType("text/html");
	setFont(f2);
	this.setBorder(BorderFactory.createEmptyBorder (c_Gap,c_Gap,c_Gap,c_Gap));	
	}

public Component getTableCellRendererComponent(JTable p_Table, Object
          value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) 	{
	
	// look if this line is a new Incident
	boolean newHosp = true;
	try {
		newHosp = ( model.getValueAt(p_Row, 0) != null) ;
	} catch (Exception e) {}
	
	// draw the columns
	switch (p_Column) {
	// the date
	case 0:
		String text = "";
		if ( newHosp) {
			text = df.format(value);
		} 		
		JLabel c = (JLabel)dateRenderer.getTableCellRendererComponent(p_Table, text, p_IsSelected, hasFocus, p_Row, p_Column);
		c.setFont(f);
		if (newHosp)
			c.setBorder(b );
		else
			c.setBorder(null);
		return c;		
	// the physician
	case 1:
		text = (String)value;
		JLabel c1 = (JLabel)physicianRenderer.getTableCellRendererComponent(p_Table, text, p_IsSelected, hasFocus, p_Row, p_Column);
		c1.setFont(f);
		if (newHosp)
			c1.setBorder(b );
		else
			c1.setBorder(null);
		return c1;
	// the type
	case 2:
		JLabel c2 = (JLabel) typeRenderer.getTableCellRendererComponent(p_Table, "", p_IsSelected, hasFocus, p_Row, p_Column);
		c2.setIcon(getHistoryTypeShortCut((Integer) value, p_Row));
		c2.setFont(f1);
		c2.setHorizontalAlignment(JLabel.CENTER);
		if (newHosp)
			c2.setBorder(b );
		else
			c2.setBorder(null);
		return c2;
	//		RX
	case 3:
		JLabel c3 = (JLabel) rxRenderer.getTableCellRendererComponent(p_Table, "", p_IsSelected, hasFocus, p_Row, p_Column);
		if ((Boolean)value) {
			c3.setIcon(ICON_RX);			
		} else {
			c3.setIcon(null);
		}
		
		c3.setFont(f1);
		c3.setHorizontalAlignment(JLabel.CENTER);
		if (newHosp)
			c3.setBorder(b );
		else
			c3.setBorder(null);
		return c3;
	// the desc.
	case 4:
		JLabel c4 = (JLabel) descRenderer.getTableCellRendererComponent(p_Table, (String) value, p_IsSelected, hasFocus, p_Row, p_Column);
		c4.setFont(f2);
		c4.setHorizontalAlignment(JLabel.LEFT);
		c4.setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(),
	              c4.getPreferredSize().height);

	    c4.setToolTipText(model.getHospitalisationElement(p_Row).getToolTip());
	    if (p_Table.getRowHeight(p_Row) < c4.getPreferredSize().height) {
	    	p_Table.setRowHeight(p_Row, c4.getPreferredSize().height + 4);
	      }
	    
	    if (newHosp)
			c4.setBorder(b );
		else
			c4.setBorder(null);
	    
		return c4;
	default:
		break;
	}
      return this;
  }

	private ImageIcon getHistoryTypeShortCut(Integer type, Integer row) {
		if (type == null) {
			return null;
		}
		switch (type) {
		case HospitalisationElement.HOSPITALISATION:
			return ICON_HOSP;
		case HospitalisationElement.ACCIDENT:
			return ICON_ACCIDENT;
		case HospitalisationElement.HOSPITALISATION_PERIOD_1:
			return null;
		case HospitalisationElement.HOSPITALISATION_PERIOD_2:
			return null;
		case HospitalisationElement.HOSPITALISATION_PERIOD_A:
			return null;
		case HospitalisationElement.PASSAGE:
			if(model.getHospitalisationElement(row).isVerified()) 
				return ICON_PASSAGE_VERIFIED;
			else
				return null;
		case HospitalisationElement.PRESCRIPTION:
			return null;
		case HospitalisationElement.REPORT:
			return null;
		default:
			return null;
		}
	}



} 
