/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.hospitalisation.editor;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationStatus;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;

public class HospitalisationStateRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = 1L;
	public final ImageIcon STATUS_CANCELED 	= IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.BUTTON_CANCEL);
	public final ImageIcon STATUS_RUNNING 	= IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.BUTTON_RUNNING);
	public final ImageIcon STATUS_CLOSED 	= IconFetcher.getMiniIcon(PatientManagerModule.class, PatientManagerModule.BUTTON_OK);
    
	public HospitalisationStateRenderer() {
	}
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		try {
			HospitalisationStatus hs = (HospitalisationStatus) value;
			switch (hs.getId()) {
			case 1:
				this.setIcon(STATUS_CANCELED);
				break;
			case 2:
				this.setIcon(STATUS_RUNNING);
				break;
			case 3:
				this.setIcon(STATUS_CLOSED);
				break;
			}
		} catch (Exception e) {
			this.setIcon(null);
		}
		return this;
	}
}
