package lu.tudor.santec.gecamed.patient.gui.incident;

import java.awt.Color;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;

import lu.tudor.santec.gecamed.core.gui.GECAMedFonts;
import lu.tudor.santec.gecamed.core.gui.utils.GradientFactory;
import lu.tudor.santec.gecamed.core.gui.utils.UndoTextArea;
import lu.tudor.santec.gecamed.core.gui.utils.UndoTextField;
import lu.tudor.santec.gecamed.core.gui.widgets.autocompletion.GECAMedAutoCompletionHandler;
import lu.tudor.santec.gecamed.core.gui.widgets.autocompletion.GECAMedAutoCompletionTextComponent;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.settings.ConsultationEntryConfig;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ConsultationEntryPanel.java,v $
 * <br>Revision 1.8  2013-11-29 09:16:31  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.7  2013-11-22 13:51:30  troth
 * <br>Fix some small bugs in the consultation view.
 * <br>Add new gui function the patient setting to config the consultation view.
 * <br>
 * <br>Revision 1.6  2013-11-08 09:48:07  troth
 * <br>Fix Bug: Text content field of entry now can be disable.
 * <br>
 * <br>Revision 1.5  2013-10-29 16:13:44  troth
 * <br>Add the auto completion context menu consultation field.
 * <br>
 * <br>Revision 1.4  2013-09-11 13:11:32  troth
 * <br>Code cleanup.
 * <br>
 * <br>Revision 1.3  2013-09-04 15:33:26  troth
 * <br>The new consultation view with more entries and the sickleave version 2 history view work now.
 * <br>
 * <br>Revision 1.2  2013-09-03 16:32:38  troth
 * <br>The new consultation view with more entries and the sickleave version 1 save entries work now.
 * <br>
 * <br>Revision 1.1  2013-09-03 11:17:11  troth
 * <br>The new consultation view with more entries and the sickleave (GUI only work).
 * <br>
 */

public class ConsultationEntryPanel extends JPanel{

	private static final long serialVersionUID = 1L;
	
	private static final boolean OPAQUE = false;

	private JLabel iconLabel;
	
	private JLabel topicLabel;

	private JLabel codeLabel;

	private UndoTextField codeField;

	private UndoTextArea contentTextArea;
	
	private ConsultationEntryConfig entryConfig;
	
	public ConsultationEntryPanel(DocumentListener documentListener, ConsultationEntryConfig entryConfig)
	{
		super();
		
		this.entryConfig = entryConfig;
		
		CellConstraints cc = new CellConstraints();

		// set customize layout
		this.setLayout(new FormLayout(
				// cols
				"1dlu," +
				"fill:pref," +		// 2
				"0dlu," +// 1
				"fill:pref," +		// 2
				"3dlu," +			// 3
				"fill:pref," +		// 4
				"3dlu," +			// 5
				"fill:pref:grow," +	// 6
				"2dlu," +			// 7
				"fill:pref," +		// 8
				"1dlu",				// 9
				// rows
				"1dlu," +			// 1
				"center:pref," +	// 2
				"fill:2dlu:grow," + // 3
				"1dlu," +			// 4
				"fill:pref," +		// 5
				"1dlu"				// 6
				));

		this.setOpaque(OPAQUE);
		this.setBorder(new TitledBorder(""));

		// icon label
		this.iconLabel = new JLabel("<html>&nbsp;"
				+ entryConfig.getAcronym()
				+ "&nbsp;");
		
//		iconLabel.setForeground(Color.WHITE);
		iconLabel.setBackground(new Color(entryConfig.getColor()));
		iconLabel.setOpaque(true);
		
		// topic label
		// get name of translatrix if possible
//		String translatrixName = "patient.incident." + entryConfig.getName();
//		
//		if(!Translatrix.getTranslationString(translatrixName).equals(translatrixName))
//		{
//			this.topicLabel = new JLabel("<html>"
//					+ Translatrix.getTranslationString(translatrixName)
//					+ "&nbsp;&nbsp;");
//		}else{
//			this.topicLabel = new JLabel(entryConfig.getName());
//		}
		
		this.topicLabel = new JLabel(entryConfig.getTranslatedName());
		this.add(GradientFactory.makeGradient(this.iconLabel, new Color(entryConfig.getColor()), true), cc.xy(2, 2));
		this.add(GradientFactory.makeGradient(this.topicLabel, new Color(entryConfig.getColor()), true), cc.xy(4, 2));
		
//		topicLabel.setIcon(IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.SOAP_S));
		
		topicLabel.setBackground(new Color(entryConfig.getColor()));
		topicLabel.setOpaque(true);
		
		// choose auto completion context
		String selectAutoCom = "";
		if(entryConfig.getId().equals(IncidentManager.SOAP_S))
			selectAutoCom = GECAMedAutoCompletionHandler.ANAMNESIS_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.SOAP_O))
			selectAutoCom = GECAMedAutoCompletionHandler.FINDING_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.SOAP_A))
			selectAutoCom = GECAMedAutoCompletionHandler.DIAGNOSIS_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.SOAP_P))
			selectAutoCom = GECAMedAutoCompletionHandler.TREATMENT_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.CONS_1))
			selectAutoCom = GECAMedAutoCompletionHandler.CONS_1_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.CONS_2))
			selectAutoCom = GECAMedAutoCompletionHandler.CONS_2_CONTEXT;
		else if(entryConfig.getId().equals(IncidentManager.CONS_3))
			selectAutoCom = GECAMedAutoCompletionHandler.CONS_3_CONTEXT;
		
		// code
		if(entryConfig.getCodeLabel() != null && !entryConfig.getCodeLabel().equals(""))
		{
			String translatrixCode = "patient.incident." +  entryConfig.getCodeLabel();
			if(Translatrix.getTranslationString(translatrixCode) != translatrixCode)
			{
				this.codeLabel = new JLabel(Translatrix
						.getTranslationString(translatrixCode)
						+ ":");
			}else{
				this.codeLabel = new JLabel(entryConfig.getCodeLabel());
			}
			this.codeField = new UndoTextField(new UndoManager());
			this.codeField.getDocument().addDocumentListener(documentListener);
			
			// add code label
			this.add(this.codeLabel, cc.xy(6, 2));
			
			// add field
			String selectAutoComCode = selectAutoCom + "_code";
			if(!selectAutoComCode.equals(""))
			{
				// add autocompletion
				AutoCompletionTextComponent actc = new GECAMedAutoCompletionTextComponent(this.codeField, selectAutoComCode);
				this.add(actc, cc.xy(8, 2));
			}else
				this.add(codeField, cc.xy(8, 2));
			
			
		}
		
		// text content
		if(entryConfig.getContentField())
		{
			this.contentTextArea = new UndoTextArea(new UndoManager());
			this.contentTextArea.getDocument().addDocumentListener(documentListener);
			this.contentTextArea.setLineWrap(true);
			this.contentTextArea.setFont(GECAMedFonts.TEXTFIELD_FONT);
			
			if(!selectAutoCom.equals(""))
			{
				AutoCompletionTextComponent actc = new GECAMedAutoCompletionTextComponent(
					this.contentTextArea, selectAutoCom);
			
				this.add(actc, cc.xywh(2, 3, 7, 1));
			}else
				this.add(contentTextArea, cc.xywh(2, 3, 7, 1));
			
		}
	}
	
	public String getCode()
	{
		if(this.entryConfig.getCodeLabel() != null && !this.entryConfig.getCodeLabel().equals(""))
			return this.codeField.getText();
		else 
			return null;
	}
	
	public void setCode(String code)
	{
		if(this.entryConfig.getCodeLabel() != null && !this.entryConfig.getCodeLabel().equals(""))
			this.codeField.setText(code);
	}
	
	public String getText()
	{
		if(this.entryConfig.getContentField())
			return this.contentTextArea.getText();
		else
			return null;
	}
	
	public void setText(String text)
	{
		if(this.entryConfig.getContentField())
			this.contentTextArea.setText(text);
	}
	
	public UndoTextArea getContentTextArea()
	{
		return this.contentTextArea;
	}
	
	public ConsultationEntryConfig getEntryConfig()
	{
		return this.entryConfig;
	}
}