/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.incident;

import java.util.Comparator;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;

/**
 * Compares incidents by their incidentDate
 * 
 * @author martin.heinemann@tudor.lu
 * 29.02.2008
 * 14:16:36
 *
 *
 * @version
 * <br>$Log: IncidentComparator.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-03-06 15:34:27  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class IncidentComparator implements Comparator<Incident> {

	public int compare(Incident o1, Incident o2) {
		/* ====================================================== */
		if (o1 == null || o2 == null || o1.getIncidentDate() == null || o2.getIncidentDate() == null)
			return 0;
		/* ------------------------------------------------------- */
		if (o1.getIncidentDate().before(o2.getIncidentDate()))
			return 1;
		if (o1.getIncidentDate().after(o2.getIncidentDate()))
			return -1;
		
		return 0;
		/* ====================================================== */
	}
	
}
