/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.incident;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.IChangeListener;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntryType;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.PatientPanel;
import lu.tudor.santec.gecamed.patient.gui.PatientViewTab;
import lu.tudor.santec.gecamed.patient.gui.history.AccidentHandler;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;
import lu.tudor.santec.gecamed.prescription.ejb.session.beans.PrescriptionManagerBean;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.PrescriptionManager;
import lu.tudor.santec.gecamed.usermanagement.gui.settings.UserSettingsPlugin;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.toedter.calendar.JDateChooser;

/**
 * The incident tab. It contains the consultation screen, or called incidents.
 * 
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 
 * 
 * @version <br>
 *          $Log: IncidentTab.java,v $
 *          Revision 1.49  2013-12-27 18:09:23  donak
 *          Cleanup of imports
 *
 *          Revision 1.48  2013-10-29 09:45:27  troth
 *          The new consultation view with more entries and the sickleave version 3 fix several bugs.
 *
 *          Revision 1.47  2013-09-04 15:33:26  troth
 *          The new consultation view with more entries and the sickleave version 2 history view work now.
 *
 *          Revision 1.46  2013-07-15 06:18:35  ferring
 *          logging changed
 *
 *          Revision 1.45  2010-11-16 16:50:49  troth
 *          Complete - # 211: create nicer accident list dialog
 *          http://santec.tudor.lu/trac/gecamed/ticket/211
 *          And Ticket #355 - http://santec.tudor.lu/trac/gecamed/ticket/355
 *
 *          Revision 1.44  2010-10-12 07:56:17  troth
 *          Bug fix - add where clause how check the patient id to deleteNullIncident function in IncidentManager
 *
 *          Revision 1.43  2010-09-30 15:55:42  troth
 *          Complete - # 668: edit accident must modify GUI
 *          http://santec.tudor.lu/trac/gecamed/ticket/668
 *
 *          Revision 1.42  2010-09-30 13:03:37  troth
 *          Complete - #667
 *          http://santec.tudor.lu/trac/gecamed/ticket/667
 *
 *          Revision 1.41  2010-09-28 16:12:29  troth
 *          Complete - # 663: Accident entry can not be individually deleted from the history view.
 *          http://santec.tudor.lu/trac/gecamed/ticket/663
 *
 *          Revision 1.40  2010-09-21 12:32:12  troth
 *          fixed bug - how close consultation when saving if incident have other entries than S.O.A.P, Prescription or Measurements
 *
 *          Revision 1.39  2010-09-20 13:38:37  troth
 *          add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
 * <br>
 *          Revision 1.38 2010-09-17 09:04:35 troth <br>
 *          Ticket # 634: Letztes Measurement Feld kann nicht gel�scht werden <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/634 <br>
 * <br>
 *          Revision 1.37 2010-09-15 13:12:44 troth <br>
 *          Complete - # 633: Letzter S.O.A.P. Eintrag kann nicht gelo�scht
 *          werden <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/633 <br>
 * <br>
 *          Revision 1.36 2010-09-07 16:48:32 troth <br>
 *          Incomplete - # 631: Fehler beim Patienten-Abspeichern nach L�schen
 *          eines Unfalls <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/631 <br>
 * <br>
 *          Revision 1.35 2010-09-02 16:16:40 troth <br>
 *          Incomplete - # 619: Probleme mit neuer Unfall-Implementierung <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/619 <br>
 * <br>
 *          Revision 1.34 2010-09-01 12:10:58 troth <br>
 *          Incomplete - # 598: Add a function "Close all Consultation tabs" <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/598 -- change comment <br>
 * <br>
 *          Revision 1.33 2010-09-01 12:01:54 troth <br>
 *          Incomplete - # 301: Prescription date appears in the accident filed
 *          in print out <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/301 <-- incorrect comment
 *          see above <br>
 * <br>
 *          Revision 1.32 2010-08-31 13:35:56 troth <br>
 *          Incomplete - # 495: Mehrere Unstimmigkeiten mit Unfallnummer (auch
 *          #529) <br>
 *          http://santec.tudor.lu/trac/gecamed/ticket/495 <br>
 *          and Tickets 529, 613 <br>
 *          and new/redesign of AccidentPanel <br>
 * <br>
 *          Revision 1.31 2010-08-24 12:49:41 troth <br>
 *          fix small bug - to open consultation over the accident entry in the
 *          patient history <br>
 * <br>
 *          Revision 1.30 2010-05-05 11:23:13 ferring <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.29 2010-04-26 16:38:13 troth <br>
 *          Redesign of the prescription view <br>
 * <br>
 *          Revision 1.27 2009-10-05 12:22:15 hermen <br>
 *          -added marital state cohabit <br>
 *          -added option to disable accident-chooser dialog <br>
 * <br>
 *          Revision 1.26 2009-05-19 13:56:15 hermen <br>
 *          moved print empty prescriptions to PatientPanel, so secretary has it
 *          too <br>
 * <br>
 *          Revision 1.25 2009-04-15 13:30:16 heinemann <br>
 *          replaced accident icon with a button to open the accident chooser
 *          dialog <br>
 * <br>
 *          Revision 1.24 2009-02-25 13:26:09 hermen <br>
 *          added siteID to incidents and invoices <br>
 * <br>
 *          Revision 1.23 2008-12-17 15:23:06 heinemann <br>
 *          initial commit after merging of branch new prescription <br>
 * <br>
 *          Revision 1.22.2.1 2008-12-15 14:08:21 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.22 2008-10-21 09:53:34 hermen <br>
 *          fixed patient slot bug <br>
 *          enhanced logging <br>
 *          code cleanup <br>
 * <br>
 *          Revision 1.21 2008-09-25 09:43:07 heinemann <br>
 *          fixed copyrights <br>
 * <br>
 *          Revision 1.20 2008-07-03 11:59:57 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.19 2008-04-15 12:40:51 heinemann <br>
 *          select accident number when the date is choosen in consultation view <br>
 * <br>
 *          Revision 1.18 2008-03-12 10:30:06 hermen <br>
 *          changed PatientViewTab to abstract and added getName() method <br>
 * <br>
 *          Revision 1.17 2008-02-11 16:49:13 heinemann <br>
 *          moved IChangeListener to core <br>
 * <br>
 *          Revision 1.16 2008-01-22 13:51:51 heinemann <br>
 *          code cleanup and java doc <br>
 * <br>
 *          Revision 1.15 2007-11-20 08:58:54 hermen <br>
 *          moved Managerfactory to core.utils and refactured code to use
 *          ManagerFactory instead of context.lookup <br>
 * <br>
 *          Revision 1.14 2007-10-22 09:58:14 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.13 2007/07/03 12:35:29 heinemann <br>
 *          system.out removed <br>
 * <br>
 *          Revision 1.12 2007/06/18 11:31:37 hermen <br>
 *          cleanup of old stuff and moved some beans <br>
 * <br>
 *          Revision 1.11 2007/04/24 13:48:43 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.10 2007/04/18 09:04:22 heinemann <br>
 *          added patient modified event when accident number has been set by
 *          accidentrelation dialog. <br>
 * <br>
 *          Revision 1.9 2007/04/17 14:51:25 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.8 2007/03/30 12:18:00 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.7 2007/03/13 09:39:59 heinemann <br>
 *          fixed modifying the date of a consultation <br>
 * <br>
 *          Revision 1.6 2007/03/13 09:19:12 heinemann <br>
 *          fixed closing consultation tabs <br>
 * <br>
 *          Revision 1.5 2007/03/07 09:45:05 heinemann <br>
 *          bug fixes <br>
 * <br>
 *          Revision 1.4 2007/03/06 13:32:51 heinemann <br>
 *          Incomplete - # 8: Closing of consultation tabs <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/8 <br>
 * <br>
 *          editing the date of a consultation <br>
 * <br>
 *          Revision 1.3 2007/03/06 06:48:05 heinemann <br>
 *          Incomplete - # 8: Closing of consultation tabs <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/8 <br>
 * <br>
 *          Revision 1.2 2007/03/02 08:28:44 hermen <br>
 *          initial checkin after the merge of PatientModuleRebuild with the
 *          main HEAD <br>
 * <br>
 *          Revision 1.1.2.7 2007/02/22 15:01:39 heinemann <br>
 *          complete - # 8: Closing of consultation tabs <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/8 <br>
 * <br>
 *          Revision 1.1.2.6 2007/02/22 12:01:22 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1.2.5 2007/02/21 09:59:09 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1.2.4 2007/01/22 14:41:32 heinemann <br>
 *          Complete - # 61: Organize reordering of consultation tabs <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/61 <br>
 * <br>
 *          Revision 1.1.2.3 2007/01/22 12:21:16 heinemann <br>
 *          Complete - # 41: Print empty prescription <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/41 <br>
 *          Added button to the navi bar <br>
 * <br>
 *          Revision 1.1.2.2 2007/01/22 10:24:07 heinemann <br>
 *          Incomplete - # 13: print copies of prescriptions <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/13 <br>
 * <br>
 *          Revision 1.1.2.1 2007/01/04 13:48:42 heinemann <br>
 *          The great space cleaning lady has done a big bunch of refactoring <br>
 * <br>
 *          Revision 1.1.2.10 2007/01/04 12:13:53 heinemann <br>
 *          Incomplete - # 22: Save consultation after a prescription was
 *          printed does not work <br>
 *          http://santec.tudor.lu:8888/gecamed/ticket/22 <br>
 * <br>
 *          fixed and some other changes like the behaviour of the prescription
 *          editor in case of printing and afterwards saving the consultation
 *          etc <br>
 * <br>
 *          Revision 1.1.2.9 2006/12/28 15:47:15 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1.2.8 2006/12/28 10:31:37 heinemann <br>
 *          bug fixing <br>
 * <br>
 *          Revision 1.1.2.7 2006/12/19 14:51:13 heinemann <br>
 *          printing etc <br>
 * <br>
 *          Revision 1.1.2.6 2006/12/15 15:58:03 heinemann <br>
 *          presc <br>
 * <br>
 *          Revision 1.1.2.5 2006/12/14 13:06:15 hermen <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1.2.4 2006/12/14 10:41:17 hermen <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.1.2.3 2006/12/14 09:32:37 heinemann <br>
 *          many changes <br>
 * <br>
 *          Revision 1.1.2.2 2006/12/06 13:47:22 heinemann <br>
 *          insets adapted <br>
 * <br>
 *          Revision 1.1.2.1 2006/12/06 07:51:57 heinemann <br>
 *          *** empty log message *** <br>
 */
public class IncidentTab extends PatientViewTab implements MouseListener {

	private static final long serialVersionUID = 1L;

	public static final String NAME = "INCIDENT_PANEL";

	public static final String INCIDENT_ACTIVATION = "incident_module_tab_activation_scheisse_hier";

	private HashMap<Incident, IncidentControler> controlerMap = new HashMap<Incident, IncidentControler>();

	private JTabbedPane tabbedPane;

	private Patient currentPatient;

	private ArrayList<JComponent> actionComponents;

	private JPopupMenu popup;

	private IncidentPanel currentPanel;

	private NotifactionListener notificationListener;

	private AbstractAction changeDateAction;

	private DateChangeDialog dateChangerDialog;

	private PatientPanel patientPanel;

	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(IncidentTab.class.getName());

	/**
	 * @param patientPanel
	 */
	public IncidentTab(PatientPanel patientPanel) {
		/* ====================================================== */
		Translatrix
				.addBundle("lu.tudor.santec.gecamed.prescription.gui.resources.Translatrix");
		// init the layout
		this.setLayout(new BorderLayout());

		this.patientPanel = patientPanel;

		/* ------------------------------------------------------ */
		this.setIcon(PatientManagerModule
				.getMediumIcon(PatientManagerModule.PATIENT_FILE));
		this.setTitle(Translatrix.getTranslationString("patient.incident"));

		tabbedPane = new JTabbedPane();
		tabbedPane.setOpaque(false);
		this.setOpaque(false);

		tabbedPane.addMouseListener(this);

		this.add(tabbedPane, BorderLayout.CENTER);

		// // create an empty incident
		// this.newIncident();
		// this.printEmptyAction = new GECAMedAction(
		// null,
		// "prescription.buttons.printEmpty",
		// IconBuilder.getSmallIcon(IconBuilder.PRINT_EMPTY),
		// KeyEvent.VK_V,
		// false, false, false) {
		//
		// private static final long serialVersionUID = 1L;
		//
		// public void actionPerformed(ActionEvent evt) {
		// /* ====================================================== */
		// PrescriptionPrinter.printEmpty(GECAMedModule.getCurrentPatient());
		// /* ====================================================== */
		// }
		// };
		// this.actionComponents = new ArrayList<JComponent>();
		// JButton printEmptyButton = new JButton(printEmptyAction);
		// printEmptyButton.setHorizontalAlignment(SwingConstants.LEFT);
		// printEmptyButton.setEnabled(true);
		// printEmptyButton.setIconTextGap(1);
		// printEmptyButton.setFont(GECAMedFonts.BUTTON_FONT);
		// printEmptyButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
		// printEmptyButton.setToolTipText(Translatrix.getTranslationString("prescription.tooltip.printemptyprescription"));
		//
		// actionComponents.add(printEmptyButton);
		/* ------------------------------------------------------- */
		// init the date changer dialog
		this.dateChangerDialog = new DateChangeDialog();
		/* ------------------------------------------------------- */
		initMouseContextMenu();

		this.notificationListener = new NotifactionListener();

		this.getButton().addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				// IncidentTab.this.firePropertyChange(INCIDENT_ACTIVATION,
				// !getButton().isSelected(), getButton().isSelected());
				/* ====================================================== */
			}

		});

		/* ====================================================== */
	}

	/**
	 * Open an incident as new incident
	 * 
	 * @param incident
	 */
	public void openIncident(Incident incident) {
		/* ====================================================== */
		this.openIncident(incident, false);
		/* ====================================================== */
	}

	/**
	 * Opens an incident.
	 * 
	 * @param incident
	 *            incident to show
	 * @param isOld
	 *            boolean, if true, the prescription editor will be disabled
	 */
	public void openIncident(Incident incident, boolean isOld) {
		/* ====================================================== */
		if (incident == null)
			return;

		// create model, panel and controler
		IncidentControler controler = new IncidentControler(isOld);
		IncidentModel model = new IncidentModel(incident, controler, isOld);
		IncidentPanel panel = new IncidentPanel(model, this.patientPanel,
				controler);

		model.addNotificationListener(this.notificationListener);

		controler.setIncidentPanel(panel);
		controler.setIncidentModel(model);
		// set patient
		controler.getIncidentModel().setPatient(currentPatient);

		// controler.getPrescriptionModule().setIncident(incident);
		// controler.getPrescriptionModule().setPatient(currentPatient);

		// controler.getIncidentPanel().getPrescriptionEditor().reloadHistory(incident.getPatientId());

		/* ------------------------------------------------------ */
		// // set title
		// if (incident.getIncidentDate() == null)
		// panel.setTitle(Translatrix.getTranslationString("patient.incident.new"));
		// else
		// panel.setTitle(formater.format(incident.getIncidentDate()));
		/* ------------------------------------------------------ */

		this.controlerMap.put(incident, controler);
		model.setModified(false);
		model.fireModelChanged();
		// panel.addToTabbedPane(tabbedPane);
		panel.addMouseListener(this);
		panel.addAccidentDialogButtonListener(new AccidentDialogButtonListener(
				panel));
		this.addPropertyChangeListener(INCIDENT_ACTIVATION, controler);

		panel.addAncestorListener(new AncestorListener() {

			public void ancestorAdded(AncestorEvent event) {
				/* ====================================================== */
				IncidentPanel p = (IncidentPanel) event.getSource();
				/* ------------------------------------------------------- */
				if (p.isShowing() && p.getControler().isModuleActive()
						&& p.isFirstTimeShowing()
						&& !p.getControler().getIncident().isPersistent()) {
					/* ------------------------------------------------------- */
					p.setFirstTimeShowing(false);
					/* ------------------------------------------------------- */
					if (
							patientPanel.getHistoryDataAgent().getLatestIncident() != null
							&& patientPanel.getHistoryDataAgent().getLatestIncident().getIsAccident()
							&& !AccidentRelationDialog.NOT_SHOW_AGAIN
							&& ((Boolean)MainFrame.getInstance().userSettings.getValue(UserSettingsPlugin.SHOW_ACCIDENT_RELATION_ENABLED))
					) { // TODO
						showAccidentDialog(p);
					}
					/* ------------------------------------------------------- */
				}

				/* ====================================================== */
			}

			public void ancestorMoved(AncestorEvent event) {
			}

			public void ancestorRemoved(AncestorEvent event) {
			}
		});

		this.currentPanel = panel;
		fireIncidentChanged(panel);

		panel.startSetTitle();

		// activate the new Tab
		// if (getButton().isSelected())
		if (incident.isPersistent())
			tabbedPane.setSelectedComponent(panel);
		/* ====================================================== */
	}

	/**
	 * @param incident
	 */
	public void removeIncident(Incident incident) {
		/* ================================================== */
		this.controlerMap.remove(incident);

		/* ------------------------------------------------------- */
		// if empty, create an new consultation
		if (controlerMap.keySet().size() <= 0) {
			newIncident();
		} else {
			fireIncidentChanged(null);
		}
		/* ================================================== */
	}

	/**
	 * create a new incident and show it
	 */
	public void newIncident() {
		/* ====================================================== */
		Incident incident = new Incident();
		incident.setSiteId(MainFrame.getCurrentSiteId());
		this.openIncident(incident);
		/* ====================================================== */
	}

	/**
	 * Close an incident
	 * 
	 * @param incident
	 */
	public void closeIncident(IncidentPanel incPanel) {
		/* ====================================================== */
		if (incPanel.getForcedIncident() != null) {
			
			if (incPanel.isContentModified()) {
				// if (currentPanel.getForcedIncident() != null) {
				// if (currentPanel.isContentModified()) {
				/* ------------------------------------------------------- */
				// modifications found, save question!
				int n = JOptionPane
						.showConfirmDialog(
								MainFrame.getInstance(),
								Translatrix
										.getTranslationString("patient.incident")
										+ " "
										+ incPanel.getForcedIncident()
												.getIncidentDate()
										+ " "
										+ Translatrix
												.getTranslationString("pm.savequestion"),
								Translatrix
										.getTranslationString("pm.savePatient"),
								JOptionPane.YES_NO_CANCEL_OPTION);
				if (n == JOptionPane.YES_OPTION) {
					/* ------------------------------------------------------- */
					// save consultation
					incPanel.getControler().saveIncident();
					// currentPanel.getControler().saveIncident();
					/* ------------------------------------------------------- */
				} else if (n == JOptionPane.CANCEL_OPTION) {
					return;
				}
			}
			/* ------------------------------------------------------- */
			// remove from hashmap
			removeIncident(incPanel.getForcedIncident());
			// removeIncident(IncidentTab.this.currentPanel.getForcedIncident());
		}

		/* ====================================================== */
	}

	public void fireIncidentChanged() {
		/* ====================================================== */
		fireIncidentChanged(null);
		/* ====================================================== */
	}

	/**
	 * Update the tabs
	 */
	public void fireIncidentChanged(JPanel panelToActivate) {
		/* ====================================================== */
		// update the tabs
		tabbedPane.removeAll();

		List<Incident> tempList = new ArrayList<Incident>(controlerMap.keySet());
		Collections.sort(tempList, new Comparator<Incident>() {

			public int compare(Incident o1, Incident o2) {
				/* ============================================= */
				if (o1 != null && o2 != null) {
					if (o1.getIncidentDate() == null
							&& o2.getIncidentDate() != null)
						return -1;
					if (o1.getIncidentDate() != null
							&& o2.getIncidentDate() == null)
						return 1;
					if (o1.getIncidentDate() == null
							&& o2.getIncidentDate() == null)
						return 0;
					if (o1.getIncidentDate().before(o2.getIncidentDate()))
						return 1;
					if (o1.getIncidentDate().after(o2.getIncidentDate()))
						return -1;
				}
				return 0;
				/* ============================================= */
			}

		});
		/* ------------------------------------------------------ */

		// build the new tabs
		for (Incident in : tempList) {
			/* ------------------------------------------------------ */
			IncidentControler c = controlerMap.get(in);
			c.getIncidentPanel().addToTabbedPane(tabbedPane);
			// tabbedPane.add(c.getIncidentPanel().getTitle(),
			// c.getIncidentPanel());
			/* ------------------------------------------------------ */
		}
		this.validate();
		this.updateUI();
		/* ====================================================== */
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#saveData()
	 */
	@Override
	public void saveData() {
		Boolean needNew = false;

		JPanel p = (JPanel) tabbedPane.getSelectedComponent();
		// copy map
		HashMap<Incident, IncidentControler> cTemp = new HashMap<Incident, IncidentControler>();
		// delete list
		List<Incident> removeIncidents = new ArrayList<Incident>();
		
		for (Incident in : controlerMap.keySet()) {

			IncidentControler c = controlerMap.get(in);

			// save incident
			if (c.saveIncident())
				needNew = true;
			
			if (c.getIncident().getIncidentEntries() != null) {
				if (c.getIncident().getIncidentEntries().size() > 0) {
					boolean remove = true;
					// check all Entries from one Incident
					for (IncidentEntry v : c.getIncident().getIncidentEntries()) {
						if (
								v.getEntryType().getName().equals(IncidentEntryType.TYPE_S)
								|| v.getEntryType().getName().equals(IncidentEntryType.TYPE_O)
								|| v.getEntryType().getName().equals(IncidentEntryType.TYPE_A)
								|| v.getEntryType().getName().equals(IncidentEntryType.TYPE_P)
								|| v.getEntryType().getName().equals(IncidentManager.MEASUREMENT)
								|| v.getEntryType().getName().equals(IncidentManager.PRESCRIPTION)
								|| v.getEntryType().getName().equals(IncidentManager.CONS_1)
								|| v.getEntryType().getName().equals(IncidentManager.CONS_2)
								|| v.getEntryType().getName().equals(IncidentManager.CONS_3)
								|| v.getEntryType().getName().equals(IncidentManager.SICK_LEAVE)		
						) 
						{

							remove = false;
							break;
						}
					}

					// keep in mind the incident to delete
					if (remove)
						removeIncidents.add(c.getIncident());
				} else {
					// special entry accident
					if (!c.getIncident().getIsAccident()) {
						// keep in mind the incident to delete
						removeIncidents.add(c.getIncident());
					}
				}				
				
			}
			
			// save new map with the new incident
			// see the incident values
			cTemp.put(c.getIncident(), c);
		}
		// copy new map
		controlerMap.clear();
		controlerMap.putAll(cTemp);

		try {
		    // delete incident how have no entries on DB
		    getManager().deleteNullIncident(GECAMedModule.getCurrentPatient().getId());		    
		} catch (Exception e) {
		    logger.log(Level.WARN, "Error deleting null Incidents" , e);
		}

		// open a "new" consultation if we need some
		if (needNew) {
			newIncident();
		}

		// remove incident for controler map
		if (removeIncidents.size() > 0) {
			for (Incident incidentToDelete : removeIncidents) {
				this.removeIncident(incidentToDelete);
			}
		} else
			tabbedPane.setSelectedComponent(p);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.GECAMedTab#setPatient(lu.tudor.santec
	 * .gecamed.patient.ejb.entity.beans.Patient)
	 */
	@Override
	public void setPatient(Patient patient) {
		/* ============================================= */
		if (currentPatient == null || !currentPatient.equals(patient)) {
			this.currentPatient = patient;
			controlerMap.clear();
			newIncident();

			for (Incident in : controlerMap.keySet()) {
				/* ------------------------------------------------------ */
				IncidentControler c = controlerMap.get(in);
				c.getIncidentModel().setPatient(patient);
				// c.getPrescriptionModule().setPatient(patient);

				// c.getIncidentPanel().getPrescriptionEditor().reloadHistory(patient.getId());
				/* ------------------------------------------------------ */
			}
			this.setModified(false);
		}
		/* ============================================= */
	}

	public IncidentPanel getCurrentPanel() {
		/* ================================================== */
		return this.currentPanel;
		/* ================================================== */
	}

	/**
	 * @param incidentId
	 */
	public void openConsultation(Integer incidentId, Integer incidentEntryId) {
		/* ================================================== */
		Incident in = getManager().getIncident(incidentId);
		/* ------------------------------------------------------- */
		// open old incident
		/* ------------------------------------------------------- */
		openIncident(in, true);
		getButton().doClick();

		// set the current patient to the tabs
		for (Incident inc : controlerMap.keySet()) {
			/* ------------------------------------------------------ */
			IncidentControler c = controlerMap.get(inc);
			c.getIncidentModel().setPatient(currentPatient);

			// c.getPrescriptionModule().setPatient(currentPatient);
			// c.getIncidentPanel().getPrescriptionEditor().reloadHistory();
			/* ------------------------------------------------------ */
		}
		// open the Prescription by double click on the history view
		IncidentControler c = controlerMap.get(in);

		if (incidentEntryId != null) {

			PrescriptionManager manager = (PrescriptionManager) ManagerFactory
					.getRemote(PrescriptionManagerBean.class);

			List<Prescription> presc = manager
					.getPrescriptionByIncidentEntry(incidentEntryId);

			if (presc != null && presc.size() > 0) {
				Prescription p = presc.get(0);
				// PatientManagerModule.getInstance().getPatientPanel().showPanel(IncidentPanel.name);
				c.getIncidentPanel().getPrescriptionModel().setPrescription(p);
			}
		}
		/* ================================================== */
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.patient.gui.PatientViewTab#getActionComponents()
	 */
	@Override
	public Collection<JComponent> getActionComponents() {
		/* ============================================= */
		return this.actionComponents;
		/* ============================================= */
	}

	/**
	 * inits the context menu for right click on a tab
	 */
	private void initMouseContextMenu() {
		/* ====================================================== */

		this.popup = new JPopupMenu();

		/* **************************************************************
		 * Init the menu
		 */
		// close action
		Action closeAction = new AbstractAction(Translatrix
				.getTranslationString("core.close"), GECAMedModule
				.getSmallIcon(GECAMedIconNames.CLOSE)) {
			/**
			 *
			 */
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ================================================== */

				if (IncidentTab.this.currentPanel != null) {
					/* ------------------------------------------------------- */
					closeIncident(currentPanel);
					/* ------------------------------------------------------- */
				}
				/* ================================================== */
			}
		};

		// close all action
		Action closeAllAction = new AbstractAction(Translatrix
				.getTranslationString("core.closeAll"), GECAMedModule
				.getSmallIcon(GECAMedIconNames.CLOSE)) {
			/**
			 *
			 */
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {

				if (IncidentTab.this.currentPanel != null) {
					Vector<IncidentPanel> incidentPanelVector = new Vector<IncidentPanel>();
					// get all IncidentPanels
					for (Incident in : controlerMap.keySet()) {
						IncidentControler incidentControler = controlerMap
								.get(in);
						if (!IncidentTab.this.currentPanel
								.equals(incidentControler.getIncidentPanel()))
							incidentPanelVector.add(incidentControler
									.getIncidentPanel());
					}
					// close all IncidentPanels
					for (int i = 0; i < incidentPanelVector.size(); i++)
						closeIncident(incidentPanelVector.get(i));

					closeIncident(currentPanel);
				}
			}
		};

		this.changeDateAction = new AbstractAction(Translatrix
				.getTranslationString("patient.incident.changeDate"),
				IconFetcher.getSmallIcon(PatientManagerModule.class,
						PatientManagerModule.MODIFY)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				/* ====================================================== */
				showDateChangerDialog();
				/* ====================================================== */
			}

		};
		/* ------------------------------------------------------- */
		popup.add(changeDateAction);
		popup.add(new JSeparator());
		popup.add(closeAction);
		popup.add(new JSeparator());
		popup.add(closeAllAction);
	}

	private void showDateChangerDialog() {
		/* ================================================== */
		if (this.currentPanel == null)
			return;
		/* ------------------------------------------------------- */
		Date newDate = this.dateChangerDialog.showDateChanger(currentPanel
				.getForcedIncident().getIncidentDate());
		/* ------------------------------------------------------- */
		if (newDate != null) {
			/* ------------------------------------------------------- */
			currentPanel.getForcedIncident().setIncidentDate(newDate);
			fireIncidentChanged();
			controlerMap.get(currentPanel.getForcedIncident())
					.getIncidentModel().setModified(true);
			currentPanel.startSetTitle();
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}

	/**
	 * Returns the IncidentManager SessionBean
	 * 
	 * @return
	 */
	public static IncidentManager getManager() {
		/* ====================================================== */
		return (IncidentManager) ManagerFactory
				.getRemote(IncidentManagerBean.class);
		/* ====================================================== */
	}

	/*
	 * ##########################################################################
	 * ### Mouselistener methods for the IncidentPanels
	 */

	public void mouseClicked(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mousePressed(MouseEvent e) {
		/* ====================================================== */
		doMouseAction(e);
		/* ====================================================== */
	}

	public void mouseReleased(MouseEvent e) {
		/* ====================================================== */
		doMouseAction(e);
		/* ====================================================== */
	}

	private void doMouseAction(MouseEvent e) {
		/* ================================================== */
		try {
			IncidentPanel p = (IncidentPanel) tabbedPane
					.getComponentAt(tabbedPane.indexAtLocation(e.getX(), e
							.getY()));
			if (p != null) {
				this.currentPanel = p;
				/* ------------------------------------------------------- */
				if (e.isPopupTrigger())
					popup.show(p, e.getX(), e.getY() - 17);
				/* ------------------------------------------------------- */
			}
		} catch (Exception e1) {
			// e1.printStackTrace();
		}
		/* ================================================== */
	}

	class NotifactionListener implements IChangeListener {
		/**
		 * notifications of incident model changes
		 */
		public void fireEvent() {
			/* ====================================================== */
			if (!IncidentTab.this.isModified()) {
				// check for modifications
				for (Incident inc : controlerMap.keySet()) {
					/* ------------------------------------------------------ */
					IncidentControler c = controlerMap.get(inc);
					if (c.getIncidentModel().isModified())
						IncidentTab.this.setModified(true);
					/* ------------------------------------------------------ */
				}
			}

			/* ====================================================== */
		}
	}

	/**
	 * @author martin.heinemann@tudor.lu 06.03.2007 14:26:41
	 * 
	 * 
	 * @version <br>
	 *          $Log: IncidentTab.java,v $
	 *          Revision 1.49  2013-12-27 18:09:23  donak
	 *          Cleanup of imports
	 *
	 *          Revision 1.48  2013-10-29 09:45:27  troth
	 *          The new consultation view with more entries and the sickleave version 3 fix several bugs.
	 *
	 *          Revision 1.47  2013-09-04 15:33:26  troth
	 *          The new consultation view with more entries and the sickleave version 2 history view work now.
	 *
	 *          Revision 1.46  2013-07-15 06:18:35  ferring
	 *          logging changed
	 *
	 *          Revision 1.45  2010-11-16 16:50:49  troth
	 *          Complete - # 211: create nicer accident list dialog
	 *          http://santec.tudor.lu/trac/gecamed/ticket/211
	 *          And Ticket #355 - http://santec.tudor.lu/trac/gecamed/ticket/355
	 *
	 *          Revision 1.44  2010-10-12 07:56:17  troth
	 *          Bug fix - add where clause how check the patient id to deleteNullIncident function in IncidentManager
	 *
	 *          Revision 1.43  2010-09-30 15:55:42  troth
	 *          Complete - # 668: edit accident must modify GUI
	 *          http://santec.tudor.lu/trac/gecamed/ticket/668
	 *
	 *          Revision 1.42  2010-09-30 13:03:37  troth
	 *          Complete - #667
	 *          http://santec.tudor.lu/trac/gecamed/ticket/667
	 *
	 *          Revision 1.41  2010-09-28 16:12:29  troth
	 *          Complete - # 663: Accident entry can not be individually deleted from the history view.
	 *          http://santec.tudor.lu/trac/gecamed/ticket/663
	 *
	 *          Revision 1.40  2010-09-21 12:32:12  troth
	 *          fixed bug - how close consultation when saving if incident have other entries than S.O.A.P, Prescription or Measurements
	 *
	 *          Revision 1.39  2010-09-20 13:38:37  troth
	 *          add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
	 * <br>
	 *          Revision 1.38 2010-09-17 09:04:35 troth <br>
	 *          Ticket # 634: Letztes Measurement Feld kann nicht gel�scht
	 *          werden <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/634 <br>
	 * <br>
	 *          Revision 1.37 2010-09-15 13:12:44 troth <br>
	 *          Complete - # 633: Letzter S.O.A.P. Eintrag kann nicht gelo�scht
	 *          werden <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/633 <br>
	 * <br>
	 *          Revision 1.36 2010-09-07 16:48:32 troth <br>
	 *          Incomplete - # 631: Fehler beim Patienten-Abspeichern nach
	 *          L�schen eines Unfalls <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/631 <br>
	 * <br>
	 *          Revision 1.35 2010-09-02 16:16:40 troth <br>
	 *          Incomplete - # 619: Probleme mit neuer Unfall-Implementierung <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/619 <br>
	 * <br>
	 *          Revision 1.34 2010-09-01 12:10:58 troth <br>
	 *          Incomplete - # 598: Add a function "Close all Consultation tabs" <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/598 -- change comment <br>
	 * <br>
	 *          Revision 1.33 2010-09-01 12:01:54 troth <br>
	 *          Incomplete - # 301: Prescription date appears in the accident
	 *          filed in print out <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/301 <br>
	 * <br>
	 *          Revision 1.32 2010-08-31 13:35:56 troth <br>
	 *          Incomplete - # 495: Mehrere Unstimmigkeiten mit Unfallnummer
	 *          (auch #529) <br>
	 *          http://santec.tudor.lu/trac/gecamed/ticket/495 <br>
	 *          and Tickets 529, 613 <br>
	 *          and new/redesign of AccidentPanel <br>
	 * <br>
	 *          Revision 1.31 2010-08-24 12:49:41 troth <br>
	 *          fix small bug - to open consultation over the accident entry in
	 *          the patient history <br>
	 * <br>
	 *          Revision 1.30 2010-05-05 11:23:13 ferring <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.29 2010-04-26 16:38:13 troth <br>
	 *          Redesign of the prescription view <br>
	 * <br>
	 *          Revision 1.27 2009-10-05 12:22:15 hermen <br>
	 *          -added marital state cohabit <br>
	 *          -added option to disable accident-chooser dialog <br>
	 * <br>
	 *          Revision 1.26 2009-05-19 13:56:15 hermen <br>
	 *          moved print empty prescriptions to PatientPanel, so secretary
	 *          has it too <br>
	 * <br>
	 *          Revision 1.25 2009-04-15 13:30:16 heinemann <br>
	 *          replaced accident icon with a button to open the accident
	 *          chooser dialog <br>
	 * <br>
	 *          Revision 1.24 2009-02-25 13:26:09 hermen <br>
	 *          added siteID to incidents and invoices <br>
	 * <br>
	 *          Revision 1.23 2008-12-17 15:23:06 heinemann <br>
	 *          initial commit after merging of branch new prescription <br>
	 * <br>
	 *          Revision 1.22.2.1 2008-12-15 14:08:21 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.22 2008-10-21 09:53:34 hermen <br>
	 *          fixed patient slot bug <br>
	 *          enhanced logging <br>
	 *          code cleanup <br>
	 * <br>
	 *          Revision 1.21 2008-09-25 09:43:07 heinemann <br>
	 *          fixed copyrights <br>
	 * <br>
	 *          Revision 1.20 2008-07-03 11:59:57 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.19 2008-04-15 12:40:51 heinemann <br>
	 *          select accident number when the date is choosen in consultation
	 *          view <br>
	 * <br>
	 *          Revision 1.18 2008-03-12 10:30:06 hermen <br>
	 *          changed PatientViewTab to abstract and added getName() method <br>
	 * <br>
	 *          Revision 1.17 2008-02-11 16:49:13 heinemann <br>
	 *          moved IChangeListener to core <br>
	 * <br>
	 *          Revision 1.16 2008-01-22 13:51:51 heinemann <br>
	 *          code cleanup and java doc <br>
	 * <br>
	 *          Revision 1.15 2007-11-20 08:58:54 hermen <br>
	 *          moved Managerfactory to core.utils and refactured code to use
	 *          ManagerFactory instead of context.lookup <br>
	 * <br>
	 *          Revision 1.14 2007-10-22 09:58:14 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.13 2007/07/03 12:35:29 heinemann <br>
	 *          system.out removed <br>
	 * <br>
	 *          Revision 1.12 2007/06/18 11:31:37 hermen <br>
	 *          cleanup of old stuff and moved some beans <br>
	 * <br>
	 *          Revision 1.11 2007/04/24 13:48:43 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.10 2007/04/18 09:04:22 heinemann <br>
	 *          added patient modified event when accident number has been set
	 *          by accidentrelation dialog. <br>
	 * <br>
	 *          Revision 1.9 2007/04/17 14:51:25 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.8 2007/03/30 12:18:00 heinemann <br>
	 *          *** empty log message *** <br>
	 * <br>
	 *          Revision 1.7 2007/03/13 09:39:59 heinemann <br>
	 *          fixed modifying the date of a consultation <br>
	 * <br>
	 *          Revision 1.6 2007/03/13 09:19:12 heinemann <br>
	 *          fixed closing consultation tabs <br>
	 * <br>
	 *          Revision 1.5 2007/03/07 09:45:05 heinemann <br>
	 *          bug fixes <br>
	 * <br>
	 *          Revision 1.4 2007/03/06 13:32:51 heinemann <br>
	 *          Incomplete - # 8: Closing of consultation tabs <br>
	 *          http://santec.tudor.lu:8888/gecamed/ticket/8 <br>
	 * <br>
	 *          editing the date of a consultation <br>
	 * 
	 */
	
	class DateChangeDialog implements ActionListener {

		private JDialog dateChanger;
		private JDateChooser dateChooser;
		private Date dateToChange;
		private JButton closeB;
		private JButton cancelB;

		public DateChangeDialog() {
			/* ================================================== */

			this.dateChanger = new JDialog(MainFrame.getInstance(), true);

			this.dateChooser = new JDateChooser();
			dateChooser.setDateFormatString("HH:mm d/M/yyyy");
			/* ------------------------------------------------------- */
			JPanel p = new JPanel(new BorderLayout());
			/* ------------------------------------------------------- */
			p.setBorder(BorderFactory.createTitledBorder(Translatrix
					.getTranslationString("patient.incident.changeDate")));
			p.add(dateChooser, BorderLayout.CENTER);
			/* ------------------------------------------------------- */
			ButtonBarBuilder bb = new ButtonBarBuilder();
			bb.addGlue();
			this.closeB = new JButton(Translatrix
					.getTranslationString("patient.ok"), GECAMedModule
					.getSmallIcon(GECAMedIconNames.OK));
			this.cancelB = new JButton(Translatrix
					.getTranslationString("patient.cancel"), GECAMedModule
					.getSmallIcon(GECAMedIconNames.CANCEL));
			/* ------------------------------------------------------- */
			bb.addGridded(closeB);
			bb.addGridded(cancelB);
			/* ------------------------------------------------------- */

			/* ------------------------------------------------------- */
			dateChanger.add(p, BorderLayout.CENTER);
			dateChanger.add(bb.getPanel(), BorderLayout.SOUTH);

			/* ------------------------------------------------------- */
			closeB.addActionListener(this);
			cancelB.addActionListener(this);
			/* ================================================== */
		}

		public void actionPerformed(ActionEvent e) {
			/* ====================================================== */
			if (e.getSource().equals(closeB)) {
				/* ------------------------------------------------------- */
				// get the date from the chooser
				dateToChange = dateChooser.getDate();
				dateChanger.setVisible(false);
				/* ------------------------------------------------------- */
			} else if (e.getSource().equals(cancelB)) {
				/* ------------------------------------------------------- */
				dateToChange = null;
				dateChanger.setVisible(false);
				/* ------------------------------------------------------- */
			}
			/* ====================================================== */
		}

		/**
		 * Shows the date changer
		 * 
		 * @param currDate
		 *            date to change
		 * @return changed date
		 */
		public Date showDateChanger(Date currDate) {
			/* ================================================== */
			if (currDate == null)
				return null;
			/* ------------------------------------------------------- */
			dateChooser.setDate(currDate);
			/* ------------------------------------------------------- */
			// reset date, to prevend race conditions that might appear when
			// the window is closed by any other ways than the buttons
			dateToChange = null;
			/* ------------------------------------------------------- */
			dateChanger.pack();
			// show
			MainFrame.showDialogCentered(dateChanger);
			/* ------------------------------------------------------- */
			return this.dateToChange;
			/* ================================================== */
		}

	}

	private void showAccidentDialog(IncidentPanel panel) {
		/* ================================================== */
		if (patientPanel.getHistoryDataAgent().getLatestIncident() != null) {
			// &&
			// patientPanel.getHistoryDataAgent().getLatestIncident().getIsAccident())
			// {
			/* ------------------------------------------------------- */
			AccidentRelationDialog are = AccidentRelationDialog.getInstance();

			List<Incident> tList = new ArrayList<Incident>();
			tList.addAll(PatientManagerModule.getPatientAccidents(panel
					.getControler().getIncidentModel().getPatient().getId()));
			/* ------------------------------------------------------- */
			are.showDialog(tList.get(0), tList);
			/* ------------------------------------------------------- */
			Incident si = are.getSelectedAccident();
			if (si != null) {
				/* ------------------------------------------------------- */
				// set the accident to the current incident
				panel.getControler().getIncident().setAccidentNr(
						si.getAccidentNr());
				panel.getControler().getIncident().setAccidentDate(
						si.getAccidentDate());
				panel.getControler().getIncident().setParentAccidentIncidentId(
						si.getId());

				panel.getIncidentModel().setAccidenNr(si.getAccidentNr());
				panel.getIncidentModel().setAccidentDate(si.getAccidentDate());

				panel.getAccidentPanel().setAccidentNumber(si.getAccidentNr());
				panel.getAccidentPanel().setAccidentDate(si.getAccidentDate());
				panel.getAccidentPanel().setAccident(true);

				panel.fireEvent();
				if (panel.getIncidentModel().getAnamnesis() != null
						&& (!panel.getIncidentModel().getAnamnesis().equals(""))) {
					this.setModified(true);
				}

				/* ------------------------------------------------------- */
			}
		}
		/* ================================================== */
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#preparetoShowup()
	 */
	@Override
	public void preparetoShowup() {
		/* ====================================================== */
		IncidentTab.this.firePropertyChange(INCIDENT_ACTIVATION, !getButton()
				.isSelected(), getButton().isSelected());
		/* ====================================================== */
	}

	class AccidentDialogButtonListener implements ActionListener {

		private IncidentPanel panel;

		public AccidentDialogButtonListener(IncidentPanel panel) {
			/* ================================================== */
			this.panel = panel;
			/* ================================================== */
		}

		public void actionPerformed(ActionEvent e) {
			/* ====================================================== */
			showAccidentDialog(panel);
			/* ====================================================== */
		}

	}

	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public void incidentEntryDeleted(IncidentEntry entry2delete) {
		// close tab in consultation screen if entry how was delete was a S.O.A.P, Measurement, Prescription or Accident
		// TODO close tab only if incident have no entries
		
		if (IncidentManager.SOAP_S.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.SOAP_O.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.SOAP_A.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.SOAP_P.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.CONS_1.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.CONS_2.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.CONS_3.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.SICK_LEAVE.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.PRESCRIPTION.equals(entry2delete.getEntryType().getName())
				|| IncidentManager.MEASUREMENT.equals(entry2delete.getEntryType().getName())
				
		){
			// close incidents tab
			removeIncident(entry2delete.getIncident());
		}
		// special entry accident
		if(AccidentHandler.ACCIDENT.equals(entry2delete
				.getEntryType().getName()))
		{
			// get IncidentManagerBean
			IncidentManager incidentManager = (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
			// get incident id
			Integer incidentId = entry2delete.getIncidentId();
			// get incident from IncidentManagerBean
			Incident in = incidentManager.getIncident(incidentId);
			
			// if the current incident is a parent accident incident, we must
			// check if there are children, if yes, -->  make one of them to parent
			in = incidentManager.removeIncidentFromAccidentList(in);
			
			// close incidents tab
			removeIncident(in);
		}
	}
}
