/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.memo;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ScrollPaneConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.htmleditor.HTMLEditor;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientMemo;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * Dialog to create or modify memos of the current patient. It is opened by the 
 * SimpleMemoView when the user double click on the list of memos.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientMemoDialog.java,v $
 * <br>Revision 1.5  2010-03-24 18:46:43  troth
 * <br>Redesign of the patient view history - PatientMemoDialog extends now from GECAMedBaseDialog
 * <br>
 */
public class PatientMemoDialog extends GECAMedBaseDialog implements
		ActionListener, Relocalizable, KeyListener {
	
	private static final long serialVersionUID = 1L;
	private HTMLEditor htmlEditor;
	private PatientMemo memo;
	private JToggleButton importantToggleButton;
	
	// ***************************************************************************
	// * Class Constants *
	// ***************************************************************************

	private final static Dimension c_PreferredSize = new Dimension(600, 400);

	protected static final String EDIT = "edit";

	// ***************************************************************************
	// * Constructor(s) *
	// ***************************************************************************

	/**
	 * 
	 */
	public PatientMemoDialog() {

		super(Translatrix.getTranslationString("PatientMemoEditorField.Title"),
				true, true);

		JScrollPane scroller;

		scroller = new JScrollPane();
		scroller
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

		htmlEditor = new HTMLEditor();
		htmlEditor.addKeyListener(this);
		scroller.setViewportView(htmlEditor);

		this.add(scroller);

		this.okButton.addActionListener(this);

		this.cancelButton.addActionListener(this);

		importantToggleButton = new JToggleButton(Translatrix
				.getTranslationString("PatientMemo.important"), GECAMedModule
				.getSmallIcon(GECAMedIconNames.WARNING));
		importantToggleButton.addActionListener(this);

		this.addButton(importantToggleButton);

		this.setSize(c_PreferredSize);

	}

	// ---------------------------------------------------------------------------

	/**
	 * Show the dialog with a specified patient memo 
	 * @param p_Memo the specified patient memo 
	 */
	public void showMemoDialog(PatientMemo p_Memo) {
		this.memo = p_Memo;
		this.htmlEditor.setText(memo.getNote());
		this.importantToggleButton
				.setSelected((p_Memo.getImportant() == null ? false : p_Memo
						.getImportant()));

		this.htmlEditor.requestFocus();

		MainFrame.showDialogCentered(this);
	}

	// ---------------------------------------------------------------------------

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent p_ActionEvent) {
		if (p_ActionEvent.getSource() == okButton) {
			this.setVisible(false);
			memo.setNote(htmlEditor.getText());
			memo.setImportant(importantToggleButton.isSelected());
		} else if (p_ActionEvent.getSource() == cancelButton) {
			this.memo = null;
			this.setVisible(false);
		} else if (p_ActionEvent.getSource().equals(importantToggleButton)) {
			/* ------------------------------------------------------- */

			/* ------------------------------------------------------- */
		}
	}

	// ---------------------------------------------------------------------------

	/**
	 * @return PatientMemo the memo of a patient 
	 */
	public PatientMemo getMemo() {
		return memo;
	}

	// ---------------------------------------------------------------------------

	/* (non-Javadoc)
	 * @see lu.tudor.santec.i18n.Relocalizable#relocalize()
	 */
	public void relocalize() {
		if (this != null)
			this.setTitle(Translatrix
					.getTranslationString("MemoEditorField.Title"));

		// if (okButton != null)
		// okButton.setText (Translatrix.getTranslationString("core.ok"));
		//
		// if (cancelButton != null)
		// cancelButton.setText
		// (Translatrix.getTranslationString("core.cancel"));
	}

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
	 */
	public void keyPressed(KeyEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 */
	public void keyReleased(KeyEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
		/* ====================================================== */
		// on ESC, close window
		if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
			cancelButton.doClick();
		/* ====================================================== */
	}

	// ***************************************************************************
	// * End of Class *
	// ***************************************************************************
}