/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.patientexport;

import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.Gender;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientStub;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.utils.SettingConstants;
import lu.tudor.santec.i18n.Translatrix;

public class PatientExportStubListTableModel extends AbstractTableModel
{
	// ~ Static fields/initializers =========================================
	
	private static final long			serialVersionUID	= 1L;
	
	// ~ Instance fields ====================================================
	
	protected Class<?>[]				columnClasses		= new Class[] { Boolean.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class };
	
	protected String[]					columnNames			= { "", Translatrix.getTranslationString("pm.socialNumber"), Translatrix.getTranslationString("pm.lastName"), Translatrix.getTranslationString("pm.maidenName"), Translatrix.getTranslationString("pm.firstName"), 
																Translatrix.getTranslationString("pm.gender"), Translatrix.getTranslationString("pm.insuranceShort"), Translatrix.getTranslationString("pm.address"), Translatrix.getTranslationString("pm.phone"), Translatrix.getTranslationString("pm.doc") };
	
	protected ArrayList<PatientStub>	patients			= new ArrayList<PatientStub>();
	
	private ArrayList<Integer>			selectedPatients 	= new ArrayList<Integer>();
	
	private HashMap<Integer, Insurance>	insurances			= new HashMap<Integer, Insurance>();
	
	private HashMap<Integer, Physician>	physician			= new HashMap<Integer, Physician>();
	
	// ~ Constructors =======================================================
	
	public PatientExportStubListTableModel()
	{
		// retrieve the needed settings
		if (PatientManagerModule.getInstance().administrativeElementsPlugin.getValue(SettingConstants.MAIDEN_CONFIG) != null && ((Boolean) PatientManagerModule.getInstance().administrativeElementsPlugin.getValue(SettingConstants.MAIDEN_CONFIG)))
		{
			
			columnNames[2] = Translatrix.getTranslationString("pm.maidenName"); // 1
			columnNames[3] = Translatrix.getTranslationString("pm.familyName"); // 2
			
		}
		
		// fetch all insurances
		try
		{
			for (Insurance i : GECAMedLists.getListReference(Insurance.class))
			{
				insurances.put(i.getId(), i);
			}
		}
		catch (Exception e)
		{
			MainFrame.reportServerError(e);
		}
		
		// fetch all Physician
		try
		{
			for (Physician p : GECAMedLists.getListReference(Physician.class))
			{
				physician.put(p.getId(), p);
			}
		}
		catch (Exception e)
		{
			MainFrame.reportServerError(e);
		}
	}
	
	// ~ Methods ============================================================
	
	/**
	 * set the ArrayList<PatientStub> containing the patients to be shown
	 * 
	 * @param patients
	 */
	public void setPatients(ArrayList<PatientStub> patients, ArrayList<Integer> selectedPatients)
	{
		this.selectedPatients = selectedPatients;
		this.patients = patients;
		fireTableDataChanged();
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#isCellEditable(int, int)
	 */
	public boolean isCellEditable(int row, int column)
	{
		return false;
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnClass(int)
	 */
	public Class<?> getColumnClass(int col)
	{
		return columnClasses[col];
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount()
	{
		return columnNames.length;
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	public String getColumnName(int col)
	{
		return "<html><b>" + columnNames[col];
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount()
	{
		return patients.size();
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int row, int col)
	{
		PatientStub patientStub = patients.get(row);
			
		switch (col)
		{
			case 0:
				return selectedPatients.contains(patientStub.getId());
			case 1:
				String matr = patientStub.getSocialSecurityNumber();
				if (matr.length() == 11)
				{
					return matr.substring(0, 8) + " " + matr.substring(8);
				}
				return matr;
			case 2:
				return patientStub.getSurName();
			case 3:
				return patientStub.getMaidenName();
			case 4:
				return patientStub.getFirstName();
			case 5:
				if (patientStub.getGender() == null)
				{
					patientStub.setGender(Gender.UNKNOWN);
				}
				return Translatrix.getTranslationString("Gender." + patientStub.getGender()).substring(0, 1).toUpperCase();
			case 6:
				return insurances.get(patientStub.getInsuranceID());
			case 7:
				return patientStub.getAddress();
			case 8:
				return patientStub.getPhone();
			case 9:
				return physician.get(patientStub.getDoctorID());
			
		}
		return null;
	}
	
	
	/**
	 * returns the internal patient id for the specified row
	 * 
	 * @param row
	 * @return
	 */
	public Integer getPatientIDforRow(int row)
	{
		try
		{
			return (Integer) this.patients.get(row).getId();
		}
		catch (Exception e)
		{
			return -1;
		}
	}
	
	
	/**
	 * returns the row for the specified patient id
	 * 
	 * @param id
	 * @return
	 */
	public int getRowForPatientID(int id)
	{
		for (int i = 0; i < patients.size(); i++)
		{
			if (patients.get(i).getId().equals(id))
				return i;
		}
		return 0;
	}
	
}
