package lu.tudor.santec.gecamed.patient.gui.patientlist;

import java.awt.BorderLayout;
import java.awt.Color;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.ModuleHeader;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Dialog to search for patients without using the search module.
 * used to pick patients for calendar entries or patient relations.
 * 
 * functionality is exactly the same as the search patient module.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientSearchDialog.java,v $
 * <br>Revision 1.21  2013-09-04 06:22:25  ferring
 * <br>patient search dialog extends now GECAMedBaseDialogImpl
 * <br>
 * <br>Revision 1.20  2012-04-12 15:29:57  troth
 * <br>Release new search dialog panel.
 * <br>
 * <br>Revision 1.2  2012-03-14 10:21:09  troth
 * <br>Code clearup.
 * <br>
 * <br>Revision 1.1  2012-03-13 17:15:09  troth
 * <br>Add testversion of new PatientSearchDialog in first step only in the agenda GeneralPanel in the AppointmentDialog.
 * <br>
 */
public class PatientSearchDialog extends GECAMedBaseDialogImpl {

	/**
	 * 
	 */
	private static final long 	serialVersionUID = 1L;

	private static PatientSearchDialog instance = new PatientSearchDialog();
	
	private PatientListPanelforPatientSearchDialog 	patientListPanel;
	
	private Patient patient;
	
	private ModuleHeader moduleHeader;
	
	public PatientSearchDialog()
	{
		super(MainFrame.getInstance(), Translatrix.getTranslationString("PatientList"), OK_CANCEL_BUTTON_MODE);
		mainPanel.setLayout(new BorderLayout());
		
		// init search header
		this.moduleHeader = new ModuleHeader(Translatrix.getTranslationString("PatientList"), PatientManagerModule.getIcon(PatientManagerModule.PATIENTS),Color.WHITE);
		
		this.patientListPanel = new PatientListPanelforPatientSearchDialog(
				this,
				this.moduleHeader
				//(PatientListModule)ModuleManager.getModule(PatientListModule.MODULE_NAME)
		);
		
		this.moduleHeader.setHeaderComponent(this.patientListPanel.getSearchComponent());
		mainPanel.add(this.moduleHeader, BorderLayout.NORTH);
		// add patientListPanel
		mainPanel.add(this.patientListPanel, BorderLayout.CENTER);
	}
	
	public void setPatient(Patient patient)
	{
		this.patient = patient;
	}
	
	public static Patient searchPatient(String filter)
	{
		instance.patient = null;
		instance.patientListPanel.getSearchTextField().setText(filter);
		instance.patientListPanel.searchPatients(true, false);
		instance.setSize((int) (MainFrame.getInstance().getWidth()* 0.9), (int) (MainFrame.getInstance().getHeight() * 0.9));
		MainFrame.showDialogCentered(instance);
		return instance.patient;
	}
	
	
	@Override
	public void cancelActionCalled ()
	{
		this.patient = null;
		super.cancelActionCalled();
	}
	
	
	@Override
	public void okActionCalled ()
	{
		this.patient = patientListPanel.getSelectedPatient();
		super.okActionCalled();
	}
}
