/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.patientlist;

import java.util.Hashtable;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.ModuleManager;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.utils.PatientSearchParameter;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


/**
 * Settings plugin for patient search related settings 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientSearchSettingsPlugin.java,v $
 * <br>Revision 1.7  2010-04-15 09:36:26  hermen
 * <br>fixed size of searchlimit field
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-06-12 08:43:42  hermen
 * <br>changed some setting defaults
 * <br>
 * <br>Revision 1.4  2008-05-30 09:12:12  hermen
 * <br>added new search setting
 * <br>
 * <br>Revision 1.3  2008-05-27 08:23:50  hermen
 * <br>fixed search in dialog and added new setting
 * <br>
 * <br>Revision 1.2  2008-04-28 08:05:48  hermen
 * <br>changed patient search to use patient_stub view and bean
 * <br>
 * <br>Revision 1.1  2008-04-14 08:11:58  hermen
 * <br>added option to use big fonts for patient seatrch and reorganized search settings
 * <br>
 * <br>Revision 1.14  2008-01-23 08:30:09  hermen
 * <br>*** empty log message ***
 * <br>
 *
 */
public class PatientSearchSettingsPlugin extends SettingsPlugin {
	private static final long serialVersionUID = 1L;

	/**
	 * name of the settings plugin
	 */
	public static final String NAME = "patientListModuleSettings";

	/**
	 * start the module with an empty patient list
	 */
	public static final String START_WITH_EMPTY_LIST = "START_WITH_EMPTY_LIST";
	
	/**
	 * start the search only when hit return
	 */
	public static final String START_SEARCH_AUTOMATIC = "START_SEARCH_AUTOMATIC";
	
	/**
	 * module which should be used to open patient records 
	 */
	public static final String OPEN_PATIENT_IN_MODULE = "openPatientInModule";

	/**
	 * should the searched patients be openend in a new tab 
	 */
	public static final String OPEN_PATIENT_IN_NEW_TAB = "openPatientInNewTab";
	
	/**
	 * minimum search characters to start the search
	 */
	public static final String MIN_SEARCH_CHARS = "MIN_SEARCH_CHARS";
	
	/**
	 * typing delay before the search will be startet 
	 */
	public static final String SEARCH_DELAY = "SEARCH_DELAY";
	
	/**
	 * limit the search results
	 */
	public static final String SEARCH_LIMIT = "SearchLimit";
	
	/**
	 * show an extra matricule search field 
	 */
	public static final String SEARCH_MATRICULE_FIELD = "SEARCH_MATRICULE_FIELD";

	/**
	 * show big fonts in search
	 */
	public static final String SEARCH_BIG_FONTS = "SEARCH_BIG_FONTS";

	private JPanel openPatientPanel;

	private JComboBox openPatientModule;

	private JLabel openPatientLabel;

	private JCheckBox inTabs;

	private JPanel searchOptionsPanel;

	private JSlider delaySlider;

	private JLabel delayLabel;

	private JLabel charLabel;

	private JSpinner charSpinner;

	private JCheckBox showMatriculeSearchField = new JCheckBox();

	private IntegerField searchlimit;
	
	private JCheckBox bigFonts = new JCheckBox();
	
	private JCheckBox startSearchAutomatic = new JCheckBox();
	
	private JCheckBox startWithEmptyList = new JCheckBox();
	
	/**
	 * creates a new PatientListSettingsPlugin
	 */
	public PatientSearchSettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * creates a new PatientListSettingsPlugin
	 * 
	 * @param p_Name
	 */
	public PatientSearchSettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * builds the gui
	 */
	@SuppressWarnings("unchecked")
	private void buildPanel() {

		setLabel(Translatrix.getTranslationString("PatientList"));

		this.openPatientPanel = createSubPanel(Translatrix
				.getTranslationString("list.openPatients"));
		this.openPatientPanel.setLayout(new FormLayout("pref:grow, 3dlu, 70dlu", "top:pref, 3dlu, pref"));
		CellConstraints cc = new CellConstraints();

		this.openPatientLabel = new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.selectModuleToOpenPatient"));
		this.openPatientPanel.add(openPatientLabel, cc.xy(1,1));

		this.openPatientModule = new JComboBox();
		this.openPatientPanel.add(openPatientModule, cc.xy(3,1));

		this.inTabs = new JCheckBox(Translatrix.getTranslationString("PatientSearchSettingsPlugin.openInNewTab"));
		this.openPatientPanel.add(inTabs, cc.xyw(1,3,3));

		addSubPanel(openPatientPanel);

// #####################################################

		this.searchOptionsPanel = createSubPanel(Translatrix
				.getTranslationString("PatientSearchSettingsPlugin.searchOptions"));
		this.searchOptionsPanel.setLayout(new FormLayout("pref, 2dlu, pref:grow, 2dlu, right:pref","pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));

		this.searchOptionsPanel.add(new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.startWithEmptyList")), cc.xyw(1,1,3));
		this.searchOptionsPanel.add(this.startWithEmptyList, cc.xy(5,1));
		
		
		startSearchAutomatic.addChangeListener(new ChangeListener() {
		    public void stateChanged(ChangeEvent e) {
			charLabel.setEnabled(startSearchAutomatic.isSelected());
			charSpinner.setEnabled(startSearchAutomatic.isSelected());
			delayLabel.setEnabled(startSearchAutomatic.isSelected());
			delaySlider.setEnabled(startSearchAutomatic.isSelected());
		    }
		});
		
		this.searchOptionsPanel.add(new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.startWithReturn")), cc.xyw(1,3,3));
		this.searchOptionsPanel.add(this.startSearchAutomatic, cc.xy(5,3));
		
		this.charLabel = new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.minChars"));
		this.searchOptionsPanel.add(charLabel, cc.xy(1,5));

		SpinnerModel model = new SpinnerNumberModel(3, 0, 10, 1);
		this.charSpinner = new JSpinner(model);
		this.searchOptionsPanel.add(charSpinner, cc.xy(5,5));

		this.delayLabel = new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.searchDelay"));
		this.searchOptionsPanel.add(delayLabel, cc.xy(1,7));
		this.delaySlider = new JSlider(JSlider.HORIZONTAL, 100, 1000, PatientSearchParameter.DEFAULT_SEARCH_DELAY);
		this.delaySlider.setMajorTickSpacing(500);
		this.delaySlider.setMinorTickSpacing(100);
		//	Create the label table
		Hashtable labelTable = new Hashtable();
		labelTable.put( Integer.valueOf( 100 ), new JLabel("100ms") );
		labelTable.put( Integer.valueOf( 500 ), new JLabel("500ms") );
		labelTable.put( Integer.valueOf( 1000 ), new JLabel("1s") );
		this.delaySlider.setLabelTable( labelTable );
		this.delaySlider.setPaintTicks(true);
		this.delaySlider.setPaintLabels(true);
		this.searchOptionsPanel.add(delaySlider, cc.xyw(3,7,3));
		
		this.searchlimit = new IntegerField(6);
		this.searchOptionsPanel.add(new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.SearchLimit")), cc.xyw(1,9,3));
		this.searchOptionsPanel.add(searchlimit, cc.xy(5,9));
		
		this.searchOptionsPanel.add(new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.ShowMatriculeSearchField")), cc.xy(1,11));
		this.searchOptionsPanel.add(this.showMatriculeSearchField, cc.xy(5,11));
		
		this.searchOptionsPanel.add(new JLabel(Translatrix.getTranslationString("PatientSearchSettingsPlugin.BigFonts")), cc.xyw(1,13,3));
		this.searchOptionsPanel.add(this.bigFonts, cc.xy(5,13));

		addSubPanel(this.searchOptionsPanel);

		setIcon(PatientManagerModule.getIcon(PatientManagerModule.PATIENTS));
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#revertToDefaults()
	 */
	public void revertToDefaults() {
		
	   	this.startWithEmptyList.setSelected((Boolean) getDefault(START_WITH_EMPTY_LIST));
	    	this.startSearchAutomatic.setSelected((Boolean) getDefault(START_SEARCH_AUTOMATIC));
	    
	    	this.openPatientModule.setSelectedItem((String) getDefault(OPEN_PATIENT_IN_MODULE));
		this.inTabs.setSelected((Boolean) getDefault(OPEN_PATIENT_IN_NEW_TAB));
		try {
			this.charSpinner.setValue((Integer) getDefault(MIN_SEARCH_CHARS));
			this.delaySlider.setValue((Integer) getDefault(SEARCH_DELAY));
		} catch (Exception e) {}

		this.searchlimit.setValue((Integer) getDefault(SEARCH_LIMIT));
		this.showMatriculeSearchField.setSelected((Boolean) getDefault(SEARCH_MATRICULE_FIELD));
		this.bigFonts.setSelected((Boolean) getDefault(SEARCH_BIG_FONTS));
		
		
		reflectSettings();
		super.revertToDefaults();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
	    
	    	setValue(START_WITH_EMPTY_LIST, (Boolean) this.startWithEmptyList.isSelected());
	    	setValue(START_SEARCH_AUTOMATIC, (Boolean) this.startSearchAutomatic.isSelected());
	    
		setValue(OPEN_PATIENT_IN_MODULE, (String) this.openPatientModule.getSelectedItem());
		setValue(OPEN_PATIENT_IN_NEW_TAB, (Boolean) this.inTabs.isSelected());

		setValue(MIN_SEARCH_CHARS, (Integer) charSpinner.getValue());
		setValue(SEARCH_DELAY, (Integer) delaySlider.getValue() );
		
		setValue(SEARCH_LIMIT, this.searchlimit.getValue());
		setValue(SEARCH_MATRICULE_FIELD, showMatriculeSearchField.isSelected());
		setValue(SEARCH_BIG_FONTS, bigFonts.isSelected());
		
		super.updateSettings();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		super.reflectSettings();
		fillComboBox();
		
		this.startWithEmptyList.setSelected((Boolean) getValue(START_WITH_EMPTY_LIST));
		this.startSearchAutomatic.setSelected((Boolean) getValue(START_SEARCH_AUTOMATIC));
		
		this.openPatientModule.setSelectedItem((String) getValue(OPEN_PATIENT_IN_MODULE));
		this.inTabs.setSelected((Boolean) getValue(OPEN_PATIENT_IN_NEW_TAB));

		try {
			this.charSpinner.setValue((Integer) getValue(MIN_SEARCH_CHARS));
			this.delaySlider.setValue((Integer) getValue(SEARCH_DELAY));
		} catch (Exception e) {}
		
		this.searchlimit.setValue((Integer) getValue(SEARCH_LIMIT));
		this.showMatriculeSearchField.setSelected((Boolean) getValue(SEARCH_MATRICULE_FIELD));
		this.bigFonts.setSelected((Boolean) getValue(SEARCH_BIG_FONTS));
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		super.relocalize();

		setLabel(Translatrix.getTranslationString("PatientList"));
		setSubPanelTitle(openPatientPanel, Translatrix
				.getTranslationString("list.listSettings"));
		openPatientLabel.setText(Translatrix.getTranslationString("PatientSearchSettingsPlugin.selectModuleToOpenPatient"));
		inTabs.setText(Translatrix.getTranslationString("PatientSearchSettingsPlugin.openInNewTab"));

	}

	/**
	 * set some stationary defaults
	 */
	public void setStationaryValues() {
	    	
	    	setStationary(START_WITH_EMPTY_LIST, false);
	    	setStationary(START_SEARCH_AUTOMATIC, true);
	    
		setStationary(OPEN_PATIENT_IN_MODULE, PatientManagerModule.MODULE_NAME);
		setStationary(OPEN_PATIENT_IN_NEW_TAB, false);

		setStationary(MIN_SEARCH_CHARS, PatientSearchParameter.DEFAULT_SEARCH_CHARACTER);
		setStationary(SEARCH_DELAY,		PatientSearchParameter.DEFAULT_SEARCH_DELAY);
		
		setStationary(SEARCH_LIMIT, 	PatientSearchParameter.DEFAULT_SEARCH_LIMIT);
		setStationary(SEARCH_MATRICULE_FIELD, false);
		setStationary(SEARCH_BIG_FONTS, false);
	}



	/**
	 * fill the combobox to select the module to open patients
	 */
	private void fillComboBox() {
		openPatientModule.removeAllItems();
//		openPatientModule.addItem(Translatrix.getTranslationString("list.openPatients"));
		openPatientModule.addItem(GECAMedModule.LAST_SELECTED_MODULE);
		
		if (ModuleManager.getModuleNamesToDisplayPatients() != null)
//		if (MainFrame.getInstance().getModuleNamesToDisplayPatients() != null)
			for (String name : ModuleManager.getModuleNamesToDisplayPatients())
				openPatientModule.addItem(name);
	}

}
