package lu.tudor.santec.gecamed.patient.gui.patientlist;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import lu.tudor.santec.gecamed.patient.utils.PatientNameFormatter;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: UnaccentDocument.java,v $
 * <br>Revision 1.1  2013-04-09 07:37:30  ferring
 * <br>Patient search unaccented
 * <br>
 */

public class UnaccentDocument extends PlainDocument
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	@Override
	public void insertString(int offs, String str, AttributeSet a) throws BadLocationException
	{
		super.insertString(offs, PatientNameFormatter.unaccent(str), a);
	}
}
