package lu.tudor.santec.gecamed.patient.gui.settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ConsultationConfigDialog.java,v $
 * <br>Revision 1.11  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.10  2013-12-03 16:29:45  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.9  2013-11-29 15:16:17  troth
 * <br>Fix some bugs:
 * <br>Consultation view if first panel is empty
 * <br>History view sickleave date
 * <br>
 * <br>Revision 1.8  2013-11-29 08:20:22  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.7  2013-11-08 09:48:07  troth
 * <br>Fix Bug: Text content field of entry now can be disable.
 * <br>
 * <br>Revision 1.6  2013-10-30 15:01:03  troth
 * <br>Code clear up.
 * <br>
 * <br>Revision 1.5  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.4  2013-09-12 14:29:32  troth
 * <br>Add the global 'Measurment Value settings' the ConsultationConfigDialog.
 * <br>
 * <br>Revision 1.3  2013-07-25 14:31:55  troth
 * <br>Now the global settings panel for consultation entries save the data in the setting table of the database.
 * <br>
 * <br>Revision 1.2  2013-07-24 09:12:38  troth
 * <br>Add final version of settings for the consultation config panel.
 * <br>
 */
public class ConsultationConfigDialog extends GECAMedBaseDialogImpl implements ActionListener, DocumentListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private JTextField		idField;
	
	private JTextField		acronymField;
	
	private JTextField		nameField;
	
	private JCheckBox		codeCheckBox;
	
	private JTextField		codeField;
	
	private JCheckBox		contentCheckBox;
	
	private JButton			colorButton;
	
	private JTextField		positionField;
	
	private boolean 		actionOk = false;
	
	private JPanel			measurementPanel = null;
	
	private boolean 		contentFieldExists = false;
	
	private boolean			codeFieldExists = false;
	
	private boolean			contentFieldIsSelect;
	
	private boolean			codeFieldIsSelect;
	
	private boolean			nameFieldFilled;
	
	private boolean			acronymFieldFilled;
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public ConsultationConfigDialog(JPanel measurementPanel)
	{
		super(MainFrame.getInstance(), "", OK_CANCEL_BUTTON_MODE);
		this.measurementPanel = measurementPanel;
		this.contentFieldExists = false;
		this.codeFieldExists = false;
		buildPanel();
	}
	
	public ConsultationConfigDialog(Boolean contentFieldExists, Boolean codeFieldExists)
	{
		super(MainFrame.getInstance(), "", OK_CANCEL_BUTTON_MODE);
		this.contentFieldExists = contentFieldExists;
		this.codeFieldExists = codeFieldExists;
		buildPanel();
	}
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	private void buildPanel()
	{
		JLabel			label;
		CellConstraints	cc		= new CellConstraints();
		int				row		= 0;
		
		
		this.mainPanel.setLayout(new FormLayout("5px, fill:pref, 5px, fill:250px, 5px", 
				"5px,fill:pref," + // id
				"5px,fill:pref," + // acronym
				"5px,fill:pref," + // name
				"5px,fill:pref," + // code + code field
				"5px,fill:pref," + // color button
				"5px,fill:pref," + // content field
				"5px,fill:pref," + // position
				"5px,fill:pref," + // measurementPanel
				"5px"));
		
		// id
		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.idLabel"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.idLabel.toolTip"));
		this.idField = new JTextField();
		this.idField.setEditable(false);
		mainPanel.add(label,				cc.xy(2, row+=2));
		mainPanel.add(this.idField, 		cc.xy(4, row));
		
		
		// acronym
		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.acronymLabel"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.acronymLabel.toolTip"));
		this.acronymField = new LimitTextField(5);
		this.acronymField.getDocument().addDocumentListener(this);
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		this.mainPanel.add(this.acronymField, 	cc.xy(4, row));
		
		// name
		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.nameLabel"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.nameLabel.toolTip"));
		this.nameField = new LimitTextField(50);
		this.nameField.getDocument().addDocumentListener(this);
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		this.mainPanel.add(this.nameField,		cc.xy(4, row));
		
		// code
//		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.codeLabel"));
//		label.setOpaque(false);
//		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.codeLabel.toolTip"));
		
		if(this.codeFieldExists)
		{
			this.codeCheckBox = new JCheckBox(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.codeLabel"));
			this.codeCheckBox.setOpaque(false);
			this.codeCheckBox.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.codeLabel.toolTip"));
			this.codeCheckBox.addActionListener(this);
			this.codeField = new LimitTextField(50);
			this.mainPanel.add(this.codeCheckBox,	cc.xy(2, row+=2));
			this.mainPanel.add(this.codeField,	 	cc.xy(4, row));
		}
		
		if(this.contentFieldExists)
		{
			// content field
			this.contentCheckBox	= new JCheckBox(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.contentField"));
			this.contentCheckBox.setOpaque(false);
			this.contentCheckBox.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.contentField.toolTip"));
			this.contentCheckBox.addActionListener(this);
			this.mainPanel.add(this.contentCheckBox,		cc.xyw(2, row+=2, 3));
		}
		
		// color button
		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.color"));
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.color.toolTip"));
		this.colorButton = new JButton();
		this.colorButton.setBackground(Color.RED);
		this.colorButton.setPreferredSize(new Dimension(40, 40)); // 40, 15
		this.colorButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent arg0)
			{
				showColorChooser();
			}
		});
		this.mainPanel.add(label,	 			cc.xy(2, row+=2));
		mainPanel.add(this.colorButton,		cc.xy(4, row));
		
		// position
		label = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.position"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.position.toolTip"));
		this.positionField = new LimitTextField(5);
		this.positionField.setEditable(false);
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		this.mainPanel.add(this.positionField, 	cc.xy(4, row));
		
		// measurementPanel
		if(this.measurementPanel != null)
		{	
			this.mainPanel.add(this.measurementPanel, 	cc.xyw(2, row+=2, 3));
		}
	}
	
	
	public ConsultationEntryConfig showDialog(ConsultationEntryConfig ece)
	{
		setTitle(Translatrix.getTranslationString("patient.settings.consultationConfigDialog.title"));
		this.pack();
		this.setLocationRelativeTo(getOwner());
		iniDialog(ece);
		this.setVisible(true);
		
		Boolean contentFieldIsShow = false;
		if(this.contentFieldExists) contentFieldIsShow = contentCheckBox.isSelected();
		
		Boolean codeFieldIsShow = false;
		String codeLabel = "";
		if(this.codeFieldExists)
		{
			codeFieldIsShow = codeCheckBox.isSelected();
			codeLabel = codeField.getText();
		}
		
		if(this.actionOk)
		{
			ece = new ConsultationEntryConfig(
					idField.getText(),
					acronymField.getText(),
					nameField.getText(),
					codeLabel,
					colorButton.getBackground().getRGB(),
					contentFieldIsShow,
					codeFieldIsShow,
					ece.getEnabled(),
					Integer.parseInt(positionField.getText())-1
					);
		}
		
		return ece;
	}
	
	private void iniDialog(ConsultationEntryConfig ece)
	{
		// transfer the data to fields
		this.idField.setText(ece.getId());
		this.acronymField.setText(ece.getAcronym());
		if(this.acronymField.getText().equals("")) this.acronymFieldFilled = false;
		else this.acronymFieldFilled = true;
		this.nameField.setText(ece.getName());
		if(this.nameField.getText().equals("")) this.nameFieldFilled = false;
		else this.nameFieldFilled = true;
		this.colorButton.setBackground(new Color(ece.getColor())); 
		if(this.contentFieldExists)
		{
			this.contentCheckBox.setSelected(ece.getContentField());
			this.contentFieldIsSelect = ece.getContentField();
		}
		if(this.codeFieldExists)
		{
			this.codeCheckBox.setSelected(ece.getCodeField());
			this.codeFieldIsSelect = ece.getCodeField();
			this.codeField.setText(ece.getCodeLabel());
		}
		this.positionField.setText(String.valueOf(ece.getPosition()+1));
		enableOkButton();
	}
	
	
	@Override
	public void okActionCalled()
	{
		// check the entered data // TODO if require data are set
//		if (acronymField.getText().trim().equals("")
//				|| hl7AcronymField.getText().trim().equals("")
//				|| (!colorButton.isSelected() && !contentField.isSelected()))
//		{
//			// show error
//			GECAMedBaseDialogImpl.showMessageDialog(this, 
//					Translatrix.getTranslationString("title"), 
//					Translatrix.getTranslationString("<html>The data is not filled out correctly.<br><br>" +
//							"You need to enter an acronym and the insurance must be a <br>" +
//							"primary or 3rd party payer insurance."), 
//					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
//					GECAMedModule.getIcon(GECAMedIconNames.ERROR));
//			
//			return;
//		}
		actionOk = true;
		super.okActionCalled();
	}
	
	/**
	 * Show the color chooser with the default color white
	 */
	private void showColorChooser()
	{
		Color baseColor = Color.WHITE;
		Color color = JColorChooser.showDialog(colorButton, Translatrix.getTranslationString("patient.settings.consultationConfigDialog.colorChooser"), baseColor);
		
		if (color == null)
			return;
		
		// set color
		this.colorButton.setBackground(color);
	}

	public void actionPerformed(ActionEvent ae)
	{
		if(this.codeCheckBox.equals(ae.getSource()))
		{
			if(!this.codeCheckBox.isSelected())
			{
				this.codeFieldIsSelect = false;
				this.codeField.setEnabled(false);
			}else{
				this.codeFieldIsSelect = true;
				this.codeField.setEnabled(true);
			}
			enableOkButton();
		}
		
		if(this.contentFieldExists)
			if(this.contentCheckBox.equals(ae.getSource()))
			{
				if(!this.contentCheckBox.isSelected()) this.contentFieldIsSelect = false;
				else this.contentFieldIsSelect = true;
				enableOkButton();
			}
	}
	
	public void enableOkButton()
	{
		if(this.nameFieldFilled && this.acronymFieldFilled)
		{
			if(codeFieldExists && contentFieldExists)
				if(this.codeFieldIsSelect || this.contentFieldIsSelect)
				{
					this.okAction.setEnabled(true);
				}else 
					this.okAction.setEnabled(false);
			else
				this.okAction.setEnabled(true);
		}else
			this.okAction.setEnabled(false);
	}

	public void changedUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}

	public void insertUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}

	public void removeUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}
	
	public void documentChange(DocumentEvent pce)
	{
		if(this.nameField.getDocument().equals(pce.getDocument()))
		{
			if(this.nameField.getText().equals("")) this.nameFieldFilled = false;
			else this.nameFieldFilled = true;
			enableOkButton();
		}
		
		if(this.acronymField.getDocument().equals(pce.getDocument()))
		{
			if(this.acronymField.getText().equals("")) this.acronymFieldFilled = false;
			else this.acronymFieldFilled = true;
			enableOkButton();
		}
	}
}
