package lu.tudor.santec.gecamed.patient.gui.settings;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.formeditor.gui.component.NumericField;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.InsuranceBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.InsuranceInterface;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class EditInsuranceDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private Insurance		insurance;
	
	private JTextField		acronymField;
	
	private JTextField		nameField;
	
	private NumericField	majorationField;
	
	private JCheckBox		ucmAffiliatedBox;
	
	private JCheckBox		primaryBox;
	
	private JCheckBox		thirdPartyBox;
	
	private JCheckBox		privateBox;
	
	private JCheckBox		disbandedBox;
	
	private JTextField		hl7AcronymField;
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public EditInsuranceDialog()
	{
		super(MainFrame.getInstance(), "", OK_CANCEL_BUTTON_MODE);
		
		buildPanel();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	private void buildPanel()
	{
		JLabel			label;
		CellConstraints	cc		= new CellConstraints();
		int				row		= 0;
		
		
		mainPanel.setLayout(new FormLayout("5px, f:p, 5px, f:250px, 5px", 
				"5px,f:p," + // acronym
				"5px,f:p," + // name
				"5px,f:p," + // majoration
				"5px,f:p," + // primary
				"5px,f:p," + // third party
				"5px,f:p," + // private
				"5px,f:p," + // UCM affiliated
				"5px,f:p," + // disbanded
				"5px,f:p," + // hl7Acronym
				"5px"));
		
		// DEFINE & ADD THE COMPONENTS ...
		// acronym
		label				= new JLabel(Translatrix.getTranslationString("patient.settings.acronym"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.acronym.toolTip"));
		acronymField		= new LimitTextField(255);
		mainPanel.add(label,			cc.xy(2, row+=2));
		mainPanel.add(acronymField,		cc.xy(4, row));
		
		// hl7Acronym
		label				= new JLabel(Translatrix.getTranslationString("patient.settings.hl7Acronym"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.hl7Acronym.toolTip"));
		hl7AcronymField		= new LimitTextField(255);
		mainPanel.add(label,			cc.xy(2, row+=2));
		mainPanel.add(hl7AcronymField,		cc.xy(4, row));
		
		// name
		label				= new JLabel(Translatrix.getTranslationString("patient.settings.name"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.name.toolTip"));
		nameField			= new LimitTextField(128);
		mainPanel.add(label,			cc.xy(2, row+=2));
		mainPanel.add(nameField,		cc.xy(4, row));
		
		// majoration value
		label	= new JLabel(Translatrix.getTranslationString("patient.settings.majoration"));
		label.setOpaque(false);
		label.setToolTipText(Translatrix.getTranslationString("patient.settings.majoration.toolTip"));
		majorationField	= new NumericField(1.0);
		mainPanel.add(label, 			cc.xy(2, row+=2));
		mainPanel.add(majorationField, 	cc.xy(4, row));
		
		// is primary
		primaryBox			= new JCheckBox(Translatrix.getTranslationString("patient.settings.primary"));
		primaryBox.setOpaque(false);
		primaryBox.setToolTipText(Translatrix.getTranslationString("patient.settings.primary.toolTip"));
		mainPanel.add(primaryBox,		cc.xyw(2, row+=2, 3));
		
		// is 3rd party payer
		thirdPartyBox		= new JCheckBox(Translatrix.getTranslationString("patient.settings.3rdParty"));
		thirdPartyBox.setOpaque(false);
		thirdPartyBox.setToolTipText(Translatrix.getTranslationString("patient.settings.3rdParty.toolTip"));
		mainPanel.add(thirdPartyBox,	cc.xyw(2, row+=2, 3));
		
		// is private
		privateBox			= new JCheckBox(Translatrix.getTranslationString("patient.settings.private"));
		privateBox.setOpaque(false);
		privateBox.setToolTipText(Translatrix.getTranslationString("patient.settings.private.toolTip"));
		mainPanel.add(privateBox,		cc.xyw(2, row+=2, 3));
		
		// is UCM affiliated
		ucmAffiliatedBox	= new JCheckBox(Translatrix.getTranslationString("patient.settings.ucmAffiliated"));
		ucmAffiliatedBox.setOpaque(false);
		ucmAffiliatedBox.setToolTipText(Translatrix.getTranslationString("patient.settings.ucmAffiliated.toolTip"));
		mainPanel.add(ucmAffiliatedBox,	cc.xyw(2, row+=2, 3));
		
		// is disbanded
		disbandedBox		= new JCheckBox(Translatrix.getTranslationString("patient.settings.disbanded"));
		disbandedBox.setOpaque(false);
		disbandedBox.setToolTipText(Translatrix.getTranslationString("patient.settings.disbanded.toolTip"));
		mainPanel.add(disbandedBox,		cc.xyw(2, row+=2, 3));
		
	}
	
	
	public Insurance show (Insurance insurance)
	{
		setTitle(insurance == null
				? Translatrix.getTranslationString("pm.EditInsuranceDialog.NewTitle")
				: Translatrix.getTranslationString("pm.EditInsuranceDialog.EditTitle"));
		
		if (insurance == null)
			insurance	= new Insurance();
		
		this.insurance	= insurance;
		
		acronymField.setText(			insurance.getAcronym()		== null ? ""	: insurance.getAcronym());
		nameField.setText(				insurance.getName()			== null ? ""	: insurance.getName());
		majorationField.setValue(		insurance.getMajoration()	== null ? 1.0	: insurance.getMajoration());
		primaryBox.setSelected(			insurance.getPrimary()		== null ? false	: insurance.getPrimary());
		thirdPartyBox.setSelected(		insurance.getThirdParty()	== null	? false : insurance.getThirdParty());
		privateBox.setSelected(			insurance.getPrivate()		== null	? false : insurance.getPrivate());
		ucmAffiliatedBox.setSelected(	insurance.getUcmAffiliated()== null	? false : insurance.getUcmAffiliated());
		disbandedBox.setSelected(		insurance.getDisbanded()	== null ? false : insurance.getDisbanded());
		hl7AcronymField.setText(		insurance.getHl7Acronym()		== null ? ""	: insurance.getHl7Acronym());
		
		this.pack();
		this.setLocationRelativeTo(getOwner());
		this.setVisible(true);
		
		return insurance;
	}
	
	
	@Override
	public void okActionCalled()
	{
		InsuranceInterface	manager;
		
		
		// check the entered data
		if (acronymField.getText().trim().equals("")
				|| hl7AcronymField.getText().trim().equals("")
				|| (!primaryBox.isSelected() && !thirdPartyBox.isSelected()))
		{
			// show error
			GECAMedBaseDialogImpl.showMessageDialog(this, 
					Translatrix.getTranslationString("title"), 
					Translatrix.getTranslationString("<html>The data is not filled out correctly.<br><br>" +
							"You need to enter an acronym and the insurance must be a <br>" +
							"primary or 3rd party payer insurance."), 
					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
					GECAMedModule.getIcon(GECAMedIconNames.ERROR));
			
			return;
		}
		
		// transfer the data
		insurance.setAcronym(acronymField.getText());
		insurance.setName(nameField.getText());
		insurance.setMajoration(majorationField.getDouble());
		insurance.setPrimary(primaryBox.isSelected());
		insurance.setThirdParty(thirdPartyBox.isSelected());
		insurance.setPrivate(privateBox.isSelected());
		insurance.setUcmAffiliated(ucmAffiliatedBox.isSelected());
		insurance.setDisbanded(disbandedBox.isSelected());
		insurance.setHl7Acronym(hl7AcronymField.getText());
		
		// save the insurance
		manager	= (InsuranceInterface) ManagerFactory.getRemote(InsuranceBean.class);
		manager.save(insurance);
		
		super.okActionCalled();
	}
}
