/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.ModuleManager;
import lu.tudor.santec.gecamed.core.gui.utils.ComponentTitledPanel;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.esante.gui.tab.ESanteTab;
import lu.tudor.santec.gecamed.formeditor.gui.view.FormTab;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntryType;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.MeasurementType;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.InsuranceBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.InsuranceInterface;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.incident.IncidentTab;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Adminsettings panel for the patient module.
 * It offers the possibility to add up to three additional measurement fields
 * to the consultation form.
 * The fields are relevant for all users of the installation.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientModuleSettings.java,v $
 * <br>Revision 1.33  2013-11-29 15:16:17  troth
 * <br>Fix some bugs:
 * <br>Consultation view if first panel is empty
 * <br>History view sickleave date
 * <br>
 * <br>Revision 1.32  2013-11-29 09:16:31  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.31  2013-11-28 10:38:24  ferring
 * <br>GECAMedUtils split into utils and GUI utils classes
 * <br>
 * <br>Revision 1.30  2013-11-22 13:51:39  troth
 * <br>Fix some small bugs in the consultation view.
 * <br>Add new gui function the patient setting to config the consultation view.
 * <br>
 * <br>Revision 1.29  2013-11-15 15:00:52  troth
 * <br>Little GUI fix.
 * <br>
 * <br>Revision 1.28  2013-11-08 09:48:07  troth
 * <br>Fix Bug: Text content field of entry now can be disable.
 * <br>
 * <br>Revision 1.27  2013-11-06 11:15:33  troth
 * <br>Remove the name of the ImportantData in the settings.
 * <br>
 * <br>Revision 1.26  2013-10-29 11:09:46  troth
 * <br>Now the global settings of the consultation entry config view use the translations too.
 * <br>
 * <br>Revision 1.25  2013-10-29 09:59:19  troth
 * <br>Update consultation default config entry.
 * <br>
 * <br>Revision 1.24  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.23  2013-10-28 16:55:13  ferring
 * <br>consultation panels bug fixes
 * <br>
 * <br>Revision 1.22  2013-09-12 14:29:32  troth
 * <br>Add the global 'Measurment Value settings' the ConsultationConfigDialog.
 * <br>
 * <br>Revision 1.21  2013-09-11 13:14:45  troth
 * <br>Fix NullPointerException data in model was select before the settings was load.
 * <br>
 * <br>Revision 1.20  2013-09-11 11:00:28  troth
 * <br>Add global settings for the ImportantDataPanel to enable / disable and set the position of a Panel.
 * <br>
 * <br>Revision 1.19  2013-09-03 11:17:11  troth
 * <br>The new consultation view with more entries and the sickleave (GUI only work).
 * <br>
 * <br>Revision 1.18  2013-07-30 14:18:07  troth
 * <br>Fix bug: the default values was not set if not set in DB.
 * <br>
 * <br>Revision 1.17  2013-07-30 12:08:27  troth
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.16  2013-07-29 07:51:25  ferring
 * <br>Handling null value in settings
 * <br>
 * <br>Revision 1.15  2013-07-25 14:31:55  troth
 * <br>Now the global settings panel for consultation entries save the data in the setting table of the database.
 * <br>
 * <br>Revision 1.14  2013-07-24 09:12:38  troth
 * <br>Add final version of settings for the consultation config panel.
 * <br>
 * <br>Revision 1.13  2013-07-17 16:27:11  troth
 * <br>Add dialog for settings of the consultation config panel.
 * <br>
 */
public class PatientModuleSettings extends SettingsPlugin implements ActionListener {

	
	private static final long serialVersionUID = 1L;

	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(PatientModuleSettings.class.getName());


	public final static String NAME = "patient";

	private JPanel measurementPanel;

	private JLabel explanationLabel;

	private HashMap<String, JTextField> nameHash;

	private HashMap<String, JTextField> unitHash;

	private HashMap<String, JCheckBox> numericHash;

	private CellConstraints cc;

	private HashMap<String,JCheckBox> typeHash;

	private HashMap<String, MeasurementType> measurementTypeHash;
	
	// INSURANCE EDITING
	private JPanel				insurancePanel;
	
	private JComboBox			insurances;
	
	private JButton				addInsurance;
	
	private JButton				editInsurance;
	
	private JButton				reloadInsurances;
	
	private EditInsuranceDialog	insuranceDialog;
	
	
	private JPanel				historytabsPanel;
	
	// Consultation Config Panel
	private JPanel 				consultationPanel;
	private JList 				consultationEntryList;
	private JButton 			enableButton;
	private JButton 			disableButton;
	private JButton 			upButton;
	private JButton 			downButton;
	private JButton				editButton;
	
	
	private JList 				historytabsList;
	private JButton 			enabletabButton;
	private JButton 			disabletabButton;
	private JButton 			uptabButton;
	private JButton 			downtabButton;
	private JButton				edittabButton;
	
	private JButton				addButton;
	private JButton				deleteButton;
	
	private ConsultationConfigDialog consultationConfigDialog;
	private HistoryTabConfigDialog historyTabConfigDialog;
	
	private static ConsultationEntryConfig soapS	 		= null;
    private static ConsultationEntryConfig soapO	 		= null;
    private static ConsultationEntryConfig soapA	 		= null;
    private static ConsultationEntryConfig soapP	 		= null;
    private static ConsultationEntryConfig cons1	 		= null;
    private static ConsultationEntryConfig cons2	 		= null;
    private static ConsultationEntryConfig cons3	 		= null;
    private static ConsultationEntryConfig measurement		= null;
    private static ConsultationEntryConfig sickLeave		= null;
    private static ConsultationEntryConfig newColumn		= null;
	
	// Default data String - id, acronym, name, codeLabel, color, contentField, codeField, enabled, position
	public static final String SOAPS_DEFAULTS 			= "soap.s;S;soap.s;Code;-1;true;true;true;0";
    public static final String SOAPO_DEFAULTS 			= "soap.o;O;soap.o;;-200;true;false;true;1";
    public static final String SOAPA_DEFAULTS 			= "soap.a;A;soap.a;ICD10;-3009;true;true;true;3";
    public static final String SOAPP_DEFAULTS 			= "soap.p;P;soap.p;;-1;true;false;true;4";
    public static final String CONS1_DEFAULTS 			= "cons.1;C1;cons.1;;-1;true;false;false;5";
    public static final String CONS2_DEFAULTS 			= "cons.2;C2;cons.2;;-1;true;false;false;6";
    public static final String CONS3_DEFAULTS 			= "cons.3;C3;cons.3;;-1;true;false;false;7";
    public static final String MEASUREMENT_DEFAULTS		= "measurement;Mx;measurement;;-1;false;false;true;2";
    public static final String SICKLEAVE_DEFAULTS		= "sick_leave;SL;sick_leave;;-1;false;true;false;8";
    public static final String NEW_COLUMN_DEFAULTS		= "new_column;;------------------------------------;;-1;false;false;true;9";
    
    public static final String NEW_COLUMN				= "new_column";
    
    
    public static final String HISTORY_DEFAULTS			= "full_view;true;0"+"\n"
    														+"diagnosis;true;1;soap.a:"+"\n"
															+ "letters;true;2;letter:"+"\n"
															+"files;true;3;file;"+"\n"
															+"prescriptions;true;4;prescription:"+"\n"
															+"forms;true;5;form:"+"\n"
															+"cda;true;6;cda:"+"\n"
															+"Ac;true;7;ac:";
    
    
    public static ConsultationEntryConfig[] consultationEntries = new ConsultationEntryConfig[10];
    
    private Vector<HistoryTabEntryConfig> historytabEntries = new Vector<HistoryTabEntryConfig>();
    
  //  private String[] HistoryEntryConfig;
    
    // ImportantDataPanel Settings
	public static ImportantDataPanelConfig activeProblems 		= null;
	public static ImportantDataPanelConfig allergies 			= null;
	public static ImportantDataPanelConfig antecedents 			= null;
	public static ImportantDataPanelConfig chronicalTreatments 	= null;
	
	// HistoryTabsDataPanel Settings
	public static HistoryTabEntryConfig fullview = null;
	public static HistoryTabEntryConfig diagnosis = null;
	public static HistoryTabEntryConfig letters = null;
	public static HistoryTabEntryConfig files = null;
	public static HistoryTabEntryConfig prescriptions = null;
	public static HistoryTabEntryConfig forms = null;
	public static HistoryTabEntryConfig cda = null;
	
    // Default data
	private static final String ACTIVE_PROBLEMS_DEFAULTS = IncidentManager.ACTIVE_PROBLEMS + ";true;0";
	private static final String ALLERGIES_DEFAULTS = IncidentManager.ALLERGIES + ";true;1";
	private static final String ANTECEDENTS_DEFAULTS = IncidentManager.ANTECEDENTS + ";true;2";
	private static final String CHRONICAL_TREATMENTS_DEFAULTS = IncidentManager.CHRONICAL_TREATMENTS + ";true;3";

	
	public static final String SHOW_ID_IN_HEADER = "SHOW_ID_IN_HEADER";

	private JLabel historyExplanationLabel;
	
	private JPanel importantDataPanel;
    private JButton importantDataEnableButton;
	private JButton importantDataDisableButton;
	private JButton importantDataUpButton;
	private JButton importantDataDownButton;
	private JList importantDataList;
	public ImportantDataPanelConfig[] importantDataConfig = new ImportantDataPanelConfig[4];
    
	private JPanel idPanel;
	private JCheckBox showIDToggle;
	
	public static boolean setDefaultPosition; 
	
	/**
	 * 
	 */
	public PatientModuleSettings() {
		/* ================================================== */
		super(NAME);
		this.setStationaryValues();
		buildPanel();
		/* ================================================== */
	}


	/**
	 * @param p_Name
	 */
	public PatientModuleSettings(String p_Name) {
		/* ================================================== */
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
		/* ================================================== */
	}


	/**
	 * 
	 */
	private void buildPanel() {
		
		
		showIDToggle=new JCheckBox("Show patient ID in header");
		/* ================================================== */
		// init the hashmaps
		/* ------------------------------------------------------- */
		this.nameHash = new HashMap<String, JTextField>();
		this.unitHash = new HashMap<String, JTextField>();
		this.numericHash = new HashMap<String, JCheckBox>();

		this.typeHash = new HashMap<String, JCheckBox>();
		this.measurementTypeHash = new HashMap<String, MeasurementType>();
		/* ------------------------------------------------------- */
		this.cc = new CellConstraints();
		/* ------------------------------------------------------- */
		// load the translation bundle
		/* ------------------------------------------------------- */
		Translatrix.addBundle("lu.tudor.santec.gecamed.patient.gui.resources.Translatrix");
		/* ------------------------------------------------------- */

		/* ------------------------------------------------------- */
		this.measurementPanel = createSubPanel("");
		this.measurementPanel.setOpaque(false);
		this.measurementPanel.setLayout(new BorderLayout());
		/* ------------------------------------------------------- */
		// create the explanation Label
		/* ------------------------------------------------------- */
		this.explanationLabel = new JLabel();
		this.explanationLabel.setIcon(GECAMedModule.getIcon(GECAMedIconNames.INFO));
		this.explanationLabel.setBorder(BorderFactory.createTitledBorder(""));
		this.explanationLabel.setVerticalAlignment(SwingConstants.TOP);
		this.explanationLabel.setVerticalTextPosition(SwingConstants.TOP);
		
		this.explanationLabel.setBackground(Color.WHITE);
		this.explanationLabel.setOpaque(true);
		/* ------------------------------------------------------- */
		measurementPanel.add(this.explanationLabel, BorderLayout.NORTH);

		JPanel bottomPanel = new JPanel(new FormLayout("fill:pref:grow",
				"3dlu,fill:pref," +
				"3dlu,fill:pref," +
				"3dlu,fill:pref," +
				"fill:pref:grow"));
		bottomPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		// create the measurement instances
		/* ------------------------------------------------------- */
		bottomPanel.add(buildSingleMeasurementPanel(IncidentManager.MEAS_1, 1), cc.xy(1, 2));
		bottomPanel.add(buildSingleMeasurementPanel(IncidentManager.MEAS_2, 2), cc.xy(1, 4));
		bottomPanel.add(buildSingleMeasurementPanel(IncidentManager.MEAS_3, 3), cc.xy(1, 6));
		/* ------------------------------------------------------- */
		measurementPanel.add(bottomPanel, BorderLayout.CENTER);
		/* ------------------------------------------------------- */
		setIcon(PatientManagerModule.getIcon(PatientManagerModule.PATIENT));
		/* ------------------------------------------------------- */
//		addSubPanel(measurementPanel);
		/* ================================================== */
		
		// add the insurance edit panel
		int				col	= 0;
		CellConstraints	cc	= new CellConstraints();
		
		
		this.insurancePanel	= createSubPanel("");
		this.insurancePanel.setLayout(new FormLayout(
				"2px,f:p," +
				"5px,f:p," +
				"2px,f:p," +
				"2px,f:p," +
				"2px:g", 
				"2px, f:p, 2px"));
		
		this.insurances			= new JComboBox();
		this.insurances.setRenderer(new InsurancesRenderer());
		reloadInsurances();
		
		this.editInsurance 		= ButtonFactory.createNarrowButton(IconFetcher.getSmallIcon(GECAMedModule.class, GECAMedIconNames.EDIT));
		this.editInsurance.setToolTipText(Translatrix.getTranslationString("pm.edit"));
		this.editInsurance.setContentAreaFilled(false);
		this.editInsurance.addActionListener(this);
		
		this.addInsurance 		= ButtonFactory.createNarrowButton(IconFetcher.getSmallIcon(GECAMedModule.class, GECAMedIconNames.ADD));
		this.addInsurance.setToolTipText(Translatrix.getTranslationString("pm.add"));
		this.addInsurance.setContentAreaFilled(false);
		this.addInsurance.addActionListener(this);
		
		this.reloadInsurances	= ButtonFactory.createNarrowButton(IconFetcher.getSmallIcon(GECAMedModule.class, GECAMedIconNames.RELOAD));
		this.reloadInsurances.setToolTipText(Translatrix.getTranslationString("pm.reload"));
		this.reloadInsurances.setContentAreaFilled(false);
		this.reloadInsurances.addActionListener(this);
		
		insurancePanel.add(insurances,		cc.xy(col+=2, 2));
		insurancePanel.add(editInsurance,	cc.xy(col+=2, 2));
		insurancePanel.add(addInsurance,	cc.xy(col+=2, 2));
		insurancePanel.add(reloadInsurances,cc.xy(col+=2, 2));
		
		addSubPanel(insurancePanel);

		// add Consultation config Panel
		FormLayout layout = new FormLayout("fill:160dlu:grow, 1dlu, fill:50dlu:grow, 1dlu",
				"pref, 5dlu, pref, pref, pref, pref, pref,pref,20dlu, pref, pref, 2dlu");

		
        cc = new CellConstraints();

        consultationPanel = createSubPanel(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.title"));
        consultationPanel.setLayout(layout);

        
        PanelBuilder l_Builder     = new PanelBuilder(layout,consultationPanel);

        
        // init the components:
        
        JLabel m_CommentLabel = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.description"));
        JLabel m_ModulesLabel = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.availablePanels"));

        consultationEntryList = new JList();
        consultationEntryList.setCellRenderer(new ConsultationEntryListRenderer());
//        setDefaultConsultationEntryPanels();
//        ArrayList<ConsultationEntryConfig> data = new ArrayList<ConsultationEntryConfig>();
//        data.toArray();
        consultationEntryList.setListData(consultationEntries);
//        m_ModulesList.addListSelectionListener(this);
        consultationEntryList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        consultationEntryList.addMouseListener(new MouseListener() {
			
			public void mouseReleased(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			 public void mousePressed(MouseEvent me) {
				 ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getSelectedValue();
				 if (me.getClickCount() == 2) {
		        	// if element not new column
					if(!cec.getId().equals(NEW_COLUMN))
					{
			        	if(cec.getId().equals(IncidentManager.MEASUREMENT))
			        	{
			        		consultationConfigDialog = new ConsultationConfigDialog(measurementPanel);
			        	}else if(cec.getId().equals(IncidentManager.SICK_LEAVE)){
			        		consultationConfigDialog = new ConsultationConfigDialog(false,true);
			        	}else{
			        		consultationConfigDialog = new ConsultationConfigDialog(true,true);
			        	}
			        	
			        	ConsultationEntryConfig cecEdit = consultationConfigDialog.showDialog(cec);
			        	
			        	
			        	consultationEntries[cecEdit.getPosition()] = cecEdit;
			        	consultationEntryList.setListData(consultationEntries);
					}
	            }
			 }
			
			public void mouseExited(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void mouseEntered(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void mouseClicked(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
		});

        enableButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.enable"));
        enableButton.addActionListener(this);
        disableButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.disable"));
        disableButton.addActionListener(this);
        editButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.editButton"));
        editButton.addActionListener(this);
        upButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.UP));
        upButton.addActionListener(this);
        downButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.DOWN));
        downButton.addActionListener(this);
        
        

        l_Builder.add(m_CommentLabel,cc.xyw(1,1,3));
        l_Builder.add(m_ModulesLabel,cc.xyw(1,3,1));
        l_Builder.add(new JScrollPane(consultationEntryList),cc.xywh(1,4,1,8));
        l_Builder.add(enableButton,cc.xyw(3,4,1));
        l_Builder.add(disableButton,cc.xyw(3,5,1));
        l_Builder.add(editButton, cc.xyw(3,6,1));

        l_Builder.add(upButton,cc.xyw(3,8,1));
        l_Builder.add(downButton,cc.xyw(3,9,1));

        addSubPanel(consultationPanel);
		
        historytabsList=new JList();
    
        historytabsList.setCellRenderer(new HistoryTabEntryListRenderer());
        
//        setDefaultConsultationEntryPanels();
//        ArrayList<ConsultationEntryConfig> data = new ArrayList<ConsultationEntryConfig>();
//        data.toArray();
        historytabsList.setListData(historytabEntries);
//        m_ModulesList.addListSelectionListener(this);
        historytabsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
   	 
        historytabsList.addMouseListener(new MouseListener() {
			
			public void mouseReleased(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			 public void mousePressed(MouseEvent me) {
	             /*   JTable table =(JTable) me.getSource();
	                Point p = me.getPoint();
	                int row = table.rowAtPoint(p);*/
	                if (me.getClickCount() == 2) {
	                    // your valueChanged overridden method 
	                	 int currentLocation =  historytabsList.getSelectedIndex();
	                     if(currentLocation != -1)
	                     {
	                    	 HistoryTabEntryConfig htc = (HistoryTabEntryConfig)historytabsList.getModel().getElementAt(currentLocation);
	                    	
	                    	 historyTabConfigDialog = new HistoryTabConfigDialog();
	                    	 HistoryTabEntryConfig htc2 = historyTabConfigDialog.showDialog(htc);
	                    	 
	                    	 if(htc2!=null)
	                    	 {
	                    	 historytabEntries.setElementAt(htc2, htc2.getPosition());
	                    
	        	            	historytabsList.setListData(historytabEntries);
	                     	 historytabsList.repaint();
	                    	 }
	          	        	
	                     }
	                }
	            }
			
			public void mouseExited(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void mouseEntered(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void mouseClicked(MouseEvent paramMouseEvent) {
				// TODO Auto-generated method stub
				
			}
		});
        layout = new FormLayout("fill:160dlu:grow, 1dlu, fill:50dlu:grow, 1dlu",
				"pref,pref, pref, pref, pref, pref, pref, pref,pref, pref, pref, 2dlu");
        
        historytabsPanel = createSubPanel(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.historyFilterTitle"));
        historytabsPanel.setLayout(layout);
        
        PanelBuilder l_tabBuilder     = new PanelBuilder(layout,historytabsPanel);

        String HistoryTabsList[]={Translatrix.getTranslationString("patient.history.full"),
        		Translatrix.getTranslationString("patient.history.diagnosis"),
        		Translatrix.getTranslationString("patient.history.letters"),
        		Translatrix.getTranslationString("patient.history.files"),
        		Translatrix.getTranslationString("patient.history.prescriptions"),
        		Translatrix.getTranslationString("patient.history.forms"),
        		Translatrix.getTranslationString("patient.history.cda")
        };
        
  //      historytabsList = new JList();
        
     //   tabsList.setCellRenderer(new ConsultationEntryListRenderer());
        
//        setDefaultConsultationEntryPanels();
//        ArrayList<ConsultationEntryConfig> data = new ArrayList<ConsultationEntryConfig>();
//        data.toArray();
      //  tabsList.setListData(consultationEntries);
//        m_ModulesList.addListSelectionListener(this);
       // tabsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        
        enabletabButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.enable"));
        enabletabButton.addActionListener(this);
        disabletabButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.disable"));
        disabletabButton.addActionListener(this);
        edittabButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.editButton"));
        edittabButton.addActionListener(this);
        
        uptabButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.UP));
        uptabButton.addActionListener(this);
        downtabButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.DOWN));
        downtabButton.addActionListener(this);
        addButton=new JButton(GECAMedModule.getSmallIcon(GECAMedModule.ADD));
        addButton.addActionListener(this);
        deleteButton=new JButton(GECAMedModule.getSmallIcon(GECAMedModule.REMOVE));
        deleteButton.addActionListener(this);

        JLabel m_HistoryCommentLabel = new JLabel(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.historyDescription"));
        
        l_tabBuilder.add(m_HistoryCommentLabel,cc.xyw(1,1,3));
        l_tabBuilder.add(new JScrollPane(historytabsList),cc.xywh(1,2,1,8));
        l_tabBuilder.add(enabletabButton,cc.xyw(3,2,1));
        l_tabBuilder.add(disabletabButton,cc.xyw(3,3,1));
        l_tabBuilder.add(edittabButton, cc.xyw(3,4,1));

        l_tabBuilder.add(addButton, cc.xyw(3,5,1));
        l_tabBuilder.add(deleteButton, cc.xyw(3,6,1));
        
        l_tabBuilder.add(uptabButton,cc.xyw(3,7,1));
        l_tabBuilder.add(downtabButton,cc.xyw(3,8,1));
       
        

        
        
        
        addSubPanel(historytabsPanel);
        
        
        
        // importantDataPanel
        layout = new FormLayout("fill:160dlu:grow, 1dlu, fill:50dlu:grow, 1dlu",
        		"pref, 5dlu, pref, pref, pref, 5dlu, pref, pref, 2dlu");

        cc = new CellConstraints();

        importantDataPanel = createSubPanel(Translatrix.getTranslationString("patient.settings.importantDataPanel.title"));
        importantDataPanel.setLayout(layout);

        l_Builder = new PanelBuilder(layout, importantDataPanel);
        
        m_CommentLabel = new JLabel(Translatrix.getTranslationString("patient.settings.importantDataPanel.description"));
        m_ModulesLabel = new JLabel(Translatrix.getTranslationString("patient.settings.importantDataPanel.availablePanels"));

        importantDataList = new JList();
        importantDataList.setCellRenderer(new ImportantDataListRenderer());
//        setDefaultConsultationEntryPanels();
//        ArrayList<ConsultationEntryConfig> data = new ArrayList<ConsultationEntryConfig>();
//        data.toArray();
        importantDataList.setListData(importantDataConfig);
        
//        m_ModulesList.addListSelectionListener(this);
        importantDataList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        

        importantDataEnableButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.enable"));
        importantDataEnableButton.addActionListener(this);
        importantDataDisableButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.disable"));
        importantDataDisableButton.addActionListener(this);
//        editButton = new JButton(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.editButton"));
//        editButton.addActionListener(this);
        importantDataUpButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.UP));
        importantDataUpButton.addActionListener(this);
        importantDataDownButton = new JButton(GECAMedModule.getSmallIcon(GECAMedModule.DOWN));
        importantDataDownButton.addActionListener(this);

        l_Builder.add(m_CommentLabel,cc.xyw(1,1,3));
        l_Builder.add(m_ModulesLabel,cc.xyw(1,3,1));
        l_Builder.add(new JScrollPane(importantDataList),cc.xywh(1,4,1,5));
        l_Builder.add(importantDataEnableButton,cc.xyw(3,4,1));
        l_Builder.add(importantDataDisableButton,cc.xyw(3,5,1));
//        l_Builder.add(editButton, cc.xyw(3,6,1));
        l_Builder.add(importantDataUpButton,cc.xyw(3,7,1));
        l_Builder.add(importantDataDownButton,cc.xyw(3,8,1));

        addSubPanel(importantDataPanel);
        
        
       
       FormLayout idlayout = new FormLayout("fill:160dlu:grow",
       		"pref");

       cc = new CellConstraints();

       idPanel = createSubPanel("Other");
       idPanel.setLayout(idlayout);

       idPanel.add(showIDToggle,cc.xy(1,1));
       
     //  l_Builder = new PanelBuilder(layout, importantDataPanel);
       addSubPanel(idPanel);
		relocalize();
		
		reflectSettings();
		
//		consultationEntryList.setSelectedIndex(0);
//		importantDataList.setSelectedIndex(0);
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		/* ================================================== */
		super.relocalize();
		
		setLabel(Translatrix.getTranslationString("patient.settings"));
		measurementPanel.setBorder(BorderFactory.createTitledBorder(Translatrix.getTranslationString("patient.settings.measurementName")));
		insurancePanel.setBorder(BorderFactory.createTitledBorder(Translatrix.getTranslationString("patient.settings.insuranceName")));
//		if(test){
		consultationPanel.setBorder(BorderFactory.createTitledBorder(Translatrix.getTranslationString("patient.settings.consultationConfigPanel.title")));
//		}
		
		
//		}
		explanationLabel.setText(Translatrix.getTranslationString("patient.settings.explanation"));
		explanationLabel.updateUI();
		/* ================================================== */
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#revertToDefaults()
	 */
	public void revertToDefaults() {
		/* ================================================== */
		if (typeHash.keySet() != null) {
			for (String key : typeHash.keySet()) {
				typeHash.get(key).setSelected((Boolean) getDefault(key));
			}	
		}
		reflectSettings();
		super.revertToDefaults();
		/* ================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
		/* ================================================== */
		if (typeHash.keySet() != null) {
			for (String key : typeHash.keySet()) {
				/* ------------------------------------------------------- */
				setValue(key, (Boolean) typeHash.get(key).isSelected());
				/* ------------------------------------------------------- */
			}
			saveMeasurementFields();	
		}
		// set position of the consultationEntries 
    	for (int i = 0; i < consultationEntries.length; i++) {
    		ConsultationEntryConfig cec = consultationEntries[i];
    		if(cec.getId().equals(IncidentManager.SOAP_S)) 
    			setValue(IncidentManager.SOAP_S, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.SOAP_O)) 
    			setValue(IncidentManager.SOAP_O, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.SOAP_A)) 
    			setValue(IncidentManager.SOAP_A, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.SOAP_P)) 
    			setValue(IncidentManager.SOAP_P, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.CONS_1)) 
    			setValue(IncidentManager.CONS_1, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.CONS_2)) 
    			setValue(IncidentManager.CONS_2, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.CONS_3)) 
    			setValue(IncidentManager.CONS_3, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.MEASUREMENT)) 
    			setValue(IncidentManager.MEASUREMENT, cec.createSaveValue());
    		else if(cec.getId().equals(IncidentManager.SICK_LEAVE)) 
    			setValue(IncidentManager.SICK_LEAVE, cec.createSaveValue());
    		else if(cec.getId().equals(NEW_COLUMN)) 
    			setValue(NEW_COLUMN, cec.createSaveValue());
		}
    	// set the important data field
    	for (int i = 0; i < importantDataConfig.length; i++)
    	{
    		ImportantDataPanelConfig idc = importantDataConfig[i]; 
    		if(idc.getId().equals(IncidentManager.ACTIVE_PROBLEMS))
    			setValue(IncidentManager.ACTIVE_PROBLEMS, idc.createSaveValue());
    		else if(idc.getId().equals(IncidentManager.ALLERGIES))
    			setValue(IncidentManager.ALLERGIES, idc.createSaveValue());
    		else if(idc.getId().equals(IncidentManager.ANTECEDENTS))
    			setValue(IncidentManager.ANTECEDENTS, idc.createSaveValue());
    		else if(idc.getId().equals(IncidentManager.CHRONICAL_TREATMENTS))
    			setValue(IncidentManager.CHRONICAL_TREATMENTS, idc.createSaveValue());
		}

    	// set the important data field
    	StringBuffer sb = new StringBuffer();
    	for (HistoryTabEntryConfig itc : historytabEntries) {
			sb.append(itc.getSettings()).append("\n");
		}
    	setValue(IncidentManager.HISTORY_TABS, sb.toString());
    	
    //	System.out.println("------- : "+IncidentManager.HISTORY_TABS);
    	
//    	for (int i = 0; i < historytabEntries.size(); i++)
//    	{
//    		HistoryTabEntryConfig itc = historytabEntries.elementAt(i); 
//    		if(itc.getId().equals(IncidentManager.FULL_VIEW))
//    			setValue(IncidentManager.FULL_VIEW, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.DIAG))
//    			setValue(IncidentManager.DIAG, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.LETTERS))
//    			setValue(IncidentManager.LETTERS, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.FILES))
//    			setValue(IncidentManager.FILES, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.PRESCR))
//    			setValue(IncidentManager.PRESCR, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.FORMS))
//    			setValue(IncidentManager.FORMS, itc.createSaveValue());
//    		else if(itc.getId().equals(IncidentManager.CDA))
//    			setValue(IncidentManager.CDA, itc.createSaveValue());
//		}
    	
    	setValue(SHOW_ID_IN_HEADER, this.showIDToggle.isSelected());
    	
        super.updateSettings();
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		/* ================================================== */
		super.reflectSettings();

		if (typeHash.keySet() != null) {
			/* ------------------------------------------------------- */
			// load the data from the jboss
			for (String key : typeHash.keySet()) {
				/* ------------------------------------------------------- */
				// selected state for all checkboxes
				typeHash.get(key).setSelected(false);
				// trigger action performed to add the fields to the hashmaps
				typeHash.get(key).getActionListeners()[0].actionPerformed(null);
				/* ------------------------------------------------------- */
				// load data
				MeasurementType t = IncidentTab.getManager().getMeasurementType(key);
				if (t != null) {
					/* ------------------------------------------------------- */
					this.measurementTypeHash.put(key, t);
					nameHash.get(key).setText(t.getAlias());
					unitHash.get(key).setText(t.getUnit());
					numericHash.get(key).setSelected(t.isNumericType());
					/* ------------------------------------------------------- */
				}
				/* ------------------------------------------------------- */
			}

			for (String key : typeHash.keySet()) {
				/* ------------------------------------------------------- */
				typeHash.get(key).setSelected((getValue(key) != null) ? (Boolean) getValue(key) : false);
				// notify the actionlistener
				// two times to keep the loaded state
				typeHash.get(key).getActionListeners()[0].actionPerformed(null);
				typeHash.get(key).getActionListeners()[0].actionPerformed(null);
			}
		}
		// set values or default values of consultation entries
		setDefaultPosition = false;
		soapS = new ConsultationEntryConfig((String) getValue(IncidentManager.SOAP_S));
		if(soapS.getId() == null)
		{
			soapS = new ConsultationEntryConfig(SOAPS_DEFAULTS);
			setDefaultPosition = true;
		}
		
		soapO = new ConsultationEntryConfig((String) getValue(IncidentManager.SOAP_O));
		if(soapO.getId() == null)
		{
			soapO = new ConsultationEntryConfig(SOAPO_DEFAULTS);
			setDefaultPosition = true;
		}
		
		soapA = new ConsultationEntryConfig((String) getValue(IncidentManager.SOAP_A));
		if(soapA.getId() == null)
		{
			soapA = new ConsultationEntryConfig(SOAPA_DEFAULTS);
			setDefaultPosition = true;
		}
		
		soapP = new ConsultationEntryConfig((String) getValue(IncidentManager.SOAP_P));
		if(soapP.getId() == null)
		{
			soapP = new ConsultationEntryConfig(SOAPP_DEFAULTS);
			setDefaultPosition = true;
		}
		
		cons1 = new ConsultationEntryConfig((String) getValue(IncidentManager.CONS_1));
		if(cons1.getId() == null)
		{
			cons1 = new ConsultationEntryConfig(CONS1_DEFAULTS);
			setDefaultPosition = true;
		}
		
		cons2 = new ConsultationEntryConfig((String) getValue(IncidentManager.CONS_2));
		if(cons2.getId() == null)
		{
			cons2 = new ConsultationEntryConfig(CONS2_DEFAULTS);
			setDefaultPosition = true;
		}
		
		cons3 = new ConsultationEntryConfig((String) getValue(IncidentManager.CONS_3));
		if(cons3.getId() == null)
		{
			cons3 = new ConsultationEntryConfig(CONS3_DEFAULTS);
			setDefaultPosition = true;
		}
		
		measurement = new ConsultationEntryConfig((String) getValue(IncidentManager.MEASUREMENT));
		if(measurement.getId() == null)
		{
			measurement = new ConsultationEntryConfig(MEASUREMENT_DEFAULTS);
			setDefaultPosition = true;
		}
		
		sickLeave = new ConsultationEntryConfig((String) getValue(IncidentManager.SICK_LEAVE));
		if(sickLeave.getId() == null)
		{
			sickLeave = new ConsultationEntryConfig(SICKLEAVE_DEFAULTS);
			setDefaultPosition = true;
		}
		
		newColumn = new ConsultationEntryConfig((String) getValue(NEW_COLUMN));
		if(newColumn.getId() == null)
		{
			newColumn = new ConsultationEntryConfig(NEW_COLUMN_DEFAULTS);
			setDefaultPosition = true;
		}
		
		if(setDefaultPosition)
		{
			soapS.setPosition(0);
			soapO.setPosition(1);
			soapA.setPosition(3);
			soapP.setPosition(4);
			cons1.setPosition(5);
			cons2.setPosition(6);
			cons3.setPosition(7);
			measurement.setPosition(2);
			sickLeave.setPosition(8);
			newColumn.setPosition(9);
		}
		
		GECAMedUtils.insertIntoArray(consultationEntries, soapS,		soapS.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, soapO,		soapO.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, soapA,		soapA.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, soapP,		soapP.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, cons1,		cons1.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, cons2,		cons2.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, cons3,		cons3.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, measurement,	measurement.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, sickLeave,	sickLeave.getPosition());
		GECAMedUtils.insertIntoArray(consultationEntries, newColumn,	newColumn.getPosition());
		
		consultationEntryList.setListData(consultationEntries);
		consultationEntryList.repaint();
		
		// set values or default values of ImportantDataPanels
		activeProblems = new ImportantDataPanelConfig((String) getValue(IncidentManager.ACTIVE_PROBLEMS));
		if(activeProblems.getId() == null)
			activeProblems = new ImportantDataPanelConfig(IncidentManager.ACTIVE_PROBLEMS, true, 0);
		
		allergies = new ImportantDataPanelConfig((String) getValue(IncidentManager.ALLERGIES));
		if(allergies.getId() == null)
			allergies = new ImportantDataPanelConfig(IncidentManager.ALLERGIES, true, 1);
		
		antecedents = new ImportantDataPanelConfig((String) getValue(IncidentManager.ANTECEDENTS));
		if(antecedents.getId() == null)
			antecedents = new ImportantDataPanelConfig(IncidentManager.ANTECEDENTS, true, 2);
		
		chronicalTreatments = new ImportantDataPanelConfig((String) getValue(IncidentManager.CHRONICAL_TREATMENTS));
		if(chronicalTreatments.getId() == null)
			chronicalTreatments = new ImportantDataPanelConfig(IncidentManager.CHRONICAL_TREATMENTS, true, 3);
		
		importantDataConfig[activeProblems.getPosition()] = activeProblems;
		importantDataConfig[allergies.getPosition()] = allergies;
		importantDataConfig[antecedents.getPosition()] = antecedents;
		importantDataConfig[chronicalTreatments.getPosition()] = chronicalTreatments;
		
		importantDataList.setListData(importantDataConfig);
		importantDataList.repaint();
		
		
		
		
		// set values or default values of HistoryTabsPanels
    	// set the important data field
		String val = (String) getValue(IncidentManager.HISTORY_TABS);
		if(val!=null)
		{
		String[] values = val.split("\n");
		
		for (int i = 0; i < values.length; i++) {
			HistoryTabEntryConfig entry = new HistoryTabEntryConfig(values[i]);
			//entry.setSettings(values[i]);
			boolean present=false;
			for(HistoryTabEntryConfig itec : historytabEntries)
			{
				if(itec.getId().equals(entry.getId()) && itec.getFilters().equals(entry.getFilters()))
				{
					present=true;
					break;
				}
			}
			if(!present)
			{
				if(entry.getId()!=null)
					historytabEntries.add(entry);
			}
			
		}
		
		}
		
//				fullview = new HistoryTabEntryConfig((String) getValue(IncidentManager.FULL_VIEW));
//				if(fullview.getId() == null)
//					fullview = new HistoryTabEntryConfig(IncidentManager.FULL_VIEW, true, 0);
//				
//				diagnosis = new HistoryTabEntryConfig((String) getValue(IncidentManager.DIAG));
//				if(diagnosis.getId() == null)
//					diagnosis = new HistoryTabEntryConfig(IncidentManager.DIAG, true, 1);
//				
//				letters = new HistoryTabEntryConfig((String) getValue(IncidentManager.LETTERS));
//				if(letters.getId() == null)
//					letters = new HistoryTabEntryConfig(IncidentManager.LETTERS, true, 2);
//				
//				files = new HistoryTabEntryConfig((String) getValue(IncidentManager.FILES));
//				if(files.getId() == null)
//					files = new HistoryTabEntryConfig(IncidentManager.FILES, true, 3);
//				
//				prescriptions = new HistoryTabEntryConfig((String) getValue(IncidentManager.PRESCR));
//				if(prescriptions.getId() == null)
//					prescriptions = new HistoryTabEntryConfig(IncidentManager.PRESCR, true, 4);
//				
//				forms = new HistoryTabEntryConfig((String) getValue(IncidentManager.FORMS));
//				if(forms.getId() == null)
//					forms = new HistoryTabEntryConfig(IncidentManager.FORMS, true, 5);
//				
//				cda = new HistoryTabEntryConfig((String) getValue(IncidentManager.CDA));
//				if(cda.getId() == null)
//					cda = new HistoryTabEntryConfig(IncidentManager.CDA, true, 6);
//				
//				historytabEntries[fullview.getPosition()]=fullview;
//				historytabEntries[diagnosis.getPosition()]=diagnosis;
//				historytabEntries[letters.getPosition()]=letters;
//				historytabEntries[files.getPosition()]=files;
//				historytabEntries[prescriptions.getPosition()]=prescriptions;
//				historytabEntries[forms.getPosition()]=forms;
//				historytabEntries[cda.getPosition()]=cda;
				
		
	
        
				historytabsList.setListData(historytabEntries);
				historytabsList.repaint();
		
		/* ================================================== */
		
		//Header id
		try {
			this.showIDToggle.setSelected(((Boolean) this.getValue(SHOW_ID_IN_HEADER)));			
		} catch (Exception e) {
			this.showIDToggle.setSelected(false);
		}
	}


	/**
	 * Set default values
	 */
	public void setStationaryValues() {
		/* ================================================== */
		// default settings, all fields are disabled
		setStationary(IncidentManager.MEAS_1, false);
		setStationary(IncidentManager.MEAS_2, false);
		setStationary(IncidentManager.MEAS_3, false);
		setStationary(IncidentManager.SOAP_S, SOAPS_DEFAULTS);
		setStationary(IncidentManager.SOAP_O, SOAPO_DEFAULTS);
		setStationary(IncidentManager.SOAP_A, SOAPA_DEFAULTS);
		setStationary(IncidentManager.SOAP_P, SOAPP_DEFAULTS);
		setStationary(IncidentManager.CONS_1, CONS1_DEFAULTS);
		setStationary(IncidentManager.CONS_2, CONS2_DEFAULTS);
		setStationary(IncidentManager.CONS_3, CONS3_DEFAULTS);
		setStationary(IncidentManager.MEASUREMENT, MEASUREMENT_DEFAULTS);
		setStationary(IncidentManager.SICK_LEAVE, SICKLEAVE_DEFAULTS);
		setStationary(NEW_COLUMN, NEW_COLUMN_DEFAULTS);
		setStationary(IncidentManager.ACTIVE_PROBLEMS, ACTIVE_PROBLEMS_DEFAULTS);		
		setStationary(IncidentManager.ALLERGIES, ALLERGIES_DEFAULTS);
		setStationary(IncidentManager.ANTECEDENTS, ANTECEDENTS_DEFAULTS);
		setStationary(IncidentManager.CHRONICAL_TREATMENTS, CHRONICAL_TREATMENTS_DEFAULTS);
		
//		setStationary(IncidentManager.FULL_VIEW, FULLVIEW_DEFAULTS);
//		setStationary(IncidentManager.DIAG, DIAG_DEFAULTS);
//		setStationary(IncidentManager.LETTERS, LETTERS_DEFAULTS);
//		setStationary(IncidentManager.FILES, FILES_DEFAULTS);
//		setStationary(IncidentManager.PRESCR, PRESCR_DEFAULTS);
//		setStationary(IncidentManager.FORMS, FORMS_DEFAULTS);
//		setStationary(IncidentManager.CDA, CDA_DEFAULTS);

		setStationary(IncidentManager.HISTORY_TABS,HISTORY_DEFAULTS );
		
		setStationary(SHOW_ID_IN_HEADER, false);
		/* ================================================== */
		
		
		
//		
//		String val = (String) getValue(IncidentManager.HISTORY_TABS);
//		if(val!=null)
//		{
//			String[] values = val.split("\n");
//			HistoryTabEntryConfig entry = new HistoryTabEntryConfig(values[0]);
//			if(entry.getId() == null)
//			{
//				
//			
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FULL_VIEW, true, 0));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.DIAG, true, 1));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.LETTERS, true, 2));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FILES, true, 3));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.PRESCR, true, 4));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FORMS, true, 5));
//					historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.CDA, true, 6));
//				
//				
				
	//			historytabEntries.add(entry);
		//	}
		
	//	}
		
		
		
		// set values or default values of HistoryTabsPanels
//		fullview = new HistoryTabEntryConfig((String) getValue(IncidentManager.FULL_VIEW));
//		if(fullview.getId() == null)
//			fullview = new HistoryTabEntryConfig(IncidentManager.FULL_VIEW, true, 0);
		
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FULL_VIEW, true, 0));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.DIAG, true, 1));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.LETTERS, true, 2));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FILES, true, 3));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.PRESCR, true, 4));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.FORMS, true, 5));
//		historytabEntries.add(new HistoryTabEntryConfig(IncidentManager.CDA, true, 6));
//	
//		
//		diagnosis = new HistoryTabEntryConfig((String) getValue(IncidentManager.DIAG));
//		if(diagnosis.getId() == null)
//			diagnosis = new HistoryTabEntryConfig(IncidentManager.DIAG, true, 1);
//		
//		letters = new HistoryTabEntryConfig((String) getValue(IncidentManager.LETTERS));
//		if(letters.getId() == null)
//			letters = new HistoryTabEntryConfig(IncidentManager.LETTERS, true, 2);
//		
//		files = new HistoryTabEntryConfig((String) getValue(IncidentManager.FILES));
//		if(files.getId() == null)
//			files = new HistoryTabEntryConfig(IncidentManager.FILES, true, 3);
//		
//		prescriptions = new HistoryTabEntryConfig((String) getValue(IncidentManager.PRESCR));
//		if(prescriptions.getId() == null)
//			prescriptions = new HistoryTabEntryConfig(IncidentManager.PRESCR, true, 4);
//		
//		forms = new HistoryTabEntryConfig((String) getValue(IncidentManager.FORMS));
//		if(forms.getId() == null)
//			forms = new HistoryTabEntryConfig(IncidentManager.FORMS, true, 5);
//		
//		cda = new HistoryTabEntryConfig((String) getValue(IncidentManager.CDA));
//		if(cda.getId() == null)
//			cda = new HistoryTabEntryConfig(IncidentManager.CDA, true, 6);
//		
//		historytabEntries[fullview.getPosition()]=fullview;
//		historytabEntries[diagnosis.getPosition()]=diagnosis;
//		historytabEntries[letters.getPosition()]=letters;
//		historytabEntries[files.getPosition()]=files;
//		historytabEntries[prescriptions.getPosition()]=prescriptions;
//		historytabEntries[forms.getPosition()]=forms;
//		historytabEntries[cda.getPosition()]=cda;
		
		
		
	}


	/**
	 * @param key
	 * @return
	 */
	public MeasurementType getType(String key) {
		/* ================================================== */
		return measurementTypeHash.get(key);
		/* ================================================== */
	}

	/**
	 * Save the input fields in the database
	 */
	private void saveMeasurementFields() {
		/* ================================================== */
		if (typeHash.keySet() != null) {
			/* ------------------------------------------------------- */
			for (String key : typeHash.keySet()) {
				/* ------------------------------------------------------- */
				// save each setting
				MeasurementType t = new MeasurementType();
				try {
					t.setName(key);
					t.setAlias(nameHash.get(key).getText());
					t.setUnit(unitHash.get(key).getText());
					t.setNumericType(numericHash.get(key).isSelected());

					IncidentTab.getManager().saveMeasurementType(t);
				} catch (Exception e) {
					// do nothing when we are here.
					// the exception is thrown when a component block
					// is not selected.
				}
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}


	/**
	 * @param key
	 * @param count
	 * @return
	 */
	private JPanel buildSingleMeasurementPanel(final String key, int count) {
		/* ================================================== */

		final JCheckBox chkbx1 = new JCheckBox(
				Translatrix.getTranslationString("patient.settings.measurementName")+" "+count);
		chkbx1.setOpaque(true);
		chkbx1.setBackground(GECAMedColors.c_GECAMedBackground);
		this.typeHash.put(key, chkbx1);
		/* ------------------------------------------------------- */
		JPanel internPanel = new JPanel(new FormLayout(
											// cols
											"3dlu," +
											"fill:pref," +
											"5dlu," +
											"fill:pref," +
											"fill:pref:grow",
											// rows
											"0dlu," +
											"fill:pref," +
											"0dlu," +
											"fill:pref," +
											"2dlu"));
		internPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		final JTextField nameField = new JTextField(3);
		final JTextField unitField = new JTextField(4);
		final JCheckBox  numericBox = new JCheckBox(Translatrix.getTranslationString("patient.settings.isnumeric"));
		numericBox.setOpaque(false);
		/* ------------------------------------------------------- */

		/* ------------------------------------------------------- */
		final NamedComponent nc1 = new NamedComponent(Translatrix.getTranslationString("core.name"),
				nameField);
//		nc1.setEnabled(false);
		/* ------------------------------------------------------- */
		final NamedComponent nc2 = new NamedComponent(
				Translatrix.getTranslationString("patient.core.unit"),
				unitField);
//		nc2.setEnabled(false);
		/* ------------------------------------------------------- */
		final NamedComponent nc3 = new NamedComponent(
				"",
				numericBox);
		/* ------------------------------------------------------- */
//		nc3.setEnabled(false);
		/* ------------------------------------------------------- */
		internPanel.add(nc1, cc.xy(2, 2));
		internPanel.add(nc2, cc.xy(2, 4));
		internPanel.add(nc3, cc.xy(4, 2));

		ComponentTitledPanel tp = new ComponentTitledPanel(chkbx1, internPanel);

		nameHash.put(key, nameField);
		unitHash.put(key, unitField);
		numericHash.put(key, numericBox);

		chkbx1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
					nc1.setEnabled(chkbx1.isSelected());
					nc2.setEnabled(chkbx1.isSelected());
					nc3.setEnabled(chkbx1.isSelected());
//				if (chkbx1.isSelected()) {
//					/* ------------------------------------------------------- */
//
//					/* ------------------------------------------------------- */
//				} else {
//					nameHash.remove(key);
//					unitHash.remove(key);
//					numericHash.remove(key);
//				}
				/* ====================================================== */
			}

		});

		return tp;
		/* ================================================== */
	}
	
	
	private void reloadInsurances ()
	{
		InsuranceInterface	manager;
		Vector<Insurance>	data	= new Vector<Insurance>();
		Insurance			selected= (Insurance) insurances.getSelectedItem();
		
		
		try
		{
			manager	= (InsuranceInterface) ManagerFactory.getRemote(InsuranceBean.class);
			data.addAll(manager.getAllInsurances());
			data.addAll(manager.getDisbandedInsurances());
			insurances.setModel(new DefaultComboBoxModel(data));
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		
		if (selected != null)
			insurances.setSelectedItem(selected);
	}


	public void actionPerformed(ActionEvent event)
	{
		Object 		source	= event.getSource();
		Insurance	insurance;
		
		if (source == reloadInsurances)
		{
			reloadInsurances();
		}
		else
		{
			if (insuranceDialog == null)
				insuranceDialog	= new EditInsuranceDialog();
			
			if (source == editInsurance)
			{
				insurance	= (Insurance) insurances.getSelectedItem();
				
				if (insurance == null)
					return;
				
				insuranceDialog.show(insurance);
			}
			else if (source == addInsurance)
			{
				insurance = insuranceDialog.show(null);
				if (insuranceDialog.getButtonOption() == GECAMedBaseDialogImpl.OK_OPTION)
				{
					insurances.addItem(insurance);
					reloadInsurances();
				}
			}
			
			if (insuranceDialog.getButtonOption() == GECAMedBaseDialogImpl.OK_OPTION)
				reloadInsurances();
		}
		// actions of consultation config panel
		if (event.getSource() == enableButton) {
            // get selected element
			ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getSelectedValue();
			
			// if element not new column
			if(!cec.getId().equals(NEW_COLUMN))
			{
	            // change the value to "true":
	            cec.setEnabled(true);
	
	            int currentLocation = consultationEntryList.getSelectedIndex();
	            consultationEntryList.setSelectedIndex((currentLocation));
	
	            consultationEntryList.repaint();
			}
        }

        if (event.getSource() == disableButton) {
            // get selected element
        	ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getSelectedValue();
        	
        	// if element not new column
			if(!cec.getId().equals(NEW_COLUMN))
			{
	            // change the value to "true":
	        	cec.setEnabled(false);
	
	            int currentLocation = consultationEntryList.getSelectedIndex();
	            consultationEntryList.setSelectedIndex((currentLocation));
	
	            consultationEntryList.repaint();
			}
        }

        if(event.getSource() == editButton)
        {
        	  
        	
        	ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getSelectedValue();

        	// if element not new column
			if(!cec.getId().equals(NEW_COLUMN))
			{
	        	if(cec.getId().equals(IncidentManager.MEASUREMENT))
	        	{
	        		consultationConfigDialog = new ConsultationConfigDialog(this.measurementPanel);
	        	}else if(cec.getId().equals(IncidentManager.SICK_LEAVE)){
	        		consultationConfigDialog = new ConsultationConfigDialog(false,true);
	        	}else{
	        		consultationConfigDialog = new ConsultationConfigDialog(true,true);
	        	}
	        	
	        	ConsultationEntryConfig cecEdit = consultationConfigDialog.showDialog(cec);
	        	
	        	
	        	consultationEntries[cecEdit.getPosition()] = cecEdit;
	        	consultationEntryList.setListData(consultationEntries);
			}
        }
        
        if (event.getSource() == upButton) {

            int currentLocation = consultationEntryList.getSelectedIndex();
            if(currentLocation != -1)
            {
	            ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getModel().getElementAt(currentLocation);
	            
	            if(cec.getPosition()-1 >= 0)
	            {
	            	ConsultationEntryConfig cecSave = consultationEntries[cec.getPosition()-1];
	            	cecSave.setPosition(cec.getPosition());
	            	consultationEntries[cec.getPosition()] = cecSave;
	            	cec.setPosition(cec.getPosition()-1);
	            	consultationEntries[cec.getPosition()] = cec;
	            	
	            	consultationEntryList.setListData(consultationEntries);
	            	//consultationEntryList.repaint();
	            	consultationEntryList.setSelectedIndex((currentLocation-1));
	            }
            }
        }

        if (event.getSource() == downButton) {
            int currentLocation = consultationEntryList.getSelectedIndex();
            
            if(currentLocation != -1)
            {
	            ConsultationEntryConfig cec = (ConsultationEntryConfig) consultationEntryList.getModel().getElementAt(currentLocation);
	            
	            if(cec.getPosition()+1 < consultationEntries.length)
	            {
	            	ConsultationEntryConfig cecSave = consultationEntries[cec.getPosition()+1];
	            	cecSave.setPosition(cec.getPosition());
	            	consultationEntries[cec.getPosition()] = cecSave;
	            	cec.setPosition(cec.getPosition()+1);
	            	consultationEntries[cec.getPosition()] = cec;
	            	
	            	consultationEntryList.setListData(consultationEntries);
	            	//consultationEntryList.repaint();
	            	consultationEntryList.setSelectedIndex((currentLocation+1));
	            }
            }
        }
        
        
        
        // HistoryTab
        
     // actions of consultation config panel
     		if (event.getSource() == enabletabButton) {
                 // get selected element
     			  // get selected element
    			HistoryTabEntryConfig htc = (HistoryTabEntryConfig) historytabsList.getSelectedValue();
    			
    			// if element not new column
    			if(!htc.getId().equals(NEW_COLUMN))
    			{
    	            // change the value to "true":
    	            htc.setEnabled(true);
    	
    	            int currentLocation = historytabsList.getSelectedIndex();
    	            historytabsList.setSelectedIndex((currentLocation));
    	
    	            historytabsList.repaint();
    			}
             }

             if (event.getSource() == disabletabButton) {
                 // get selected element
            	 HistoryTabEntryConfig htc = (HistoryTabEntryConfig) historytabsList.getSelectedValue();
     			
     			// if element not new column
     			if(!htc.getId().equals(NEW_COLUMN))
     			{
     	            // change the value to "true":
     	            htc.setEnabled(false);
     	
     	            int currentLocation = historytabsList.getSelectedIndex();
     	            historytabsList.setSelectedIndex((currentLocation));
     	
     	            historytabsList.repaint();
     			}
             	
             }

             if(event.getSource() == edittabButton)
             {
             	
            	
         		 int currentLocation =  historytabsList.getSelectedIndex();
                 if(currentLocation != -1)
                 {
                	 HistoryTabEntryConfig htc = (HistoryTabEntryConfig)historytabsList.getModel().getElementAt(currentLocation);
                	
                	 historyTabConfigDialog = new HistoryTabConfigDialog();
                	 HistoryTabEntryConfig htc2 = historyTabConfigDialog.showDialog(htc);
                	 
                	 if(htc2!=null)
                	 {
	                	 historytabEntries.setElementAt(htc2, htc2.getPosition());
	                
	    	            	historytabsList.setListData(historytabEntries);
	                 	 historytabsList.repaint();
                	 }
                 }
             }
             
             if(event.getSource() == addButton)
             {
                	 HistoryTabEntryConfig htc = new HistoryTabEntryConfig("",true, historytabEntries.size());
                	
                	 historyTabConfigDialog = new HistoryTabConfigDialog();
                	 HistoryTabEntryConfig htc2 = historyTabConfigDialog.showDialog(htc);
                	 
                	 if(htc2!=null)
                	 {
                		 historytabEntries.add(htc2);
                	 
                
               // 	 this.updateSettings();

   	            	historytabsList.setListData(historytabEntries);
                	 historytabsList.repaint();
                	 }
             }        
             
             if(event.getSource() == deleteButton)
             {
				int dialogResult = JOptionPane.showConfirmDialog (null, "Are you sure to want to delete this tab?","Warning",JOptionPane.YES_NO_OPTION);
            	 if(dialogResult == JOptionPane.YES_OPTION){
            		  int currentLocation =  historytabsList.getSelectedIndex();
                      if(currentLocation != -1)
                      {
          	            HistoryTabEntryConfig htc = (HistoryTabEntryConfig)historytabsList.getModel().getElementAt(currentLocation);
          	          historytabEntries.removeElementAt(currentLocation);
          	    //      this.updateSettings();

    	            	historytabsList.setListData(historytabEntries);
                	 historytabsList.repaint();
                      }
            	 }
            	
             } 
             
             
             if (event.getSource() == uptabButton) {
            	  int currentLocation =  historytabsList.getSelectedIndex();
                  if(currentLocation != -1)
                  {
      	            HistoryTabEntryConfig htc = (HistoryTabEntryConfig)historytabsList.getModel().getElementAt(currentLocation);
      	            
      	            if(htc.getPosition()-1 >= 0)
      	            {
      	            	
      	            	HistoryTabEntryConfig htcSave = historytabEntries.elementAt(htc.getPosition()-1);
      	            	htcSave.setPosition(htc.getPosition());
      	            	 historytabEntries.setElementAt(htcSave, htc.getPosition());
      	          //  	historytabEntries[htc.getPosition()] = htcSave;
      	            	htc.setPosition(htc.getPosition()-1);
      	            	 historytabEntries.setElementAt(htc, htc.getPosition());
//      	            historytabEntries[htc.getPosition()] = htc;
      	            	
      	            	historytabsList.setListData(historytabEntries);
      	            	//consultationEntryList.repaint();
      	            	historytabsList.setSelectedIndex((currentLocation-1));
      	            }
                  }
            	 
             }

             if (event.getSource() == downtabButton) {
            	 int currentLocation =  historytabsList.getSelectedIndex();
                 if(currentLocation != -1)
                 {
     	            HistoryTabEntryConfig htc = (HistoryTabEntryConfig)historytabsList.getModel().getElementAt(currentLocation);
     	            
     	           if(htc.getPosition()+1 < historytabEntries.size())
   	            {
     	            	HistoryTabEntryConfig htcSave = historytabEntries.elementAt(htc.getPosition()+1);
     	            	htcSave.setPosition(htc.getPosition());
     	            	historytabEntries.setElementAt(htcSave, htc.getPosition());
     	            	htc.setPosition(htc.getPosition()+1);
     	            	historytabEntries.setElementAt(htc, htc.getPosition());
     	            	
     	            	historytabsList.setListData(historytabEntries);
     	            	//consultationEntryList.repaint();
     	            	historytabsList.setSelectedIndex((currentLocation+1));
     	            }
                 }
             }
             
             
        
        
        
        
        
        
        
        
        
        //////
        
        
        // actions of ImportantDataPanel 
		if (event.getSource() == importantDataEnableButton) {
            // get selected Element:
			ImportantDataPanelConfig idc = (ImportantDataPanelConfig) importantDataList.getSelectedValue();

            // change the value to "true":
            idc.setEnabled(true);

            int currentLocation = importantDataList.getSelectedIndex();
            importantDataList.setSelectedIndex((currentLocation));

            importantDataList.repaint();
        }

        if (event.getSource() == importantDataDisableButton) {
            // get selected Element:
        	ImportantDataPanelConfig idc = (ImportantDataPanelConfig) importantDataList.getSelectedValue();

            // change the value to "true":
        	idc.setEnabled(false);

            int currentLocation = importantDataList.getSelectedIndex();
            importantDataList.setSelectedIndex((currentLocation));

            importantDataList.repaint();
        }
        
        
        if (event.getSource() == importantDataUpButton)
        {
            int currentLocation = importantDataList.getSelectedIndex();
            
            if(currentLocation != -1 && currentLocation-1 >= 0)
            {
            	ImportantDataPanelConfig idc = (ImportantDataPanelConfig) importantDataList.getModel().getElementAt(currentLocation);
            	ImportantDataPanelConfig idcSave = importantDataConfig[currentLocation-1];
            	idcSave.setPosition(currentLocation);
            	importantDataConfig[currentLocation] = idcSave;
            	idc.setPosition(currentLocation-1);
            	importantDataConfig[currentLocation-1] = idc;
            	
            	importantDataList.setListData(importantDataConfig);
            	//consultationEntryList.repaint();
            	importantDataList.setSelectedIndex((currentLocation-1));
            }   
        }

        if (event.getSource() == importantDataDownButton)
        {
            int currentLocation = importantDataList.getSelectedIndex();
            
            if(currentLocation != -1 && currentLocation+1 < importantDataConfig.length)
            {
            	ImportantDataPanelConfig idc = (ImportantDataPanelConfig) importantDataList.getModel().getElementAt(currentLocation);
            	ImportantDataPanelConfig idcSave = importantDataConfig[currentLocation+1];
            	idcSave.setPosition(currentLocation);
            	importantDataConfig[currentLocation] = idcSave;
            	idc.setPosition(currentLocation+1);
            	importantDataConfig[currentLocation+1] = idc;
            	
            	importantDataList.setListData(importantDataConfig);
            	//consultationEntryList.repaint();
            	importantDataList.setSelectedIndex((currentLocation+1));
            }    
        }
	}
	
	// Inner classes for render consultation config panel
	public class ConsultationEntryListRenderer extends JLabel implements ListCellRenderer
	{
		private static final long serialVersionUID = 1L;

		/**
		 * builds a new DefaultComboboxRenderer
		 */
		public ConsultationEntryListRenderer()
		{
			setOpaque(true);
			setHorizontalAlignment(LEFT);
			setVerticalAlignment(CENTER);
		}
		
		
		/* (non-Javadoc)
		 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
		 */
		public Component getListCellRendererComponent(JList list, Object value,
		        int index, boolean isSelected, boolean cellHasFocus) {
			if (value == null)
				return new JLabel();
			
		    if (isSelected) {
		        setBackground(list.getSelectionBackground());
		        setForeground(list.getSelectionForeground());
		    } else {
		        setBackground(list.getBackground());
		        setForeground(list.getForeground());
		    }
		    
		    try {
		        String cEcName = ((ConsultationEntryConfig)value).getName();
		        String cEcAcronym = ((ConsultationEntryConfig)value).getAcronym();
		        String cEcId = ((ConsultationEntryConfig)value).getId();
		        
		        if(cEcId.equals(PatientModuleSettings.NEW_COLUMN))
		        {
		        	this.setText(cEcName);
		        }else{
			        // get name of translatrix if possible
					String translatrixName = "patient.incident." + cEcName;
					
					if(Translatrix.getTranslationString(translatrixName) != translatrixName)
					{
						this.setText(cEcAcronym + " - " + Translatrix.getTranslationString(translatrixName) + " " + "[" + cEcId + "]");
					}else{	
						this.setText(cEcAcronym + " - " + cEcName + " " + "[" + cEcId + "]");
					}		        
		        }
		        
		        if(cEcId.equals(PatientModuleSettings.NEW_COLUMN))
		        {
		        	this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.EMPTY_ICON));
		        }else{
		        	if(((ConsultationEntryConfig)value).isEnabled() ){
			            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.OK));
			        } else {
			            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.CANCEL));
			        }
		        }
		    } catch (Exception e) {
		    	logger.log(Level.WARN, "rendering plugins failed", e);
		    }
		    
		    return this;
		}
	}
	
	// Inner classes for render important data panel
	public class ImportantDataListRenderer extends JLabel implements ListCellRenderer
	{
		private static final long serialVersionUID = 1L;

		/**
		 * builds a new DefaultComboboxRenderer
		 */
		public ImportantDataListRenderer()
		{
			setOpaque(true);
			setHorizontalAlignment(LEFT);
			setVerticalAlignment(CENTER);
		}
		
		
		/* (non-Javadoc)
		 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
		 */
		public Component getListCellRendererComponent(JList list, Object value,
		        int index, boolean isSelected, boolean cellHasFocus) {
		    if (isSelected) {
		        setBackground(list.getSelectionBackground());
		        setForeground(list.getSelectionForeground());
		    } else {
		        setBackground(list.getBackground());
		        setForeground(list.getForeground());
		    }
		    try {
		        
		    	String name = "";
		    	
		    	if(((ImportantDataPanelConfig) value).getId().equals(IncidentManager.ACTIVE_PROBLEMS))
		    		name = Translatrix.getTranslationString("patient.activeproblems");
				
				if(((ImportantDataPanelConfig) value).getId().equals(IncidentManager.ALLERGIES))
					name = Translatrix.getTranslationString("patient.allergy.allergies");
				
				if(((ImportantDataPanelConfig) value).getId().equals(IncidentManager.ANTECEDENTS))
					name = Translatrix.getTranslationString("patient.antecedents");
				
				if(((ImportantDataPanelConfig) value).getId().equals(IncidentManager.CHRONICAL_TREATMENTS))
					name = Translatrix.getTranslationString("patient.cronicaltreatment");
				
		    	this.setText(name);
		        
		        if(((ImportantDataPanelConfig)value).isEnabled()){
		            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.OK));
		        } else {
		            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.CANCEL));
		        }
		    } catch (Exception e) {
		    	logger.log(Level.WARN, "rendering plugins failed", e);
		    }
		    
		    return this;
		}
	}
	
	// Inner classes for render important data panel
		public class HistoryTabEntryListRenderer extends JLabel implements ListCellRenderer
		{
			private static final long serialVersionUID = 1L;

			/**
			 * builds a new DefaultComboboxRenderer
			 */
			public HistoryTabEntryListRenderer()
			{
				setOpaque(true);
				setHorizontalAlignment(LEFT);
				setVerticalAlignment(CENTER);
			}
			
			
			/* (non-Javadoc)
			 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
			 */
			public Component getListCellRendererComponent(JList list, Object value,
			        int index, boolean isSelected, boolean cellHasFocus) {
			    if (isSelected) {
			        setBackground(list.getSelectionBackground());
			        setForeground(list.getSelectionForeground());
			    } else {
			        setBackground(list.getBackground());
			        setForeground(list.getForeground());
			    }
			    try {
			        
			    	String name = ((HistoryTabEntryConfig) value).getId();
			    	
			    	
			    	/*if(((HistoryTabEntryConfig) value).getId().equals(IncidentManager.ACTIVE_PROBLEMS))
			    		name ="aaaa";
					
					if(((HistoryTabEntryConfig) value).getId().equals(IncidentManager.ALLERGIES))
						name = "bbbb";
					
					if(((HistoryTabEntryConfig) value).getId().equals(IncidentManager.ANTECEDENTS))
						name = "ccccc";
					
					if(((HistoryTabEntryConfig) value).getId().equals(IncidentManager.CHRONICAL_TREATMENTS))
						name = "dddddd";
					*/
			    	
			    	this.setText(name);
			        
			        if(((HistoryTabEntryConfig)value).isEnabled()){
			            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.OK));
			        } else {
			            this.setIcon(GECAMedModule.getSmallIcon(GECAMedModule.CANCEL));
			        }
			    } catch (Exception e) {
			    	logger.log(Level.WARN, "rendering plugins failed", e);
			    }
			    
			    return this;
			}
		}
}