/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.update;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.prescription.ejb.session.beans.PrescriptionManagerBean;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.PrescriptionManager;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Dialog that triggers the conversion process from old incident entry tables and beans 
 * to the new IncidentEntry data model.
 * It is called by the MainFrame class when an entry in the core.info table is absent.
 * This dialog must run once successfully to continue using the application. 
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 07.03.2008
 * 10:32:20
 *
 *
 * @version
 * <br>$Log: IncidentEntryUpdateDialog.java,v $
 * <br>Revision 1.5  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-03-11 17:17:12  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-03-10 12:37:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class IncidentEntryUpdateDialog extends GECAMedBaseDialog implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static final int STATE_NEW 		= 1;
	public static final int STATE_RUNNING 	= 2;
	public static final int STATE_FINISHED  = 3;
	
	private int currentState = STATE_NEW;

	private JPanel startPanel;

	private JLabel startLabel;

	private JButton startButton;

	private JButton closeButton;

	private JProgressBar progressBar;

	private JPanel runningPanel;

	private JLabel runningLabel;

	private JLabel progressLabel;

	private JPanel finishPanel;

	private JLabel finishLabel;

	private JPanel mainPanel;

	private int oldPatients;

	private int oldConsultations;

	private boolean abort = false;

	private Font labelFont;
	
	
	
	public IncidentEntryUpdateDialog() {
		/* ================================================== */
		super(Translatrix.getTranslationString("pm.update.consultation.header"), false);
		this.showHeader(true);
		this.setHeaderTitle(Translatrix.getTranslationString("pm.update.consultation.headerText"));
		this.setHeaderIcon(GECAMedModule.getIcon(GECAMedIconNames.INFO));
		this.headerLabel.setVerticalTextPosition(SwingConstants.CENTER);
		initComponent();
		
		/* ================================================== */
	}
	
	
	@SuppressWarnings("unused")
	private IncidentEntryUpdateDialog(String title) {
		super(title);
	}
	
	
	
	/**
	 * 
	 */
	public void showDialog() {
		/* ================================================== */
		// get data from database
//		getInfos();
		// update the view
		this.switchState(STATE_NEW);
		
		this.pack();
		
		MainFrame.showDialogCentered(this);
		/* ================================================== */
	}
	
	public int getState() {
		/* ================================================== */
		return this.currentState;
		/* ================================================== */
	}
	
	/**
	 * init component
	 */
	private void initComponent() {
		/* ================================================== */
		this.startPanel = new JPanel(new BorderLayout());
		this.startLabel = new JLabel();
		this.labelFont = new Font("Arial",Font.PLAIN, 12);
		startLabel.setFont(labelFont);
		/* ------------------------------------------------------- */
		this.startButton = new JButton(Translatrix.getTranslationString("pm.update.consultation.start"), 
										GECAMedModule.getMediumIcon(GECAMedIconNames.RELOAD));
		this.cancelButton = new JButton(Translatrix.getTranslationString("pm.cancel"),
										GECAMedModule.getMediumIcon(GECAMedIconNames.CANCEL));
		this.closeButton = new JButton(Translatrix.getTranslationString("pm.ok"),
										GECAMedModule.getMediumIcon(GECAMedIconNames.OK));
		/* ------------------------------------------------------- */
		this.startButton .addActionListener(this);
		this.cancelButton.addActionListener(this);
		this.closeButton .addActionListener(this);
		/* ------------------------------------------------------- */
		this.progressBar = new JProgressBar();
		
		buildNewPanel();
		buildRunningPanel();
		buildFinishPanel();
		/* ------------------------------------------------------- */
		this.mainPanel = new JPanel(new BorderLayout());
		mainPanel.setOpaque(false);
		
		mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
		
		this.addMainPanel(mainPanel);
		/* ================================================== */
	}
	
//	/**
//	 * Get infos from session bean
//	 */
//	private void getInfos() {
//		/* ================================================== */
//		IncidentManager iManager = (IncidentManager) 
//					ManagerFactory.getRemote(IncidentManagerBean.class);
//		try {
//			/* ------------------------------------------------------- */
//			this.patients 		= iManager.getPatientNames();
//			this.incidentCount  = iManager.getIncidentCount();
//			/* ------------------------------------------------------- */
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		/* ================================================== */
//	}
	
	
	/**
	 * 
	 * 
	 * @param state
	 */
	private void switchState(int state) {
		/* ================================================== */
		if (STATE_NEW == state) {
			/* ------------------------------------------------------- */
			updateNewLabel();
			this.mainPanel.removeAll();
			this.mainPanel.add(this.startPanel);
			this.pack();
			/* ------------------------------------------------------- */
		} else
			if (STATE_RUNNING == state) {
				/* ------------------------------------------------------- */
				updateRunningLabel();
				this.mainPanel.removeAll();
				this.mainPanel.add(this.runningPanel);
				this.setSize(this.getWidth(), this.getHeight()+75);
				/* ------------------------------------------------------- */
			} else
				if (STATE_FINISHED == state) {
					/* ------------------------------------------------------- */
					updateFinishLabel();
					this.mainPanel.removeAll();
					this.mainPanel.add(this.finishPanel);
//					this.setSize(this.getWidth(), this.getHeight()-75);
					this.pack();
					/* ------------------------------------------------------- */
				}
		this.currentState = state;
		
		this.mainPanel.validate();
		this.mainPanel.updateUI();
//		this.pack();
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	private void buildNewPanel() {
		/* ================================================== */
		this.startPanel.add(this.startLabel, BorderLayout.CENTER);
		this.startPanel.setOpaque(false);
		
		startLabel.setBorder(BorderFactory.createTitledBorder(""));
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();
		bb.addGridded(this.startButton);
		bb.getPanel().setOpaque(false);
		
		bb.getPanel().setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
		
		startPanel.add(bb.getPanel(), BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	/**
	 * reformated the new label
	 */
	private void updateNewLabel() {
		/* ================================================== */
//		String s = Translatrix.getTranslationString("pm.update.consultation.newText");
//		// parse
//		s = s.replaceFirst("noPatient", ""+this.patients.keySet().size());
//		s = s.replaceFirst("noConsultation", ""+this.incidentCount);
		
//		this.startLabel.setText(s);
		this.startLabel.setText("Converting an unknown amount of patient files. Stand By");
		/* ================================================== */
	}
	
	
	/**
	 * build the running panel
	 */
	private void buildRunningPanel() {
		/* ================================================== */
		this.runningPanel = new JPanel(new BorderLayout());
		this.runningLabel = new JLabel();
		runningLabel.setFont(labelFont);
		this.runningPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		this.progressLabel = new JLabel();
		progressLabel.setFont(labelFont);
		
		JPanel progressPanel = new JPanel(new FormLayout("3dlu,left:pref,fill:10dlu:grow,3dlu","3dlu,fill:pref,3dlu,fill:15dlu,3dlu"));
		/* ------------------------------------------------------- */
		CellConstraints cc = new CellConstraints();
		progressPanel.add(this.progressLabel, cc.xy(2, 2));
		progressPanel.add(this.progressBar,   cc.xyw(2, 4, 2));
		
		progressPanel.setOpaque(false);
		progressPanel.setBorder(BorderFactory.createTitledBorder(""));
		/* ------------------------------------------------------- */
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addUnrelatedGap();
		bb.addGlue();
		bb.addGridded(this.cancelButton);
		bb.addGlue();
		bb.addUnrelatedGap();
		
		bb.getPanel().setOpaque(false);
		bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		/* ------------------------------------------------------- */
		runningPanel.add(this.runningLabel, BorderLayout.NORTH);
		runningPanel.add(progressPanel,     BorderLayout.CENTER);
		runningPanel.add(bb.getPanel(), 	BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	/**
	 * reformat the running label
	 */
	private void updateRunningLabel() {
		/* ================================================== */
//		String s = Translatrix.getTranslationString("pm.update.consultation.runningText");
//		// parse
//		s = s.replaceFirst("noPatient", ""+this.patients.keySet().size());
//		s = s.replaceFirst("noConsultation", ""+this.incidentCount);
//		
//		this.runningLabel.setText(s);
		this.runningLabel.setText("Mission started. Be patient while deleting all of your data.");
		/* ================================================== */
	}
	
	/**
	 * @param text
	 */
	private void updateProgressLabel(String text) {
		/* ================================================== */
		this.progressLabel.setText(text);
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	private void buildFinishPanel() {
		/* ================================================== */
		this.finishPanel = new JPanel(new BorderLayout());
		this.finishLabel = new JLabel();
		finishLabel.setFont(labelFont);
		finishLabel.setBorder(BorderFactory.createTitledBorder(""));
		
		this.finishPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addUnrelatedGap();
		bb.addGlue();
		bb.addGridded(this.closeButton);
		bb.addGlue();
		bb.addUnrelatedGap();
		
		bb.getPanel().setOpaque(false);
		bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		/* ------------------------------------------------------- */
		this.finishPanel.add(this.finishLabel, BorderLayout.CENTER);
		this.finishPanel.add(bb.getPanel(),    BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	private void updateFinishLabel() {
		/* ================================================== */
		String s = Translatrix.getTranslationString("pm.update.consultation.finishText");
		// parse
		s = s.replaceFirst("noPatient", ""+this.oldPatients);
		s = s.replaceFirst("noConsultation", ""+this.oldConsultations);
		// TODO, errors
		s = s.replaceFirst("error", "0");
		
		this.finishLabel.setText(s);
		/* ================================================== */
	}
	
	/**
	 * The conversion process
	 */
	private void doConvert() {
		/* ================================================== */
//		// save the old values
//		this.oldPatients 	   = this.patients.keySet().size();
//		this.oldConsultations  = this.incidentCount.intValue();
		/* ------------------------------------------------------- */
		final IncidentManager iManager = (IncidentManager) 
					ManagerFactory.getRemote(IncidentManagerBean.class);
		final PrescriptionManager pManager = (PrescriptionManager) 
					ManagerFactory.getRemote(PrescriptionManagerBean.class);
		
		Thread t = new Thread() {
			public void run() {
				/* ================================================== */
				/* ------------------------------------------------------- */
					/* ------------------------------------------------------- */
					if (abort) {
						/* ------------------------------------------------------- */
						switchState(STATE_NEW);
						abort = false;
						return;
						/* ------------------------------------------------------- */
					}
					updateRunningLabel();
					updateProgressLabel("Converting MeasuremntValues....");
					boolean allOk = false;
					// ....when the task of (initially) unknown length begins:
					progressBar.setIndeterminate(true);
					progressBar.setString("Converting ....");
					progressBar.setStringPainted(true);
					/* ------------------------------------------------------- */
					allOk = iManager.convertMeasurementValues();
					/* ---------------------------------------------------- */
					// prescriptions
					/* ---------------------------------------------------- */
					updateProgressLabel("Converting Prescriptions ....");
					
					try {
						/* ---------------------------------------------------- */
						List<Integer> idList = iManager.getPrescriptionIdsToConvert();
						progressBar.setIndeterminate(false);
						progressBar.setMaximum(idList.size());
						progressBar.setValue(0);
						/* ---------------------------------------------------- */
						// iterate over the ids and convert each prescription
						// in a single transaction
						/* ---------------------------------------------------- */
						boolean convertState = false;
						
						for (Integer pId : idList) {
							/* ============================================== */
							convertState = iManager.convertPrescription(pId);
							if (convertState == false)
								allOk = false;
							progressBar.setValue(progressBar.getValue()+1);
							/* ============================================== */
						}
						/* ---------------------------------------------------- */
					} catch (Exception e) {
						e.printStackTrace();
					}
					/* ---------------------------------------------------- */
					// prescription revisions
					/* ---------------------------------------------------- */
					updateProgressLabel("Converting PrescriptionRevisions ....");
					
					try {
						/* ---------------------------------------------------- */
						List<Integer> idList = pManager.getPrescriptionRevisionIdsToConvert();
						progressBar.setIndeterminate(false);
						progressBar.setMaximum(idList.size());
						progressBar.setValue(0);
						/* ---------------------------------------------------- */
						// iterate over the ids and convert each prescription
						// in a single transaction
						/* ---------------------------------------------------- */
						boolean convertState = false;
						
						for (Integer pId : idList) {
							/* ============================================== */
							convertState = pManager.convertPrescriptionRevision(pId);
							if (convertState == false)
								allOk = false;
							progressBar.setValue(progressBar.getValue()+1);
							/* ============================================== */
						}
						/* ---------------------------------------------------- */
					} catch (Exception e) {
						e.printStackTrace();
					}
					
					
					
					/* ------------------------------------------------------- */
					if (allOk)
						switchState(STATE_FINISHED);
					else {
						switchState(STATE_NEW);
						
					}
 				/* ================================================== */
			}
		};
		
		t.start();
		/* ================================================== */
	}
	
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		if (startButton.equals(e.getSource())) {
			/* ================================================== */
			switchState(STATE_RUNNING);
			doConvert();
			/* ================================================== */
		}
		if (cancelButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			this.abort  = true;
			/* ------------------------------------------------------- */
		}
		if (closeButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			this.setVisible(false);
			/* ------------------------------------------------------- */
		}
		/* ====================================================== */
	}

}
