package lu.tudor.santec.gecamed.patient.utils;


/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: SettingConstants.java,v $
 */

public interface SettingConstants
{
	/**
	 * show facturation address or third party payer
	 */
	public static final String ADDRESS_FACTURATION = "ADDRESS_FACTURATION";
	
	
	/**
	 * different naming of the name fields 
	 * Doctors = TRUE
	 * CHEM = FALSE 
	 */
	public static final String MAIDEN_CONFIG = "MAIDEN_CONFIG";
	
	/**
	 * show a button to create an empty incident in the patient panel
	 */
	public static final String SHOW_EMPTY_INCIDENT_BUTTON = "SHOW_EMPTY_INCIDENT_BUTTON";

    /**
     * list of enabled elements
     */
    public static final String ENABLED_ELEMENTS = "EnabledAdministrativeElements";
    
    /**
     * list of disabled elements
     */
    public static final String DISABLED_ELEMENTS = "DisabledAdministrativeElements";
    
    /**
     * Allow manual doctor association in the "Additional Info" panel of the "General Patient Data" View.
     */
    public static final String ALLOW_MANUAL_DOCTOR_ASSOCIATION = "ALLOW_MANUAL_DOCTOR_ASSOCIATION";
    
    /**
     * Allow automatic doctor association the current select doctor will set when the patient going to be save.
     */
    public static final String ALLOW_AUTOMATIC_DOCTOR_ASSOCIATION = "ALLOW_AUTOMATIC_DOCTOR_ASSOCIATION";
    
    public static final String ALWAYS_APPLY_ADT_UPDATES = "ALWAYS_APPLY_ADT_UPDATES";
    
    /**
     * Defines, which mode is chosen to enter the social security number
     */
    public static final String	SSN_EDIT_MODE			= "ssnEditMode";
    public static final int		SSN_FIX_FORMAT_MODE		= 0;
    public static final int		SSN_FREE_FORMAT_MODE	= 1;
    public static final int		SSN_NO_FORMAT_MODE		= 2;
    public static final int		SSN_DEFAULT_FORMAT_MODE	= SSN_FREE_FORMAT_MODE;
    
    public static final String	PATIENT_LAST_NAME_MODE	= "patientLastNameMode";
    public static final String	PATIENT_FIRST_NAME_MODE	= "patientFirstNameMode";
    public static final int		PATIENT_NAME_AS_ENTERED	= 0;
    public static final int		PATIENT_NAME_CAPITALIZED= 1;
    public static final int		PATIENT_NAME_UPPER_CASE	= 2;
    public static final int		PATIENT_NAME_DEFAULT	= PATIENT_NAME_AS_ENTERED;
    
    public static final String	PHYSICIAN_WITH_TITLE	= "printPhysicianWithTitle";
    public static final String	PHYSICIAN_SWITCH_NAMES	= "switchPhysicianNames";
    public static final String	PHYSICIAN_WITH_COMMA	= "printPhysicianWithComma";
    
    public static final boolean	DEFAULT_ALWAYS_APPLY_ADT_UPDATES	= true;
}
