/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Author: Johannes Hermen Tudor/Santec
 */


@javax.persistence.NamedQueries({
    @javax.persistence.NamedQuery(name="findAllPosologyTemplatesByPhysicianID",
        query="SELECT OBJECT(o) FROM PosologyTemplate o WHERE o.physicianID = :physicianID")
})


@Entity
@Table(name="posologytemplates", schema="prescription")
public class PosologyTemplate extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	
	/** Regular field. */
	private String text;
	private Integer physicianID;

	/**
	 * Get the value.
	 *
	 * @return The value.
	 */
	@javax.persistence.Column(name = "text")
	public java.lang.String getText() {
		return text;
	}

	/**
	 * Set the value.
	 *
	 * @param value The value.
	 */
	public void setText(String value) {
		this.text = value;
	}

	
    public String toString() {
        return this.getText();
    }

	@Override
	public boolean equals(Object obj) {
		try {
			return this.getText().equals(((PosologyTemplate)obj).getText());
		} catch (Exception e) {
			return false;
		}		
	}

	/**
	 * @return Returns the physicianID.
	 */
	@javax.persistence.Column(name = "physicianid")
	public Integer getPhysicianID() {
		return physicianID;
	}

	/**
	 * @param physicianID The physicianID to set.
	 */
	public void setPhysicianID(Integer physicianID) {
		this.physicianID = physicianID;
	}
    
    
}
