/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * Mapped on the prescription drug revisions table.
 * Used to keep track of changes on prescriptions.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 14.01.2008
 * 15:29:41
 *
 *
 * @version
 * <br>$Log: PrescriptionDrugRevision.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 *   
 */
@Entity
@Table(name = "prescription_drug_revisions", schema = "prescription")
public class PrescriptionDrugRevision extends GECAMedEntityBean implements java.io.Serializable {

	// Fields

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private PrescriptionRevision prescription;
	private String name;
	private Integer drugId;
	private Integer drugListId;
	private String posology;

	/**
	 * Transient, to store the form of the drug temporary
	 */
	private String form;



	// Constructors

	/** default constructor */
	public PrescriptionDrugRevision() {
	}


	// Property accessors
	@ManyToOne(cascade = {}, fetch = FetchType.LAZY)
	@JoinColumn(name = "prescription_rev_id", unique = false, nullable = false, insertable = true, updatable = true)
	public PrescriptionRevision getPrescriptionRevision() {
		return this.prescription;
	}

	public void setPrescriptionRevision(PrescriptionRevision prescriptions) {
		this.prescription = prescriptions;
	}

	@Column(name = "name", unique = false, nullable = false, insertable = true, updatable = true, length = 250)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "drug_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDrugId() {
		return this.drugId;
	}

	public void setDrugId(Integer drugId) {
		this.drugId = drugId;
	}

	@Column(name = "drug_list_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDrugListId() {
		return this.drugListId;
	}

	public void setDrugListId(Integer drugListId) {
		this.drugListId = drugListId;
	}


	/**
	 * @return the posology
	 */
	@Column(name="posology")
	public String getPosology() {
		return posology;
	}


	/**
	 * @param posology the posology to set
	 */
	public void setPosology(String posology) {
		this.posology = posology;
	}




	/* ********************************************************
	 * Transient fields
	 */

	/**
	 * @return the form
	 */
	@Transient
	public String getForm() {
		/* ====================================================== */
		return form;
		/* ====================================================== */
	}

	/**
	 * @param form the form to set
	 */
	public void setForm(String form) {
		/* ====================================================== */
		this.form = form;
		/* ====================================================== */
	}
	/* ------------------------------------------------------- */
	@Transient
	public PrescriptionDrugRevision copy() {
		/* ====================================================== */
		PrescriptionDrugRevision d = new PrescriptionDrugRevision();

		d.setDrugListId(this.getDrugId());
		d.setDrugId(this.getDrugId());
		d.setName(this.getName());
		d.setPosology(this.getPosology());

		return d;
		/* ====================================================== */
	}


}
