/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Mapped on the table Prescription template.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 14.01.2008
 * 15:39:25
 *
 *
 * @version
 * <br>$Log: PrescriptionTemplate.java,v $
 * <br>Revision 1.10  2010-07-22 09:49:39  troth
 * <br>add implementation - # 239: Prescription Templates linked to physician
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/239
 * <br>
 * <br>Revision 1.9  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.8  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 *   dirroth
 */
@javax.persistence.NamedQueries( {
	@NamedQuery(name=PrescriptionTemplate.GET_USER_TEMPLATES,
			query="SELECT Object (o) FROM PrescriptionTemplate o WHERE " + 
			"(o.physicianId IS NULL OR o.physicianId = :physicianId) " +
			"AND o.prescriptionTypeId IN (" +
									"SELECT p.id FROM PrescriptionType p WHERE p.name = :type) " +
									"ORDER BY o.shortcut ASC")
			}) 


@Entity
@Table(name = "templates", schema = "prescription")
public class PrescriptionTemplate extends GECAMedEntityBean implements java.io.Serializable {

	// Fields    

	
	public static final String GET_USER_TEMPLATES = "findAllUserPrescriptionTemplates";
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer prescriptionTypeId;
	private String shortcut;
	private String description;
	private String textContent;
	private Boolean isWarning = false;
	private String warningMsg;
	private int ownerId;
	private Date created;
	private Date modified;
	private Set<TemplateDrug> templateDrugs = new LinkedHashSet<TemplateDrug>(0);
	private Integer physicianId;

	// Constructors

	/** default constructor */
	public PrescriptionTemplate() {
	}

	// Property accessors

	@Column(name = "prescription_types_id", unique = false, nullable = false, insertable = true, updatable = true)
	public Integer getPrescriptionTypeId() {
		return this.prescriptionTypeId;
	}

	public void setPrescriptionTypeId(Integer prescriptionTypeId) {
		this.prescriptionTypeId = prescriptionTypeId;
	}

	@Column(name = "shortcut", unique = false, nullable = true, insertable = true, updatable = true, length = 30)
	public String getShortcut() {
		return this.shortcut;
	}

	public void setShortcut(String shortcut) {
		this.shortcut = shortcut;
	}

	@Column(name = "description", unique = false, nullable = true, insertable = true, updatable = true, length = 250)
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "text_content", unique = false, nullable = true, insertable = true, updatable = true)
	public String getTextContent() {
		return this.textContent;
	}

	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}

	@Column(name = "is_warning", unique = false, nullable = true, insertable = true, updatable = true)
	public Boolean getIsWarning() {
		return this.isWarning;
	}

	public void setIsWarning(Boolean isWarning) {
		this.isWarning = isWarning;
	}

	@Column(name = "warning_msg", unique = false, nullable = true, insertable = true, updatable = true)
	public String getWarningMsg() {
		return this.warningMsg;
	}

	public void setWarningMsg(String warningMsg) {
		this.warningMsg = warningMsg;
	}

	@Column(name = "owner_id", unique = false, nullable = false, insertable = true, updatable = true)
	public int getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(int ownerId) {
		this.ownerId = ownerId;
	}

	@Column(name = "created", unique = false, nullable = false, insertable = true, updatable = true, length = 8)
	public Date getCreated() {
		return this.created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	@Column(name = "modified", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getModified() {
		return this.modified;
	}

	public void setModified(Date modified) {
		this.modified = modified;
	}
	@OneToMany(cascade = {CascadeType.ALL}, fetch = FetchType.EAGER, mappedBy = "templateId")
	@OrderBy("id ASC")
	public Set<TemplateDrug> getTemplateDrugs() {
		return this.templateDrugs;
	}

	public void setTemplateDrugs(Set<TemplateDrug> templateDrugses) {
		this.templateDrugs = templateDrugses;
	}
	
	/**
	 * set the physician id if template is private
	 * @param physicianId the physician id if set null template is public
	 */
	public void setPhysicianId(Integer physicianId)
	{
		this.physicianId = physicianId;
	}
	
	/**
	 * get the physician id of template if it is private
	 * @return physicianId the physician id if return null template is public 
	 */
	@Column(name = "physician_id")
	public Integer getPhysicianId()
	{
		return physicianId;
	}
	
	/**
	 * Is like clone
	 * 
	 * @return
	 */
	@Transient
	public PrescriptionTemplate copy() {
		/* ============================================= */
		
		PrescriptionTemplate t = new PrescriptionTemplate();
		t.setId(this.getId());
		t.setCreated(this.getCreated());
		t.setDescription(this.getDescription());
		t.setIsWarning(this.getIsWarning());
		t.setModified(this.getModified());
		t.setOwnerId(this.getOwnerId());
		t.setPrescriptionTypeId(this.getPrescriptionTypeId());
		t.setShortcut(this.getShortcut());
		t.setTextContent(this.getTextContent());
		t.setWarningMsg(this.getWarningMsg());
		// drugs
		if (this.getTemplateDrugs() != null) {
			/* ------------------------------------------------------ */
			Set<TemplateDrug> tds = new HashSet<TemplateDrug>();
			for (TemplateDrug td : this.getTemplateDrugs()) {
				TemplateDrug tdNew = td.copy();
				tdNew.setTemplate(t);
				tdNew.setTemplateId(t.getId());
				tds.add(tdNew);
			}
			t.setTemplateDrugs(tds);
			/* ------------------------------------------------------ */
		}
		else t.setTemplateDrugs(null);
			
		return t;
		
		
		/* ============================================= */
	}

}
