/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * Drug that is attached to a prescription template.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 14.01.2008
 * 15:53:21
 *
 *
 * @version
 * <br>$Log: TemplateDrug.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-07-23 10:00:50  heinemann
 * <br>removed stand_alone column from prescription and prescription_revisions table
 * <br>
 * <br>Revision 1.3  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 *   
 */
@Entity
@Table(name = "template_drugs", schema = "prescription")
public class TemplateDrug extends GECAMedEntityBean implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Fields    
	private String name;
	private Integer drugId;
	private Integer drugListId;
	private String posology;
	private Integer templateId;
	private PrescriptionTemplate template;
	
	

	// Constructors

	/** default constructor */
	public TemplateDrug() {
	}


	// Property accessors
	@Column(name = "name", unique = false, nullable = true, insertable = true, updatable = true, length = 250)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "drug_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDrugId() {
		return this.drugId;
	}

	public void setDrugId(Integer drugId) {
		this.drugId = drugId;
	}

	@Column(name = "drug_list_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDrugListId() {
		return this.drugListId;
	}

	public void setDrugListId(Integer drugListId) {
		this.drugListId = drugListId;
	}

	@Column(name = "posology", unique = false, nullable = true, insertable = true, updatable = true)
	public String getPosology() {
		return this.posology;
	}

	public void setPosology(String posology) {
		this.posology = posology;
	}

	@Column(name="template_id", insertable=false, updatable=false)
	public Integer getTemplateId() {
		/* ====================================================== */
		return this.templateId;
		/* ====================================================== */
	}
	
	public void setTemplateId(Integer templateId) {
		/* ====================================================== */
		this.templateId = templateId;
		/* ====================================================== */
	}


	/**
	 * @return the template
	 */
	@ManyToOne(cascade = {}, fetch = FetchType.LAZY)
	@JoinColumn(name = "template_id")
	public PrescriptionTemplate getTemplate() {
		return template;
	}


	/**
	 * @param template the template to set
	 */
	public void setTemplate(PrescriptionTemplate template) {
		this.template = template;
	}
	
	/**
	 * Like clone
	 * 
	 * Template and templateId is left out!!!!!
	 * 
	 * @return
	 */
	@Transient
	public TemplateDrug copy() {
		/* ====================================================== */
		TemplateDrug t = new TemplateDrug();
		
		t.setId(this.getId());
		t.setDrugId(this.getDrugId());
		t.setDrugListId(this.getDrugListId());
		t.setName(this.getName());
		t.setPosology(this.getPosology());
		
		return t;
		/* ====================================================== */
	}
}
