/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * This class represents an ATC class.
 * See <a href="http://en.wikipedia.org/wiki/Anatomical_Therapeutic_Chemical_Classification_System">
 * http://en.wikipedia.org/wiki/Anatomical_Therapeutic_Chemical_Classification_System</a>
 * for details.
 * ATCClasses have a father-child relation.
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: AtcClass.java,v $
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.4  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.3  2007/02/28 10:14:20  mack
 * <br>Force Commit to override previous erronous commit
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2006/12/20 13:46:23  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 */
@Entity
@Table(name="cefip_atc_classes", schema="prescription")
public class AtcClass extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String code;
	
	private String name;

	
	public AtcClass() {
		/* ====================================================== */
		/* ====================================================== */
	}
	
	/* ------------------------------------------------------ */
	
	/**
	 * @return
	 */
	@Column(name="code")
	public String getCode() {
		return code;
	}

	/**
	 * @param code
	 */
	public void setCode(String code) {
		this.code = code;
	}
	/* ------------------------------------------------------ */
	/**
	 * @return
	 */
	@Column(name="name")
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	/* ------------------------------------------------------ */
	

	private Integer parentId;
	
	@Column(name="parent")
	public Integer getParentId() {
		/* ====================================================== */
		return this.parentId;
		/* ====================================================== */
	}
	
	public void setParentId(Integer parentId) {
		/* ====================================================== */
		this.parentId = parentId;
		/* ====================================================== */
	}
	/* ------------------------------------------------------ */
	
	private AtcClass parent;
	
	/**
	 * This is the parent
	 * 
	 * @return
	 */
	@ManyToOne
	@JoinColumn(name="parent", insertable=false, updatable=false)
	public AtcClass getParent() {
		/* ====================================================== */
		return this.parent;
		/* ====================================================== */
	}
	
	public void setParent(AtcClass parent) {
		/* ====================================================== */
		this.parent = parent;
		/* ====================================================== */
	}
}
