/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity for the drug_lists table.
 * Each drug list that is imported into the system must
 * create an entry in this table to be available in the system.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: DrugList.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.3.2.1  2006/12/22 08:24:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 * <br>Revision 1.2  2006/08/25 09:04:12  heinemann
 * <br>removed the entity annotaion while there is no table to map it to
 * <br>
 * <br>Revision 1.1  2006/08/25 09:02:08  heinemann
 * <br>initial checkin
 * <br>
 *
 */


@Entity
@Table(name="drug_lists", schema="prescription")
public class DrugList extends GECAMedEntityBean implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	private String name;
	
	private String originCountry;
	
	private Date date;
	
	
	public DrugList() {
		/* =========================== */
		/* =========================== */
	}

	/* *********************************************** */
	/**
	 * @return Returns the name.
	 */
	@Column(name="name")
	public String getName() {
		return name;
	}


	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/* *********************************************** */
	

	/**
	 * @return Returns the originCountry.
	 */
	@Column(name="origin_country")
	public String getOriginCountry() {
		return originCountry;
	}


	/**
	 * @param originCountry The originCountry to set.
	 */
	public void setOriginCountry(String originCountry) {
		this.originCountry = originCountry;
	}
	
	/* *********************************************** */
	
	/**
	 * @return Returns the date.
	 */
	@Column(name="list_date")
	public Date getDate() {
		return date;
	}


	/**
	 * @param date The date to set.
	 */
	public void setDate(Date date) {
		this.date = date;
	}
	/* *********************************************** */
}
