/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip;

// default package
// Generated 20.10.2006 11:16:49 by Hibernate Tools 3.1.0.beta5

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * This entity is used to import the drug data from the CEFIP list.
 * It contains all properties from the list. So, its quite a lot.
 * By advice, to not use this bean to get drug information from the database. Use the CefipDrug class
 * for this purpose. 
 */
@Entity
@Table(name = "cefip_drugs", schema = "prescription")
public class CefipDrugData extends GECAMedEntityBean implements Serializable {

	// Fields    

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String numnat;
	private String datehist;
	private String denom;
	private String formeclair;
	private String dosageq1;
	private String dosageu1;
	private String dosageqp1;
	private String dosageup1;
	private String dosageq2;
	private String dosageu2;
	private String dosageqp2;
	private String dosageup2;
	private String piece;
	private String larg;
	private String longu;
	private String poids;
	private String volume;
	private String condition;
	private String present;
	private String presenta;
	private String emballage;
	private String voieadmis1;
	private String voieadmis2;
	private String voieadmis3;
	private String voieadmis4;
	private String codeatc1;
	private String codeatc2;
	private String codeatc3;
	private String codeatc4;
	private String classme;
	private String atcdef;
	private String limitenbr;
	private String limitemj;
	private String tdc;
	private String tdcrecons;
	private String ddstma;
	private String dsunites;
	private String reconsnbr;
	private String reconsmjh;
	private String renouv;
	private String renouvmois;
	private String presunique;
	private String condspec;
	private String nmol;
	private String conddeliv;
	private String titulaire;
	private String fabricant;
	private String distribpha;
	private String distribgro;
	private String codepamm;
	private String importe;
	private String pays1;
	private String pays2;
	private String pays3;
	private String pays4;
	private String vigilan1;
	private String vigilan2;
	private String vigilan3;
	private String vigilan4;
	private String procedure;
	private String proceddate;
	private String cleancenr;
	private String clenouvenr;
	private String datedeb;
	private String cetat;
	private String datefin;
	private String datemem;
	private String etatmem1;
	private String cetatmem1;
	private String etatmem2;
	private String cetatmem2;
	private String lufexus;
	private String lufprix;
	private String lufinterv;
	private String lufrefer;
	private String lufb1recom;
	private String eurexusin;
	private String eurprix;
	private String eurinterv;
	private String eurrefer;
	private String eurb1recom;
	private String paysref;
	private String paysorig;
	private String taux;
	private String abatt;
	private String categorie;
	private String dateprix;
	private String etatprix;
	private String apcm;
	private String apcmcond;
	private String apcmdetail;
	private String cefipnum;
	private String cefipcbarr;
	private String cefipdenom;
	private String cefiprespo;
	private String cefprixluf;
	private String cefprixeur;
	private String cefpharluf;
	private String cefphareur;
	private String tva;
	private String nbcomp;
	private String comp1;
	private String cp11;
	private String cp12;
	private String cp13;
	private String cp14;
	private String cp15;
	private String comp2;
	private String cp21;
	private String cp22;
	private String cp23;
	private String cp24;
	private String cp25;
	private String comp3;
	private String cp31;
	private String cp32;
	private String cp33;
	private String cp34;
	private String cp35;
	private String comp4;
	private String cp41;
	private String cp42;
	private String cp43;
	private String cp44;
	private String cp45;
	private String comp5;
	private String cp51;
	private String cp52;
	private String cp53;
	private String cp54;
	private String cp55;
	private String comp6;
	private String cp61;
	private String cp62;
	private String cp63;
	private String cp64;
	private String cp65;
	private String comp7;
	private String cp71;
	private String cp72;
	private String cp73;
	private String cp74;
	private String cp75;
	private String comp8;
	private String cp81;
	private String cp82;
	private String cp83;
	private String cp84;
	private String cp85;
	private String comp9;
	private String cp91;
	private String cp92;
	private String cp93;
	private String cp94;
	private String cp95;
	private String comp10;
	private String cp101;
	private String cp102;
	private String cp103;
	private String cp104;
	private String cp105;
	private String denominati;

	// Constructors

	/** default constructor */
	public CefipDrugData() {
	}

//	/** minimal constructor */
//	public CefipDrugData(Integer id) {
//		m_id = id;
//	}


	@Column(name = "numnat", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getNumnat() {
		return this.numnat;
	}

	public void setNumnat(String numnat) {
		this.numnat = numnat;
	}

	@Column(name = "datehist", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getDatehist() {
		return this.datehist;
	}

	public void setDatehist(String datehist) {
		this.datehist = datehist;
	}

	@Column(name = "denom", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getDenom() {
		return this.denom;
	}

	public void setDenom(String denom) {
		this.denom = denom;
	}

	@Column(name = "formeclair", unique = false, nullable = true, insertable = true, updatable = true, length = 20)
	public String getFormeclair() {
		return this.formeclair;
	}

	public void setFormeclair(String formeclair) {
		this.formeclair = formeclair;
	}

	@Column(name = "dosageq1", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getDosageq1() {
		return this.dosageq1;
	}

	public void setDosageq1(String dosageq1) {
		this.dosageq1 = dosageq1;
	}

	@Column(name = "dosageu1", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDosageu1() {
		return this.dosageu1;
	}

	public void setDosageu1(String dosageu1) {
		this.dosageu1 = dosageu1;
	}

	@Column(name = "dosageqp1", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getDosageqp1() {
		return this.dosageqp1;
	}

	public void setDosageqp1(String dosageqp1) {
		this.dosageqp1 = dosageqp1;
	}

	@Column(name = "dosageup1", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDosageup1() {
		return this.dosageup1;
	}

	public void setDosageup1(String dosageup1) {
		this.dosageup1 = dosageup1;
	}

	@Column(name = "dosageq2", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getDosageq2() {
		return this.dosageq2;
	}

	public void setDosageq2(String dosageq2) {
		this.dosageq2 = dosageq2;
	}

	@Column(name = "dosageu2", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDosageu2() {
		return this.dosageu2;
	}

	public void setDosageu2(String dosageu2) {
		this.dosageu2 = dosageu2;
	}

	@Column(name = "dosageqp2", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getDosageqp2() {
		return this.dosageqp2;
	}

	public void setDosageqp2(String dosageqp2) {
		this.dosageqp2 = dosageqp2;
	}

	@Column(name = "dosageup2", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDosageup2() {
		return this.dosageup2;
	}

	public void setDosageup2(String dosageup2) {
		this.dosageup2 = dosageup2;
	}

	@Column(name = "piece", unique = false, nullable = true, insertable = true, updatable = true, length = 5)
	public String getPiece() {
		return this.piece;
	}

	public void setPiece(String piece) {
		this.piece = piece;
	}

	@Column(name = "larg", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getLarg() {
		return this.larg;
	}

	public void setLarg(String larg) {
		this.larg = larg;
	}

	@Column(name = "longu", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getLongu() {
		return this.longu;
	}

	public void setLongu(String longu) {
		this.longu = longu;
	}

	@Column(name = "poids", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getPoids() {
		return this.poids;
	}

	public void setPoids(String poids) {
		this.poids = poids;
	}

	@Column(name = "volume", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getVolume() {
		return this.volume;
	}

	public void setVolume(String volume) {
		this.volume = volume;
	}

	@Column(name = "condition", unique = false, nullable = true, insertable = true, updatable = true, length = 70)
	public String getCondition() {
		return this.condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	@Column(name = "present", unique = false, nullable = true, insertable = true, updatable = true, length = 30)
	public String getPresent() {
		return this.present;
	}

	public void setPresent(String present) {
		this.present = present;
	}

	@Column(name = "presenta", unique = false, nullable = true, insertable = true, updatable = true, length = 20)
	public String getPresenta() {
		return this.presenta;
	}

	public void setPresenta(String presenta) {
		this.presenta = presenta;
	}

	@Column(name = "emballage", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getEmballage() {
		return this.emballage;
	}

	public void setEmballage(String emballage) {
		this.emballage = emballage;
	}

	@Column(name = "voieadmis1", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getVoieadmis1() {
		return this.voieadmis1;
	}

	public void setVoieadmis1(String voieadmis1) {
		this.voieadmis1 = voieadmis1;
	}

	@Column(name = "voieadmis2", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getVoieadmis2() {
		return this.voieadmis2;
	}

	public void setVoieadmis2(String voieadmis2) {
		this.voieadmis2 = voieadmis2;
	}

	@Column(name = "voieadmis3", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getVoieadmis3() {
		return this.voieadmis3;
	}

	public void setVoieadmis3(String voieadmis3) {
		this.voieadmis3 = voieadmis3;
	}

	@Column(name = "voieadmis4", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getVoieadmis4() {
		return this.voieadmis4;
	}

	public void setVoieadmis4(String voieadmis4) {
		this.voieadmis4 = voieadmis4;
	}

	@Column(name = "codeatc1", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCodeatc1() {
		return this.codeatc1;
	}

	public void setCodeatc1(String codeatc1) {
		this.codeatc1 = codeatc1;
	}

	@Column(name = "codeatc2", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCodeatc2() {
		return this.codeatc2;
	}

	public void setCodeatc2(String codeatc2) {
		this.codeatc2 = codeatc2;
	}

	@Column(name = "codeatc3", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCodeatc3() {
		return this.codeatc3;
	}

	public void setCodeatc3(String codeatc3) {
		this.codeatc3 = codeatc3;
	}

	@Column(name = "codeatc4", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCodeatc4() {
		return this.codeatc4;
	}

	public void setCodeatc4(String codeatc4) {
		this.codeatc4 = codeatc4;
	}

	@Column(name = "classme", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getClassme() {
		return this.classme;
	}

	public void setClassme(String classme) {
		this.classme = classme;
	}

	@Column(name = "atcdef", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getAtcdef() {
		return this.atcdef;
	}

	public void setAtcdef(String atcdef) {
		this.atcdef = atcdef;
	}

	@Column(name = "limitenbr", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getLimitenbr() {
		return this.limitenbr;
	}

	public void setLimitenbr(String limitenbr) {
		this.limitenbr = limitenbr;
	}

	@Column(name = "limitemj", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getLimitemj() {
		return this.limitemj;
	}

	public void setLimitemj(String limitemj) {
		this.limitemj = limitemj;
	}

	@Column(name = "tdc", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getTdc() {
		return this.tdc;
	}

	public void setTdc(String tdc) {
		this.tdc = tdc;
	}

	@Column(name = "tdcrecons", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getTdcrecons() {
		return this.tdcrecons;
	}

	public void setTdcrecons(String tdcrecons) {
		this.tdcrecons = tdcrecons;
	}

	@Column(name = "ddstma", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getDdstma() {
		return this.ddstma;
	}

	public void setDdstma(String ddstma) {
		this.ddstma = ddstma;
	}

	@Column(name = "dsunites", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getDsunites() {
		return this.dsunites;
	}

	public void setDsunites(String dsunites) {
		this.dsunites = dsunites;
	}

	@Column(name = "reconsnbr", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getReconsnbr() {
		return this.reconsnbr;
	}

	public void setReconsnbr(String reconsnbr) {
		this.reconsnbr = reconsnbr;
	}

	@Column(name = "reconsmjh", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getReconsmjh() {
		return this.reconsmjh;
	}

	public void setReconsmjh(String reconsmjh) {
		this.reconsmjh = reconsmjh;
	}

	@Column(name = "renouv", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getRenouv() {
		return this.renouv;
	}

	public void setRenouv(String renouv) {
		this.renouv = renouv;
	}

	@Column(name = "renouvmois", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getRenouvmois() {
		return this.renouvmois;
	}

	public void setRenouvmois(String renouvmois) {
		this.renouvmois = renouvmois;
	}

	@Column(name = "presunique", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getPresunique() {
		return this.presunique;
	}

	public void setPresunique(String presunique) {
		this.presunique = presunique;
	}

	@Column(name = "condspec", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCondspec() {
		return this.condspec;
	}

	public void setCondspec(String condspec) {
		this.condspec = condspec;
	}

	@Column(name = "nmol", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getNmol() {
		return this.nmol;
	}

	public void setNmol(String nmol) {
		this.nmol = nmol;
	}

	@Column(name = "conddeliv", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getConddeliv() {
		return this.conddeliv;
	}

	public void setConddeliv(String conddeliv) {
		this.conddeliv = conddeliv;
	}

	@Column(name = "titulaire", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getTitulaire() {
		return this.titulaire;
	}

	public void setTitulaire(String titulaire) {
		this.titulaire = titulaire;
	}

	@Column(name = "fabricant", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getFabricant() {
		return this.fabricant;
	}

	public void setFabricant(String fabricant) {
		this.fabricant = fabricant;
	}

	@Column(name = "distribpha", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDistribpha() {
		return this.distribpha;
	}

	public void setDistribpha(String distribpha) {
		this.distribpha = distribpha;
	}

	@Column(name = "distribgro", unique = false, nullable = true, insertable = true, updatable = true, length = 6)
	public String getDistribgro() {
		return this.distribgro;
	}

	public void setDistribgro(String distribgro) {
		this.distribgro = distribgro;
	}

	@Column(name = "codepamm", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCodepamm() {
		return this.codepamm;
	}

	public void setCodepamm(String codepamm) {
		this.codepamm = codepamm;
	}

	@Column(name = "importe", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getImporte() {
		return this.importe;
	}

	public void setImporte(String importe) {
		this.importe = importe;
	}

	@Column(name = "pays1", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getPays1() {
		return this.pays1;
	}

	public void setPays1(String pays1) {
		this.pays1 = pays1;
	}

	@Column(name = "pays2", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getPays2() {
		return this.pays2;
	}

	public void setPays2(String pays2) {
		this.pays2 = pays2;
	}

	@Column(name = "pays3", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getPays3() {
		return this.pays3;
	}

	public void setPays3(String pays3) {
		this.pays3 = pays3;
	}

	@Column(name = "pays4", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getPays4() {
		return this.pays4;
	}

	public void setPays4(String pays4) {
		this.pays4 = pays4;
	}

	@Column(name = "vigilan1", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getVigilan1() {
		return this.vigilan1;
	}

	public void setVigilan1(String vigilan1) {
		this.vigilan1 = vigilan1;
	}

	@Column(name = "vigilan2", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getVigilan2() {
		return this.vigilan2;
	}

	public void setVigilan2(String vigilan2) {
		this.vigilan2 = vigilan2;
	}

	@Column(name = "vigilan3", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getVigilan3() {
		return this.vigilan3;
	}

	public void setVigilan3(String vigilan3) {
		this.vigilan3 = vigilan3;
	}

	@Column(name = "vigilan4", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getVigilan4() {
		return this.vigilan4;
	}

	public void setVigilan4(String vigilan4) {
		this.vigilan4 = vigilan4;
	}

	@Column(name = "procedure", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getProcedure() {
		return this.procedure;
	}

	public void setProcedure(String procedure) {
		this.procedure = procedure;
	}

	@Column(name = "proceddate", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getProceddate() {
		return this.proceddate;
	}

	public void setProceddate(String proceddate) {
		this.proceddate = proceddate;
	}

	@Column(name = "cleancenr", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCleancenr() {
		return this.cleancenr;
	}

	public void setCleancenr(String cleancenr) {
		this.cleancenr = cleancenr;
	}

	@Column(name = "clenouvenr", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getClenouvenr() {
		return this.clenouvenr;
	}

	public void setClenouvenr(String clenouvenr) {
		this.clenouvenr = clenouvenr;
	}

	@Column(name = "datedeb", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getDatedeb() {
		return this.datedeb;
	}

	public void setDatedeb(String datedeb) {
		this.datedeb = datedeb;
	}

	@Column(name = "cetat", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCetat() {
		return this.cetat;
	}

	public void setCetat(String cetat) {
		this.cetat = cetat;
	}

	@Column(name = "datefin", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getDatefin() {
		return this.datefin;
	}

	public void setDatefin(String datefin) {
		this.datefin = datefin;
	}

	@Column(name = "datemem", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getDatemem() {
		return this.datemem;
	}

	public void setDatemem(String datemem) {
		this.datemem = datemem;
	}

	@Column(name = "etatmem1", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getEtatmem1() {
		return this.etatmem1;
	}

	public void setEtatmem1(String etatmem1) {
		this.etatmem1 = etatmem1;
	}

	@Column(name = "cetatmem1", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCetatmem1() {
		return this.cetatmem1;
	}

	public void setCetatmem1(String cetatmem1) {
		this.cetatmem1 = cetatmem1;
	}

	@Column(name = "etatmem2", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getEtatmem2() {
		return this.etatmem2;
	}

	public void setEtatmem2(String etatmem2) {
		this.etatmem2 = etatmem2;
	}

	@Column(name = "cetatmem2", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCetatmem2() {
		return this.cetatmem2;
	}

	public void setCetatmem2(String cetatmem2) {
		this.cetatmem2 = cetatmem2;
	}

	@Column(name = "lufexus", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getLufexus() {
		return this.lufexus;
	}

	public void setLufexus(String lufexus) {
		this.lufexus = lufexus;
	}

	@Column(name = "lufprix", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getLufprix() {
		return this.lufprix;
	}

	public void setLufprix(String lufprix) {
		this.lufprix = lufprix;
	}

	@Column(name = "lufinterv", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getLufinterv() {
		return this.lufinterv;
	}

	public void setLufinterv(String lufinterv) {
		this.lufinterv = lufinterv;
	}

	@Column(name = "lufrefer", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getLufrefer() {
		return this.lufrefer;
	}

	public void setLufrefer(String lufrefer) {
		this.lufrefer = lufrefer;
	}

	@Column(name = "lufb1recom", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getLufb1recom() {
		return this.lufb1recom;
	}

	public void setLufb1recom(String lufb1recom) {
		this.lufb1recom = lufb1recom;
	}

	@Column(name = "eurexusin", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getEurexusin() {
		return this.eurexusin;
	}

	public void setEurexusin(String eurexusin) {
		this.eurexusin = eurexusin;
	}

	@Column(name = "eurprix", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getEurprix() {
		return this.eurprix;
	}

	public void setEurprix(String eurprix) {
		this.eurprix = eurprix;
	}

	@Column(name = "eurinterv", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getEurinterv() {
		return this.eurinterv;
	}

	public void setEurinterv(String eurinterv) {
		this.eurinterv = eurinterv;
	}

	@Column(name = "eurrefer", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getEurrefer() {
		return this.eurrefer;
	}

	public void setEurrefer(String eurrefer) {
		this.eurrefer = eurrefer;
	}

	@Column(name = "eurb1recom", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getEurb1recom() {
		return this.eurb1recom;
	}

	public void setEurb1recom(String eurb1recom) {
		this.eurb1recom = eurb1recom;
	}

	@Column(name = "paysref", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getPaysref() {
		return this.paysref;
	}

	public void setPaysref(String paysref) {
		this.paysref = paysref;
	}

	@Column(name = "paysorig", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getPaysorig() {
		return this.paysorig;
	}

	public void setPaysorig(String paysorig) {
		this.paysorig = paysorig;
	}

	@Column(name = "taux", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getTaux() {
		return this.taux;
	}

	public void setTaux(String taux) {
		this.taux = taux;
	}

	@Column(name = "abatt", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getAbatt() {
		return this.abatt;
	}

	public void setAbatt(String abatt) {
		this.abatt = abatt;
	}

	@Column(name = "categorie", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCategorie() {
		return this.categorie;
	}

	public void setCategorie(String categorie) {
		this.categorie = categorie;
	}

	@Column(name = "dateprix", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public String getDateprix() {
		return this.dateprix;
	}

	public void setDateprix(String dateprix) {
		this.dateprix = dateprix;
	}

	@Column(name = "etatprix", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getEtatprix() {
		return this.etatprix;
	}

	public void setEtatprix(String etatprix) {
		this.etatprix = etatprix;
	}

	@Column(name = "apcm", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getApcm() {
		return this.apcm;
	}

	public void setApcm(String apcm) {
		this.apcm = apcm;
	}

	@Column(name = "apcmcond", unique = false, nullable = true, insertable = true, updatable = true, length = 1)
	public String getApcmcond() {
		return this.apcmcond;
	}

	public void setApcmcond(String apcmcond) {
		this.apcmcond = apcmcond;
	}

	@Column(name = "apcmdetail", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getApcmdetail() {
		return this.apcmdetail;
	}

	public void setApcmdetail(String apcmdetail) {
		this.apcmdetail = apcmdetail;
	}

	@Column(name = "cefipnum", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCefipnum() {
		return this.cefipnum;
	}

	public void setCefipnum(String cefipnum) {
		this.cefipnum = cefipnum;
	}

	@Column(name = "cefipcbarr", unique = false, nullable = true, insertable = true, updatable = true, length = 13)
	public String getCefipcbarr() {
		return this.cefipcbarr;
	}

	public void setCefipcbarr(String cefipcbarr) {
		this.cefipcbarr = cefipcbarr;
	}

	@Column(name = "cefipdenom", unique = false, nullable = true, insertable = true, updatable = true, length = 40)
	public String getCefipdenom() {
		return this.cefipdenom;
	}

	public void setCefipdenom(String cefipdenom) {
		this.cefipdenom = cefipdenom;
	}

	@Column(name = "cefiprespo", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getCefiprespo() {
		return this.cefiprespo;
	}

	public void setCefiprespo(String cefiprespo) {
		this.cefiprespo = cefiprespo;
	}

	@Column(name = "cefprixluf", unique = false, nullable = true, insertable = true, updatable = true, length = 7)
	public String getCefprixluf() {
		return this.cefprixluf;
	}

	public void setCefprixluf(String cefprixluf) {
		this.cefprixluf = cefprixluf;
	}

	@Column(name = "cefprixeur", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCefprixeur() {
		return this.cefprixeur;
	}

	public void setCefprixeur(String cefprixeur) {
		this.cefprixeur = cefprixeur;
	}

	@Column(name = "cefpharluf", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCefpharluf() {
		return this.cefpharluf;
	}

	public void setCefpharluf(String cefpharluf) {
		this.cefpharluf = cefpharluf;
	}

	@Column(name = "cefphareur", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCefphareur() {
		return this.cefphareur;
	}

	public void setCefphareur(String cefphareur) {
		this.cefphareur = cefphareur;
	}

	@Column(name = "tva", unique = false, nullable = true, insertable = true, updatable = true, length = 4)
	public String getTva() {
		return this.tva;
	}

	public void setTva(String tva) {
		this.tva = tva;
	}

	@Column(name = "nbcomp", unique = false, nullable = true, insertable = true, updatable = true, length = 2)
	public String getNbcomp() {
		return this.nbcomp;
	}

	public void setNbcomp(String nbcomp) {
		this.nbcomp = nbcomp;
	}

	@Column(name = "comp1", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp1() {
		return this.comp1;
	}

	public void setComp1(String comp1) {
		this.comp1 = comp1;
	}

	@Column(name = "cp11", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp11() {
		return this.cp11;
	}

	public void setCp11(String cp11) {
		this.cp11 = cp11;
	}

	@Column(name = "cp12", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp12() {
		return this.cp12;
	}

	public void setCp12(String cp12) {
		this.cp12 = cp12;
	}

	@Column(name = "cp13", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp13() {
		return this.cp13;
	}

	public void setCp13(String cp13) {
		this.cp13 = cp13;
	}

	@Column(name = "cp14", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp14() {
		return this.cp14;
	}

	public void setCp14(String cp14) {
		this.cp14 = cp14;
	}

	@Column(name = "cp15", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp15() {
		return this.cp15;
	}

	public void setCp15(String cp15) {
		this.cp15 = cp15;
	}

	@Column(name = "comp2", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp2() {
		return this.comp2;
	}

	public void setComp2(String comp2) {
		this.comp2 = comp2;
	}

	@Column(name = "cp21", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp21() {
		return this.cp21;
	}

	public void setCp21(String cp21) {
		this.cp21 = cp21;
	}

	@Column(name = "cp22", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp22() {
		return this.cp22;
	}

	public void setCp22(String cp22) {
		this.cp22 = cp22;
	}

	@Column(name = "cp23", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp23() {
		return this.cp23;
	}

	public void setCp23(String cp23) {
		this.cp23 = cp23;
	}

	@Column(name = "cp24", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp24() {
		return this.cp24;
	}

	public void setCp24(String cp24) {
		this.cp24 = cp24;
	}

	@Column(name = "cp25", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp25() {
		return this.cp25;
	}

	public void setCp25(String cp25) {
		this.cp25 = cp25;
	}

	@Column(name = "comp3", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp3() {
		return this.comp3;
	}

	public void setComp3(String comp3) {
		this.comp3 = comp3;
	}

	@Column(name = "cp31", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp31() {
		return this.cp31;
	}

	public void setCp31(String cp31) {
		this.cp31 = cp31;
	}

	@Column(name = "cp32", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp32() {
		return this.cp32;
	}

	public void setCp32(String cp32) {
		this.cp32 = cp32;
	}

	@Column(name = "cp33", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp33() {
		return this.cp33;
	}

	public void setCp33(String cp33) {
		this.cp33 = cp33;
	}

	@Column(name = "cp34", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp34() {
		return this.cp34;
	}

	public void setCp34(String cp34) {
		this.cp34 = cp34;
	}

	@Column(name = "cp35", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp35() {
		return this.cp35;
	}

	public void setCp35(String cp35) {
		this.cp35 = cp35;
	}

	@Column(name = "comp4", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp4() {
		return this.comp4;
	}

	public void setComp4(String comp4) {
		this.comp4 = comp4;
	}

	@Column(name = "cp41", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp41() {
		return this.cp41;
	}

	public void setCp41(String cp41) {
		this.cp41 = cp41;
	}

	@Column(name = "cp42", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp42() {
		return this.cp42;
	}

	public void setCp42(String cp42) {
		this.cp42 = cp42;
	}

	@Column(name = "cp43", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp43() {
		return this.cp43;
	}

	public void setCp43(String cp43) {
		this.cp43 = cp43;
	}

	@Column(name = "cp44", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp44() {
		return this.cp44;
	}

	public void setCp44(String cp44) {
		this.cp44 = cp44;
	}

	@Column(name = "cp45", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp45() {
		return this.cp45;
	}

	public void setCp45(String cp45) {
		this.cp45 = cp45;
	}

	@Column(name = "comp5", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp5() {
		return this.comp5;
	}

	public void setComp5(String comp5) {
		this.comp5 = comp5;
	}

	@Column(name = "cp51", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp51() {
		return this.cp51;
	}

	public void setCp51(String cp51) {
		this.cp51 = cp51;
	}

	@Column(name = "cp52", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp52() {
		return this.cp52;
	}

	public void setCp52(String cp52) {
		this.cp52 = cp52;
	}

	@Column(name = "cp53", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp53() {
		return this.cp53;
	}

	public void setCp53(String cp53) {
		this.cp53 = cp53;
	}

	@Column(name = "cp54", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp54() {
		return this.cp54;
	}

	public void setCp54(String cp54) {
		this.cp54 = cp54;
	}

	@Column(name = "cp55", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp55() {
		return this.cp55;
	}

	public void setCp55(String cp55) {
		this.cp55 = cp55;
	}

	@Column(name = "comp6", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp6() {
		return this.comp6;
	}

	public void setComp6(String comp6) {
		this.comp6 = comp6;
	}

	@Column(name = "cp61", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp61() {
		return this.cp61;
	}

	public void setCp61(String cp61) {
		this.cp61 = cp61;
	}

	@Column(name = "cp62", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp62() {
		return this.cp62;
	}

	public void setCp62(String cp62) {
		this.cp62 = cp62;
	}

	@Column(name = "cp63", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp63() {
		return this.cp63;
	}

	public void setCp63(String cp63) {
		this.cp63 = cp63;
	}

	@Column(name = "cp64", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp64() {
		return this.cp64;
	}

	public void setCp64(String cp64) {
		this.cp64 = cp64;
	}

	@Column(name = "cp65", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp65() {
		return this.cp65;
	}

	public void setCp65(String cp65) {
		this.cp65 = cp65;
	}

	@Column(name = "comp7", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp7() {
		return this.comp7;
	}

	public void setComp7(String comp7) {
		this.comp7 = comp7;
	}

	@Column(name = "cp71", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp71() {
		return this.cp71;
	}

	public void setCp71(String cp71) {
		this.cp71 = cp71;
	}

	@Column(name = "cp72", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp72() {
		return this.cp72;
	}

	public void setCp72(String cp72) {
		this.cp72 = cp72;
	}

	@Column(name = "cp73", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp73() {
		return this.cp73;
	}

	public void setCp73(String cp73) {
		this.cp73 = cp73;
	}

	@Column(name = "cp74", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp74() {
		return this.cp74;
	}

	public void setCp74(String cp74) {
		this.cp74 = cp74;
	}

	@Column(name = "cp75", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp75() {
		return this.cp75;
	}

	public void setCp75(String cp75) {
		this.cp75 = cp75;
	}

	@Column(name = "comp8", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp8() {
		return this.comp8;
	}

	public void setComp8(String comp8) {
		this.comp8 = comp8;
	}

	@Column(name = "cp81", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp81() {
		return this.cp81;
	}

	public void setCp81(String cp81) {
		this.cp81 = cp81;
	}

	@Column(name = "cp82", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp82() {
		return this.cp82;
	}

	public void setCp82(String cp82) {
		this.cp82 = cp82;
	}

	@Column(name = "cp83", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp83() {
		return this.cp83;
	}

	public void setCp83(String cp83) {
		this.cp83 = cp83;
	}

	@Column(name = "cp84", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp84() {
		return this.cp84;
	}

	public void setCp84(String cp84) {
		this.cp84 = cp84;
	}

	@Column(name = "cp85", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp85() {
		return this.cp85;
	}

	public void setCp85(String cp85) {
		this.cp85 = cp85;
	}

	@Column(name = "comp9", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp9() {
		return this.comp9;
	}

	public void setComp9(String comp9) {
		this.comp9 = comp9;
	}

	@Column(name = "cp91", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp91() {
		return this.cp91;
	}

	public void setCp91(String cp91) {
		this.cp91 = cp91;
	}

	@Column(name = "cp92", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp92() {
		return this.cp92;
	}

	public void setCp92(String cp92) {
		this.cp92 = cp92;
	}

	@Column(name = "cp93", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp93() {
		return this.cp93;
	}

	public void setCp93(String cp93) {
		this.cp93 = cp93;
	}

	@Column(name = "cp94", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp94() {
		return this.cp94;
	}

	public void setCp94(String cp94) {
		this.cp94 = cp94;
	}

	@Column(name = "cp95", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp95() {
		return this.cp95;
	}

	public void setCp95(String cp95) {
		this.cp95 = cp95;
	}

	@Column(name = "comp10", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getComp10() {
		return this.comp10;
	}

	public void setComp10(String comp10) {
		this.comp10 = comp10;
	}

	@Column(name = "cp101", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp101() {
		return this.cp101;
	}

	public void setCp101(String cp101) {
		this.cp101 = cp101;
	}

	@Column(name = "cp102", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp102() {
		return this.cp102;
	}

	public void setCp102(String cp102) {
		this.cp102 = cp102;
	}

	@Column(name = "cp103", unique = false, nullable = true, insertable = true, updatable = true, length = 3)
	public String getCp103() {
		return this.cp103;
	}

	public void setCp103(String cp103) {
		this.cp103 = cp103;
	}

	@Column(name = "cp104", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getCp104() {
		return this.cp104;
	}

	public void setCp104(String cp104) {
		this.cp104 = cp104;
	}

	@Column(name = "cp105", unique = false, nullable = true, insertable = true, updatable = true, length = 9)
	public String getCp105() {
		return this.cp105;
	}

	public void setCp105(String cp105) {
		this.cp105 = cp105;
	}

	@Column(name = "denominati", unique = false, nullable = true, insertable = true, updatable = true)
	public String getDenominati() {
		return this.denominati;
	}

	public void setDenominati(String denominati) {
		this.denominati = denominati;
	}

}
