/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: CefipManufacturer.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IManufacturer;

/**
 * Implementation of the IManufacturer interface for CEFIP manufacturers.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 13.02.2007
 * 11:57:14
 *
 *
 * @version
 * <br>$Log: CefipManufacturer.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
@Entity
@Table(name="cefip_manufacturer", schema="prescription")
public class CefipManufacturer implements IManufacturer{

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/* ------------------------------------------------------- */
	private Integer id;
	private String name;
	private String street;
	private String city;
	/* ------------------------------------------------------- */
	private String number;

	/* #########################################################################
	 * Additional methods for cefip manufacturers
	 *
	 * ######################################################################### */
	/**
	 * @return the number
	 */
	@Column(name="num")
	public String getNumber() {
		return number;
	}
	/**
	 * @param number the number to set
	 */
	public void setNumber(String number) {
		this.number = number;
	}


	/* #########################################################################
	 * Methods from the interface IManufacturer
	 *
	 * ######################################################################### */


	/**
	 * @return the city
	 */
	@Column(name="ad2")
	public String getCity() {
		return city;
	}
	/**
	 * @param city the city to set
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/* ------------------------------------------------------- */
	/**
	 * @return the id
	 */
	@Id
	@Column(name="id")
	public Integer getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/* ------------------------------------------------------- */
	/**
	 * @return the name
	 */
	@Column(name="nom")
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/* ------------------------------------------------------- */
	/**
	 * @return the street
	 */
	@Column(name="ad1")
	public String getStreet() {
		return street;
	}
	/**
	 * @param street the street to set
	 */
	public void setStreet(String street) {
		this.street = street;
	}





}
