/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses;

import java.io.Serializable;
import java.util.List;

/**
 *
 * The DrugLight dataclass should be used to transfer data of
 * drug lists from server to the client to keep the amount of
 * java object data as small as possible and to gain access
 * to drugs and drug lists.
 *
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *@version
 *$LOG
 *
 */
public class DrugLight implements Serializable, Comparable<DrugLight> {

    /**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * The id of the appropriate Drug object
	 */
	private Integer drugId;

    /**
     * The name that should be displayed
     */
    private String name;

    /**
     * The id of the list the drug comes from
     * for backtracking.
     */
    private Integer listId;

    /**
     * The form of the drug, pill, gel, injection etc
     */
    private String form;


    /**
     * List of subTypes of a drug, e.g. Aspirin [500, 1000, cmp, etc]
     */

    private List<DrugLight> subTypes;

//    private LinkedHashMap<String, DrugLight> subTypes;
//    private LinkedHashMap<String, DrugLight> subTypeHashMap;


    /* *************************************************** */
    /*          Getter/ Setter                             */

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getDrugId() {
        return drugId;
    }

    public void setDrugId(Integer drugId) {
        this.drugId = drugId;
    }

    /**
	 * @return Returns the listId.
	 */
	public Integer getListId() {
		return listId;
	}

	/**
	 * @param listId The listId to set.
	 */
	public void setListId(Integer listId) {
		this.listId = listId;
	}

	/**
	 * @return the option
	 */
	public String getForm() {
		return form;
	}

	/**
	 * @param option the option to set
	 */
	public void setForm(String option) {
		this.form = option;
	}



	/* ------------------------------------------------------
	 * subTypes
	 *
	 * Each subType is another DrugLight object.
	 *
	 * ------------------------------------------------------ */
	/**
	 * @return the subTypes
	 */
	public List<DrugLight> getSubTypes() {
		return subTypes;
	}

	/**
	 * @param subTypes the subTypes to set
	 */
	public void setSubTypes(List<DrugLight> subTypes) {
		this.subTypes = subTypes;
	}


//	/**
//	 * @return the subTypeHashMap
//	 */
//	public LinkedHashMap<String, DrugLight> getSubTypeHashMap() {
//		return subTypeHashMap;
//	}
//
//	/**
//	 * @param subTypeHashMap the subTypeHashMap to set
//	 */
//	public void setSubTypeHashMap(LinkedHashMap<String, DrugLight> subTypeHashMap) {
//		this.subTypeHashMap = subTypeHashMap;
//	}

	/**
     * Compares the given object with this
     *
     * @param o
     * @return
     */
    public int compareTo(DrugLight o) {
        /* =========================================================== */
        return this.getName().compareTo(getName());

//        if (this.getDrugId().intValue() < o.getDrugId().intValue())
//            return -1;
//        if (this.getDrugId().intValue() == o.getDrugId().intValue())
//            return 0;
//        else
//            return 1;
        /* =========================================================== */
    }



}
