/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.drug.lists.cefip;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.AtcClass;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.DrugList;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip.CefipDrugData;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip.CefipManufacturerData;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;

/**
 *
 * SessionBean for the Cefip Drug list.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: CefipDrugManager.java,v $
 * <br>Revision 1.7  2013-02-22 08:46:50  kutscheid
 * <br>remove the tupel classes (please redeploy)
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 07:43:04  heinemann
 * <br>son doku
 * <br>
 * <br>Revision 1.4  2007/03/02 08:28:45  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.3.2.4  2007/02/21 10:00:40  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3.2.3  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 * <br>Revision 1.3.2.2  2007/01/19 10:36:34  heinemann
 * <br>cleaning
 * <br>
 * <br>Revision 1.3.2.1  2006/12/19 14:51:50  heinemann
 * <br>printing etc
 * <br>
 * <br>Revision 1.3  2006/09/13 12:01:00  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2006/09/11 14:40:25  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 */
@Remote
public interface CefipDrugManager {


	public static final String LIST_NAME = "CEFIP List";


	/**
	 * Save the given CefipManufacturer entity
	 *
	 * @param manufacturer
	 */
	public void saveManufacturerData(CefipManufacturerData manufacturer);


	/**
	 * Save the CefipDrugData
	 *
	 * @param drugData
	 */
	public void saveImportDrug(CefipDrugData drugData);


	/**
	 * Returns the current list id
	 *
	 * @return
	 */
	public Integer getListId();

	/**
	 * Returnt the DrugList for this drug list =)
	 *
	 * @return
	 */
	public DrugList getList();

	/**
	 * Save a date for the list.
	 *
	 * @param date
	 */
	public void saveListDate(Date date);

	/**
	 * Delete all manufactueres.<br/>
	 * Can take quite a long time.
	 */
	public void deleteAllManufacturer();

	/**
	 * Delete all cefip drugs.<br/>
	 * This takes a very long time!
	 */
	public void deleteAllCefipDrugData();


	/**
	 * Returns the row counts of the manufacturers and the cefip drugs
	 * in an ArrayList object
	 *
	 * @return
	 */
	public ArrayList<Integer> getListCounts();


	/**
	 * creates the parent -> child connection between two atc classes
	 * Must be done after all classes have been imported, because
	 * they do not come in the alphabetical order
	 */
	public void connectAtcClasses();

	/**
	 * Saves an CefipAtcClass entity
	 *
	 * @param atc
	 */
	public void saveImportedCefipAtcClass(AtcClass atc);

	/**
	 * Delets all available CefipAtcClasses from the database
	 */
	public void deleteAllCefipAtcClasses();


	/**
	 * @param pattern
	 * @param limit
	 * @return
	 */
	public List<DrugLight> getLightDrugsByNamePattern(String pattern, Integer limit);




	/**
	 * Returns a list of IDrug objects
	 * 
	 * @param start
	 * @param pageSize
	 * @return
	 */
	public List<IDrug> getDrugs(Integer start,Integer pageSize);


}
