/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Feb 3, 2005
 *
 */
package lu.tudor.santec.gecamed.prescription.gui;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;

/**
 * a Class that manages all Icons shown in the prescription module. it provides methods
 * that return different icon-sizes by a given Icon-String
 *
 * @author Johannes Hermen johannes.hermen
 */
public class PrescriptionIcons
{
    //~ Static fields/initializers =============================================


    /**
     * the path to find the Icons in.
     */
    private static final int LARGEPIX = 90;
    
    public static final String DELETE = "delete.png";
    public static final String DELETE_DRUG = "deletedrug.png";
    
    // Prescription add-on
    public static final String EDIT_LIST = "kgpg_edit.png";
    public static final String ADD_ITEM = "edit_add.png";
    public static final String REMOVE_ITEM = "edit_remove.png";
    
    public static final String PRESCRIPTION_MODULE = "presc_module.png";
    public static final String RED_CROSS = "kcmdrkonqi.png";
    public static final String INFORMATION = "messagebox_info.png";
    public static final String NEW_FILE = "filenew.png";
    public static final String COPY = "editcopy.png";
    public static final String DRUG_INFO = "icn_logo.png";
    public static final String CLOSE = "cancel.png";
    
    public static final String PRSC_BIO 	= "presc_bio2.png";
    public static final String PRSC_DRUG 	= "presc_drug.png";
    public static final String PRSC_ORTHO 	= "presc_ortho.png";
    public static final String PRSC_PHYSIO 	= "presc_physio.png";
    public static final String PRSC_RADIO 	= "presc_radio.png";
    public static final String PRSC_NURSE 	= "presc_nurse.png";
    public static final String PRSC_CERT 	= "presc_certificate.png";
    public static final String PRSC_TRANS 	= "presc_transfer.png";
    
    public static final String SUBSTANCE = "kalzium.png";
    
    public static final String TEMPLATES = "kfig.png";
    public static final String SAVE_NEW_TEMPLATE ="newtemplate.png";
    
    public static final String NEXT = "next.png";
    
    public static final String ICON_LOAD = "revert.png";
    public static final String ICON_PRINT = "fileprint.png";
    public static final String ICON_BOOKMARKS = "bookmark_folder.png";
    public static final String ICON_CONTROLTAB = "configure.png";
    public static final String ICON_FONTS = "fonts.png";
    public static final String ICON_INFO = "messagebox_info.png";
    
    public static final String ICON_FORWARD = "player_play.png";
    public static final String ICON_FORWARD_10 = "player_fwd.png";
    public static final String ICON_TO_END = "player_end.png";
    public static final String ICON_REWIND = "player_play_back.png";
    public static final String ICON_REWIND_10 = "player_rev.png";
    public static final String ICON_TO_START = "player_start.png";
    
    
    public static final String BUTTON_UNDO = "button_undo.png";
    public static final String BUTTON_OK = "button_ok.png";
    public static final String BUTTON_CANCEL = "button_cancel.png";
    public static final String BUTTON_RUNNING = "button_running.png";
    public static final String BUTTON_ADD_LINE = "button_add_line.png";
    public static final String BUTTON_DELETE_LINE = "button_delete_line.png";
    
    public static final String ERROR = "cancel.png";
    
    public static final String PRINT ="print.png";
    public static final String PRINT_EMPTY ="print_empty.png";
	public static final String ANTECEDENT = "antecedent.png";
	
	public static final String REPRESCRIBE = "represcribe.png";
    
    public static final String CHRONIC = "chronical.png";
	
	public static final String HISTORY = "history_lists.png";
	
	public static final String RESIZE_WINDOW = "resize_view.png";
	public static final String CEFIP_ICON = "cefip_icon.png";
	
	public static final String PRIVATE_ICON = "private.png";
	public static final String PRIVATE_ICON_SMALL = "private_tiny.png";
	
	public static final String PUBLIC_ICON = "public.png";
	public static final String PUBLIC_ICON_SMALL = "public_tiny.png";
	

    //~ Methods ================================================================
    
	public static ImageIcon getIcon(String iconName) {
	    return IconFetcher.getIcon(PrescriptionIcons.class, iconName);
	}

	public static ImageIcon getMiniIcon(String iconName) {
	    return IconFetcher.getMiniIcon(PrescriptionIcons.class, iconName);
	}

	public static ImageIcon getSmallIcon(String iconName) {
	    return IconFetcher.getSmallIcon(PrescriptionIcons.class, iconName);
	}

	public static ImageIcon getMediumIcon(String iconName) {
	    return IconFetcher.getMediumIcon(PrescriptionIcons.class, iconName);
	}

	public static ImageIcon getBigIcon(String iconName) {
		return getScaledIcon(iconName, LARGEPIX);
	}

	public static ImageIcon getScaledIcon(String iconName, int size) {
	    return IconFetcher.getScaledIcon(PrescriptionIcons.class, iconName, size);
	}
	
	
	
	// --------------------
    
	
	
	/**
	 * Returns an Icon for a prescriptintype id
	 * to ensure, that every type has the same icon
	 * regardless where it is displayed
	 * 
	 * @param id
	 * @return
	 */
	public static ImageIcon getPrescriptionTypeIcon(Integer id) {
		/* ================================================== */
		String iconName = "";
		switch(id) {
			case 1:
				iconName = PrescriptionIcons.PRSC_DRUG;
				break;
			case 2:
				iconName = PrescriptionIcons.PRSC_BIO;
				break;
			case 3:
				iconName = PrescriptionIcons.PRSC_RADIO;
				break;
			case 4:
				iconName = PrescriptionIcons.PRSC_PHYSIO;
				break;
			case 5:
				iconName = PrescriptionIcons.PRSC_NURSE;
				break;
			case 6:
				iconName = PrescriptionIcons.PRSC_ORTHO;
				break;
		}
		if (!iconName.equals("")) {
			return PrescriptionIcons.getSmallIcon(iconName);
		}
		else 
			return new ImageIcon();
	/* ================================================== */
	}
    
    
//    /**
//     * returns the spezified icon as Image
//     *
//     * @param name the name of the icon
//     * @return the Image
//     */
//    public static Image createImage(String name)
//    {
//        String imgURL = PATH + name;
//        Image ii = new ImageIcon(imgURL).getImage();
//        if (ii != null) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//
//    /**
//     * returns the spezified icon as standart ImageIcon
//     *
//     * @param name the name of the icon
//     * @return the ImageIcon
//     */
//    public static ImageIcon createImageIcon(String name)
//    {
//        String imgURL = PATH + name;
//        ImageIcon ii = new ImageIcon(imgURL);
//        if (ii.getIconHeight() > 0) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//    
//    
//    /**
//     * returns a large version of the icon (24x24px)
//     *
//     * @param name the name of the icon
//     * @return the ImageIcon
//     */
//    public static ImageIcon createLargeImageIcon(String name)
//    {
//        String imgURL = PATH + name;
//        ImageIcon ii = new ImageIcon((new ImageIcon(imgURL)).getImage()
//                                      .getScaledInstance(LARGEPIX, LARGEPIX,
//                    Image.SCALE_SMOOTH));
//        if (ii.getIconHeight() > 0) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//    
//    
//    /**
//     * returns a medium version of the icon (24x24px)
//     *
//     * @param name the name of the icon
//     * @return the ImageIcon
//     */
//    public static ImageIcon createMediumImageIcon(String name)
//    {
//        String imgURL = PATH + name;
//        ImageIcon ii = new ImageIcon((new ImageIcon(imgURL)).getImage()
//                                      .getScaledInstance(MEDIPIX, MEDIPIX,
//                    Image.SCALE_SMOOTH));
//        if (ii.getIconHeight() > 0) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//
//    /**
//     * returns a very small version of the icon (12x12px)
//     *
//     * @param name the name of the icon
//     * @return the ImageIcon
//     */
//    public static ImageIcon createMiniImageIcon(String name)
//    {
//        String imgURL = PATH + name;
//        ImageIcon ii = new ImageIcon((new ImageIcon(imgURL)).getImage()
//                                      .getScaledInstance(MINIPIX, MINIPIX,
//                    Image.SCALE_SMOOTH));
//        if (ii.getIconHeight() > 0) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//
//    /**
//     * returns a small version of the icon (16x16px)
//     *
//     * @param name the name of the icon
//     * @return the ImageIcon
//     */
//    public static ImageIcon createSmallImageIcon(String name)
//    {
//        String imgURL = PATH + name;
//        ImageIcon ii = new ImageIcon((new ImageIcon(imgURL)).getImage()
//                                      .getScaledInstance(SMALLPIX, SMALLPIX,
//                    Image.SCALE_SMOOTH));
//        if (ii.getIconHeight() > 0) {
//            return ii;
//        }
//        logger.warn("Couldn't find file: " + imgURL);
//        return null;
//    }
//    
//    public static ImageIcon getIcon(String iconname, int size) {
//        
//        String imgURL = PATH + iconname;
//        
//        if (imgURL != null) {
//            return new ImageIcon(new ImageIcon(imgURL).getImage().getScaledInstance(size,size,Image.SCALE_SMOOTH));
//        } else {
//            logger.warn("Missing Icon: " + iconname);
//        }
//        return null;
//    }
    
    
}
