/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.actionhandler;

import java.awt.event.ActionEvent;
import java.util.List;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.incident.IncidentPanel;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;
import lu.tudor.santec.gecamed.prescription.ejb.session.beans.PrescriptionManagerBean;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.PrescriptionManager;
import lu.tudor.santec.gecamed.prescription.gui.editor.PrescriptionDataModel;
import lu.tudor.santec.i18n.Translatrix;

/**
 * buttonaction modify in the right-click-popup of PrescriptionHistoryView
 *  
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PrescriptionEntryModifyAction.java,v $
 * <br>Revision 1.2  2010-05-27 15:11:08  troth
 * <br>fix bug - Action Modify and Represcribe
 * <br>
 * <br>Revision 1.1  2010-04-26 16:35:54  troth
 * <br>Redesign of the prescription view
 * <br>
 */
public class PrescriptionEntryModifyAction extends AEntryAction {

	private static final long serialVersionUID = 1L;

	private IncidentEntry entry2Modify;

	private PrescriptionManager manager;
		
	private PrescriptionDataModel prescriptionDataModel;

	public PrescriptionEntryModifyAction() {
		super(Translatrix.getTranslationString("prescription.buttons.edit"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.EDIT));
		
		this.manager = (PrescriptionManager) ManagerFactory.getRemote(PrescriptionManagerBean.class);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.listener.AEntryAction#setEntry(lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public void setEntry(IncidentEntry entry) {
		this.entry2Modify = entry;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		List<Prescription> presc = manager.getPrescriptionByIncidentEntry(entry2Modify.getId());
		
		this.prescriptionDataModel = PatientManagerModule.getInstance().getPatientPanel().getPrescriptionDataModel();
		
		if (presc != null && presc.size()>0) {
			
			Prescription p = presc.get(0);
			
			PatientManagerModule.getInstance().getPatientPanel().showPanel(IncidentPanel.name);
			
			this.prescriptionDataModel.setPrescription(p);
		
		}
	}
}
