/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.drug;

import java.util.List;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;

/**
 * Interface for all modules that want to be a drug list.
 * The different drug lists can be accessed by classes that implement this interface.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: IDrugListModule.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:58:55  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.4  2007/02/21 10:00:40  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.3  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 * <br>Revision 1.1.2.2  2007/01/19 10:36:34  heinemann
 * <br>cleaning
 * <br>
 * <br>Revision 1.1.2.1  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.1  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 */
public interface IDrugListModule {



	/**
	 * Returns the name of the module
	 *
	 * @return
	 */
	public String getModuleName();


	/**
	 * Returns the id of the drug list
	 *
	 * @return
	 */
	public Integer getListId();



	/**
	 * returns the name of the drug list<br>
	 * its the name that is stored in the drug_lists table
	 *
	 * @return
	 */
	public String getListName();



	/**
	 * Returns a list of the options, that will be
	 * shipped with the IDrug objects from this module.
	 *
	 * @return
	 */
	public List<String> getOptions();

	/**
	 * Returns drug matching to the given name
	 *
	 * @param name can also be a pattern
	 * @return a Drug object
	 */
	public IDrug getDrugByName(String name);


	/**
	 * Returns the drug for the given id.
	 *
	 *
	 * @param id
	 * @return null if none was found
	 */
//	public IDrug getDrugById(Integer id);


	/**
	 * Returns a list of Drugs that all have the given substance
	 *
	 * @param id
	 * @return List of Drugs. Empty list if no drug includes this substance
	 */
	public List<IDrug> getDrugsBySubstanceId(Integer id);


	/**
	 * Returns a list of Drugs beginning at position "start"
	 * with the length "pageSize"
	 *
	 * @param start
	 * @param pageSize
	 * @return
	 */
	public List<IDrug> getDrugs(Integer start, Integer pageSize);

	/**
	 * Returns a list of DrugLight objects matching to the given pattern.
	 * The length is limited by limit<br/>
	 * <strong>In case of no result, the method must return an empty
	 * List object!!!!</strong>
	 *
	 * @param pattern String
	 * @param limit the limit for the length. null value will be unlimted
	 * @return
	 */
	public List<DrugLight> getLightDrugsByNamePattern(String pattern, Integer limit);

}
