/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/

package lu.tudor.santec.gecamed.prescription.gui.editor;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientPanel;
import lu.tudor.santec.gecamed.patient.gui.PatientViewTab;
import lu.tudor.santec.gecamed.patient.gui.history.table.HistoryTablePanel;
import lu.tudor.santec.gecamed.patient.gui.history.table.filter.HistoryTypeFilter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


/**
 * Show the complete prescription history of the patient.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PrescriptionHistoryView.java,v $
 * <br>Revision 1.3  2010-08-16 14:32:04  troth
 * <br>Incomplete - # 599: Keep prescription history stable when consultation tabs are clicked
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/599
 * <br>
 * <br>Revision 1.2  2010-07-20 14:18:49  troth
 * <br>add function for colored the line of the open prescription entry in the history table
 * <br>
 * <br>Revision 1.1  2010-04-26 16:51:09  troth
 * <br>Redesign of the prescription view - all prescription class and new package
 * <br>
 */
public class PrescriptionHistoryView extends PatientViewTab{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static final String NAME = "HISTORY_VIEW";

	private PatientPanel patientPanel;

	private JTabbedPane historyTab;

	private HistoryTablePanel prescriptionTablePanel;

	private HistoryTypeFilter prescriptionFilter;


	/**
	 * Constructor of the PrescriptionHistoryView
	 * 
	 * @param patientPanel a reference to the patientPanel
	 */
	public PrescriptionHistoryView(PatientPanel patientPanel) {
		// Reference to the PatientPanel, to get the history table model
		this.patientPanel = patientPanel;		
		initComponent();
		// Update the all historyviews   
		this.prescriptionTablePanel.getModel().fireEvent();
	}
	
	
	/**
	 * Init the components of the GUI
	 */
	private void initComponent() {
		/* ================================================== */
		// Content
		JPanel content = new JPanel(new FormLayout("fill:100:grow",
				"pref,fill:100:grow"));
		content.setOpaque(false);
		CellConstraints cc = new CellConstraints();
		
		/* ------------------------------------------------------- */
		this.setLayout(new BorderLayout());
		this.add(content);
		
		this.setBackground(GECAMedColors.c_GECAMedBackground);

		this.prescriptionTablePanel = new HistoryTablePanel(this.patientPanel, false);
		this.prescriptionFilter = new HistoryTypeFilter();
		this.prescriptionFilter.setFilter("prescription");
		this.prescriptionTablePanel.getModel().installFilter(prescriptionFilter, 2);
		this.prescriptionTablePanel.getModel().setFilteringEnabled(true, 2);
		this.prescriptionTablePanel.setBorder(null);
	
		content.add(this.prescriptionTablePanel, cc.xy(1, 2));
	}
	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.patient.gui.PatientViewTab#getName()
	 */
	@Override
	public String getName() {
		return NAME;
	}


	/**
	 * @return the select Incidents in the historytablemodel
	 */
	public Incident getSelectedIncident() {
		((HistoryTablePanel)this.historyTab.getSelectedComponent()).getSelectedIncident();
		return null;
	}


	public void highlightEntry(IncidentEntry incidentEntry) {
		this.prescriptionTablePanel.highlightEntry(incidentEntry);
	}
	
	public HistoryTablePanel getPrescriptionHistoryTablePanel() {
		return this.prescriptionTablePanel;
	}
}
