/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.FilterTableModel;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PrescriptionTemplate;
import lu.tudor.santec.gecamed.prescription.gui.PrescriptionIcons;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 * The datamodel for the prescription templates. Contains all functions to save, modify and delete the prescription templates.
 * 
 * @version
 * <br>$Log: PrescriptionTemplateTableModel.java,v $
 * <br>Revision 1.5  2013-12-27 18:09:24  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.4  2010-07-30 13:59:30  troth
 * <br>PrescriptionTemplate redesign of private flag, add Icons and add translations
 * <br>
 * <br>Revision 1.3  2010-06-08 14:31:57  troth
 * <br>rebuild of the PrescriptionTemplatePanel and the PrescriptionTemplateTabelModel
 * <br>
 */
public class PrescriptionTemplateTableModel extends FilterTableModel {//extends DefaultTableModel {

	private static final long serialVersionUID = 1L;
	
	private HashMap<String, Vector<PrescriptionTemplate>> templates = new HashMap<String, Vector<PrescriptionTemplate>>();
	
	private String currentType;
	
	private boolean modified = false;
	
	private ImageIcon privateIcon = new ImageIcon();
	
	private Class<?>[] columnClass = {String.class, String.class, ImageIcon.class, String.class};

	
	public PrescriptionTemplateTableModel () {}
	
	//----------------
	// Setter & Getter
	//----------------
	/**
	 * set the type of the templates
	 * @param type
	 */
	public synchronized void setType(String type) {
		this.currentType = type;
		
		Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
		this.setTableData(vector);
		fireTableDataChanged();
	}

	/**
	 * @return the currentType
	 */
	public String getType() {
		
		return this.currentType;
	}
	
	public boolean isModified() {
		return this.modified ;
	}
	
	public void setModified(boolean modified) {
		this.modified = modified; 
	}
	
	/**
	 * set the data of the model
	 * @param type
	 * @param data
	 */
	public synchronized void setData(String type, List<PrescriptionTemplate> data) {
		templates.put(type, new Vector<PrescriptionTemplate> (data));
		
		Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
		this.setTableData(vector);
		fireTableDataChanged();
	}
	
	/**
	 * @param row
	 * @return
	 */
	public synchronized PrescriptionTemplate getTemplate(int row) {
		try {
			Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
			return vector.get(row);
		} catch (Exception e) {
			return null;
		}
	}
	

	public void setRow(PrescriptionTemplate template,int row)
	{
		this.templates.get(currentType).set(row, template);
		fireTableRowsUpdated(0, 0);
	}
	
	public void addRow(PrescriptionTemplate template) {
		this.templates.get(currentType).add(0, template);
		fireTableRowsUpdated(0, 0);
	}
	
	public void removeRow(int row) {
		this.templates.get(currentType).remove(row);
		fireTableRowsUpdated(0, 0);
	}

	
	/**
	 * Removes a template.
	 * 
	 * @param template
	 */
	public void removeTemplate(PrescriptionTemplate template) {
		
		Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
		vector.remove(template);
		
		Vector<PrescriptionTemplate> vector1 = this.templates.get(this.currentType);
		this.setTableData(vector1);
		
		fireTableDataChanged();
	}
	
	
	/**
	 * @param row
	 * @param warningText
	 */
	public void setWarningText(int row, String warningText) {
		
		PrescriptionTemplate template = getTemplate(row);
		if (template != null) {
			
			template.setWarningMsg(warningText);	
			fireTableRowsUpdated(row, row);
		}
	}


	/**
	 * @param row
	 * @param shortcutText
	 */
	public void setShortcutText(int row, String shortcutText) {
		
		PrescriptionTemplate template = getTemplate(row);
		if (template != null) {
			
			template.setShortcut(shortcutText);
			fireTableRowsUpdated(row, row);
		}
	}


	/**
	 * @param row
	 * @param nameText
	 */
	public void setNameText(int row, String nameText) {
		
		PrescriptionTemplate t = getTemplate(row);
		if (t != null) {
		
			t.setDescription(nameText);
			fireTableRowsUpdated(row, row);	
		}
	}
	
	/**
	 * Set the text content of the template
	 * 
	 * @param selectedRow
	 * @param s
	 */
	public void setPrescriptionText(int selectedRow, String text) {
	
		PrescriptionTemplate template = getTemplate(selectedRow);
		if (template != null) {
	
			template.setTextContent(text);
			fireTableRowsUpdated(selectedRow, selectedRow);
		}
	}

	@SuppressWarnings("unchecked")
	public Class getColumnClass(int columnIndex) {
		return columnClass[columnIndex];
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return 4;
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getRowCount()
	 */
	public int getRowCount() {
		return this.getFilteredRowCount();
	}


	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
	
		int row = 0;
		if (this.isFiltering())
			row = this.filteredToModel(rowIndex);
		else
			row = rowIndex;
		try {
			// get the list for the type
			Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
			
			PrescriptionTemplate template = vector.get(row);
			
			if (columnIndex == 0)
				return template.getShortcut();
			
			else if (columnIndex == 1)
				return template.getDescription();
			
			else if (columnIndex == 2) {
				if(template.getPhysicianId() != null) this.privateIcon.setImage(PrescriptionIcons.getIcon(PrescriptionIcons.PRIVATE_ICON_SMALL).getImage());
				else this.privateIcon.setImage(PrescriptionIcons.getIcon(PrescriptionIcons.PUBLIC_ICON_SMALL).getImage());
				return this.privateIcon;
			}
			
			else if (columnIndex == 3)
				return template.getTextContent();
				
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
		
	}


	/* (non-Javadoc)
	 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
	 */
//	@Override
//	public Class<?> getColumnClass(int arg0) {
//		/* ====================================================== */
//		return super.getColumnClass(arg0);
//		/* ====================================================== */
//	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getColumnName(int)
	 */
	@Override
	public String getColumnName(int column) {
		
		if (column == 0)
			return Translatrix.getTranslationString("template.table.shortcut");
		else if (column == 1)
			return Translatrix.getTranslationString("template.table.name");
		else
			return Translatrix.getTranslationString("template.table.visibility");
		
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#setValueAt(java.lang.Object, int, int)
	 */
	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex) {
		
		int row = 0;
		if (this.isFiltering())
			row = this.filteredToModel(rowIndex);
		else
			row = rowIndex;
		
		try {
			// get the list for the type
			Vector<PrescriptionTemplate> vector = this.templates.get(this.currentType);
			
			PrescriptionTemplate template = vector.get(row);
			
			if (columnIndex == 0) {
		
				if ((template.getShortcut() != null && template.getShortcut().equals(value))
						|| (value == null)
						|| (template.getShortcut() == null && "".equals(((String)value).trim())))
					modified = false;
				template.setShortcut((String) value);
		
			}
			else if (columnIndex == 1) {
		
				if ((template.getDescription() != null && template.getDescription().equals(value))
						|| (value == null)
						|| (template.getDescription() == null && "".equals(((String)value).trim())))
					modified = false;
				template.setDescription((String) value);
		
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}