/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.editor.filter;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: TemplateFulltextFilter.java,v $
 * <br>Revision 1.1  2010-05-10 15:09:07  troth
 * <br>add template search function in template dialog
 * <br>
 */
public class TemplateFulltextFilter implements TableFilter{

	private String searchText = "";

	public boolean accept(Object p_Value) {
		if (p_Value instanceof String) {

			String textOfRow = (String) p_Value;

			// empty string is not matching anything
			if ("".equals(searchText)){
				return false;
			}
			
			// lookup in the text content
			if (compare(textOfRow, searchText))
				return true; 
		}
		return false;
	}

	
	/**
	 * Checks if s1 contains s2
	 * 
	 * @param s1
	 * @param s2
	 * @return
	 */
	private boolean compare(String s1, String s2) {
		if (s1 == null || s2 == null)
			return false;
		
		return s1.toUpperCase().contains(s2.toUpperCase());
	}
	
	public void compile() {}

	public boolean isFiltering() {
		
		return true;
	}

	public void setFilter(Object p_FilterValue) {
		if (p_FilterValue instanceof String) 
			this.searchText  = ((String) p_FilterValue).trim();
	}

}
