/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule;

/**
 * The DrugWorker is the central class for accessing any kind
 * of registered drug list. The amount of drug list is
 * transparent for the calling classes.
 * It uses the IDrugList and IDrug interfaces. A drug list must be registered by the static method registerDrugList.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: NewDrugWorker.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:58:54  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 10:00:40  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 */
public class NewDrugWorker {

	private static final int LIMIT = 30;

	private static List<IDrugListModule> drugListModules  = new ArrayList<IDrugListModule>();

	{
		/* ====================================================== */
		// do something here
//		 static initialization of class members
//		drugListModules


		/* ====================================================== */
	}


	/**
	 * Private constructor for Singleton
	 */
	public NewDrugWorker() {
		/* ====================================================== */

		/* ====================================================== */
	}


	/**
	 * Add a drug list module to the system.
	 *
	 * @param drugListModule
	 */
	public static void registerDrugList(IDrugListModule drugListModule) {
		/* ====================================================== */
		if (drugListModule != null)
			drugListModules.add(drugListModule);
		/* ====================================================== */
	}



	/**
	 * Returns a list of DrugLight object that contains the
	 * given pattern. The search is done over all registered
	 * drug lists
	 *
	 * @param pattern
	 * @return
	 */
	public static List<DrugLight> getDrugsByPattern(String pattern) {
		/* ====================================================== */
		// create a new list to return
		List<DrugLight> temp = new ArrayList<DrugLight>();
		// iterate over all modules and to the lookup
		for (IDrugListModule module : drugListModules) {
			// add the result to the temp list
			temp.addAll(
					module.getLightDrugsByNamePattern(pattern, LIMIT)
					);
		}
		// return the results. Thats all.
		return temp;
		/* ====================================================== */
	}


	/**
	 * Returns a list of all drugs in the system.
	 * Attention! This can take quite a long time!!!
	 *
	 * @param start first element
	 * @param pageSize amount of elements
	 * @return
	 */
	public static List<IDrug> getAllDrugs(Integer start, Integer pageSize) {
		/* ================================================== */
		// create a new list to return
		List<IDrug> temp = new ArrayList<IDrug>();
		// iterate over all modules and to the lookup
		for (IDrugListModule module : drugListModules) {
			// add the result to the temp list
			temp.addAll(
					module.getDrugs(start, pageSize)
					);
		}
		// return the results. Thats all.
		return temp;
		/* ================================================== */
	}


	/**
	 * Returns a list of all available options
	 * that are brought by each list.
	 * Duplicate entries will be removed.
	 *
	 * @return
	 */
	public static List<String> getOptions() {
		/* ================================================== */
		HashSet<String> options = new LinkedHashSet<String>();

		for (IDrugListModule module : drugListModules) {
			if (module.getOptions() != null)
				options.addAll(module.getOptions());
		}
		return new ArrayList<String>(options);
		/* ================================================== */
	}


	/**
	 * Converts an IDrug object to a DrugLight object
	 *
	 * @param iD
	 * @return
	 */
	public static DrugLight IDrug2DrugLight(IDrug iD){
		/* ================================================== */
		if (iD != null) {
			DrugLight dl = new DrugLight();
			dl.setDrugId(iD.getId());
			dl.setListId(iD.getDrugListId());
			dl.setForm(iD.getApplicationForm());
			dl.setName(iD.getName());
			return dl;
		} else
			return null;
		/* ================================================== */
	}


}
