/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import java.util.List;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.AtcClass;

/**
 * TableFilter to filter the drugbrowser content by atc classes.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.02.2007
 * 09:37:31
 *
 *
 * @version
 * <br>$Log:
 * <br>
 *
 */
public class AtcFilter implements TableFilter {

	private String searchText = "";

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#accept(java.lang.Object)
	 */
	public boolean accept(Object p_Value) {
		/* ====================================================== */
		if (p_Value instanceof List) {
			for (Object o : (List) p_Value) {
				/* ------------------------------------------------------- */
				AtcClass atc = (AtcClass) o;
				if (atc.getCode().toUpperCase().startsWith(searchText.toUpperCase().trim()))
					return true;
				/* ------------------------------------------------------- */
			}
//			return ((String) p_Value).toUpperCase().startsWith(searchText.toUpperCase().trim());
		}
		return false;
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#compile()
	 */
	public void compile() {
		/* ====================================================== */

		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#isFiltering()
	 */
	public boolean isFiltering() {
		/* ====================================================== */
		return true;
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#setFilter(java.lang.Object)
	 */
	public void setFilter(Object searchText) {
		/* ====================================================== */
		if (searchText instanceof String)
			this.searchText = (String) searchText;
		/* ====================================================== */
	}

}
