/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: DrugBrowserModel.java,v $
 * <br>Revision 1.13  2013-02-22 08:46:50  kutscheid
 * <br>remove the tupel classes (please redeploy)
 * <br>
 * <br>Revision 1.12  2010-06-17 12:32:43  troth
 * <br>small bug fix - # 535: Problem bei Medikamenten�bernahme aus CEFIP
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/535
 * <br>
 * <br>Revision 1.11  2009-04-15 13:30:41  heinemann
 * <br>added cefip and posology button to template editor
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.8  2008-02-08 14:47:38  mack
 * <br>Changes required by moving filtertablemodel into dedicated sub-package
 * <br>
 * <br>Revision 1.7  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.6  2007/08/01 07:09:00  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2007/07/03 12:35:29  heinemann
 * <br>system.out removed
 * <br>
 * <br>Revision 1.4  2007/04/11 07:39:23  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.FilterTableModel;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.gui.util.IResultListener;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Table model for the DrugBrowser table. It extends the FiltertableModel to ensure
 * filtering by name, substance and atc class.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 12.02.2007
 * 14:51:05
 *
 *
 * @version
 * <br>$Log: DrugBrowserModel.java,v $
 * <br>Revision 1.13  2013-02-22 08:46:50  kutscheid
 * <br>remove the tupel classes (please redeploy)
 * <br>
 * <br>Revision 1.12  2010-06-17 12:32:43  troth
 * <br>small bug fix - # 535: Problem bei Medikamenten�bernahme aus CEFIP
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/535
 * <br>
 * <br>Revision 1.11  2009-04-15 13:30:41  heinemann
 * <br>added cefip and posology button to template editor
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.8  2008-02-08 14:47:38  mack
 * <br>Changes required by moving filtertablemodel into dedicated sub-package
 * <br>
 * <br>Revision 1.7  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.6  2007/08/01 07:09:00  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2007/07/03 12:35:29  heinemann
 * <br>system.out removed
 * <br>
 * <br>Revision 1.4  2007/04/11 07:39:23  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class DrugBrowserModel extends FilterTableModel implements IResultListener {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	public static final String HEADER_NAME 			= "prescription.name.drugbrowser.name";
	public static final String HEADER_FORM 			= "prescription.name.drugbrowser.form";
	public static final String HEADER_DOSE 			= "prescription.name.drugbrowser.dose";
	public static final String HEADER_PACKAGE 		= "prescription.name.drugbrowser.package";
	public static final String HEADER_SUBSTANCE 	= "prescription.name.drugbrowser.substance";
//	public static final String HEADER_ATC 			= "prescription.name.drugbrowser.atc";
	public static final String HEADER_PRICE 		= "prescription.name.drugbrowser.price";
	public static final String HEADER_MANUFACTURER 	= "prescription.name.drugbrowser.manufacturer";

	public static final String[] TABLE_HEADERS = {
													HEADER_NAME,
													HEADER_FORM,
													HEADER_DOSE,
													HEADER_PACKAGE,
													HEADER_SUBSTANCE,
//													HEADER_ATC,
													HEADER_PRICE,
													HEADER_MANUFACTURER
												};



	/* ##############################################################
	 *   Class Members
	 */

	private Vector<IDrug> data;

	private List<String> options;

	/* ------------------------------------------------------------- */

	public DrugBrowserModel(List<String> optionStrings) {
		/* ================================================== */
		data = new Vector<IDrug>();
		this.setTableData(data);

		if (optionStrings != null)
			this.options = optionStrings;
		else
			this.options = new ArrayList<String>();

		DrugDataGrabber grabber = new DrugDataGrabber();
		grabber.addResultListener(this);
		grabber.start();

		/* ================================================== */
	}


	public void triggerUpdate() {
		/* ================================================== */
		this.data = new Vector<IDrug>();
		this.setTableData(data);
		fireTableDataChanged();

		DrugDataGrabber grabber = new DrugDataGrabber();
		grabber.addResultListener(this);
		grabber.start();
		/* ================================================== */
	}


	public IDrug getDrugByRow(int rowIndex) {
		/* ================================================== */
		int row = 0;
		if (this.isFiltering())
			row = this.filteredToModel(rowIndex);
		else
			row = rowIndex;
		if (row >= 0 && row < data.size())
			return data.elementAt(row);
		else
			return null;
		/* ================================================== */
	}


	/* ################################################################
	 *
	 * Methods from FilterTableModel
	 */

	public int getColumnCount() {
		/* ====================================================== */
		return TABLE_HEADERS.length;// + options.size();
		/* ====================================================== */
	}

	public int getRowCount() {
		/* ====================================================== */
		return this.getFilteredRowCount();
		/* ====================================================== */
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		/* ====================================================== */

		IDrug drug = null;
		int row = 0;
		if (this.isFiltering())
			row = this.filteredToModel(rowIndex);
		else
			row = rowIndex;
		/* ------------------------------------------------------- */
		try {
			drug = this.data.elementAt(row);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}

		switch (columnIndex) {
			/* ------------------------------------------------------- */
			case 0 : return drug.getName();
			case 1 : return drug.getApplicationForm();
			case 2 : return drug.getDose();
			case 3 : return drug.getPackage();
			case 4 : return drug.getSubstances();
//			case 5 : return drug.getAtcClasses();
			case 5 : return drug.getPrice();
			case 6 : return drug.getManufacturer();
			default : {
				/* ------------------------------------------------------- */
				try {
					/* ------------------------------------------------------- */
					return drug.getOptions().get(columnIndex - TABLE_HEADERS.length)[1];
					/* ------------------------------------------------------- */
				} catch (Exception e) {
					return null;
				}
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
		}

		/* ====================================================== */
	}




	/* ################################################################
	 *
	 * Methods from AbstractTableModel
	 *
	 */
	@Override
	public String getColumnName(int column) {
		/* ====================================================== */

		if (column >= 0 && column < TABLE_HEADERS.length) {
			return Translatrix.getTranslationString(TABLE_HEADERS[column]);
		}
		else if (column >=0){
				/* ------------------------------------------------------- */
				// get elements from options
				try {
					return options.get(column - TABLE_HEADERS.length);
				} catch (Exception e) {
					return "";
				}
				/* ------------------------------------------------------- */
			}
		else
			return "";
		/* ====================================================== */
	}


	@SuppressWarnings("unchecked")
	public void receiveResult(Object data) {
		/* ====================================================== */
		if (data instanceof List) {
			this.data.addAll((List)data);
			this.setTableData(this.data);
			fireTableDataChanged();
		}
		/* ====================================================== */
	}

	
	
	/**
	 * Returns the row as int for the row header name
	 * 
	 * @param rowName
	 * @return int value of the column, -1 if not found.
	 */
	public static int getRowForName(String rowName) {
		/* ================================================== */
		for (int i = 0; i < TABLE_HEADERS.length; i++) {
			if (rowName.equals(TABLE_HEADERS[i]))
				return i;
		}
		return -1;
		/* ================================================== */
	}
	

}
