/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;



/**
 * Rendere for the DrugBrowser table.
 * This is a little bit tricky. The drug list contains drugs with the same name but different packaging sizes.
 * To mark the transition to another drug, the drugs with the same name have teh same background.
 * Seems to work in the most cases.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.01.2008
 * 10:44:04
 *
 *
 * @version
 * <br>$Log: DrugColorCellRenderer.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 *   
 */
public class DrugColorCellRenderer extends DefaultTableCellRenderer
	{

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final long serialVersionUID = 1L;
	    
	public Color c_OddColor;
	public Color c_EvenColor;

	private Color l_Background;
	
	/**
	 * 
	 */
	private HashMap<Integer, Color> colorHash = new HashMap<Integer, Color>();
	
	
	/**
	 * 
	 */
	public DrugColorCellRenderer() { 
		/* ================================================== */
		c_OddColor = new Color (237,243,254);
		c_EvenColor = new Color (255,255,255);
		/* ------------------------------------------------------- */
		l_Background = c_OddColor;
		/* ================================================== */
		}
	
	/**
	 * @param alpha
	 */
	public DrugColorCellRenderer(int alpha) { 
		/* ================================================== */
		c_OddColor = new Color (237,243,254, alpha);
		c_EvenColor = new Color (255,255,255, alpha);
		/* ------------------------------------------------------- */
		l_Background = c_OddColor;
		/* ================================================== */
	}

public Component getTableCellRendererComponent(JTable p_Table, Object
          value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) 	
	{
	/* ================================================== */

	super.getTableCellRendererComponent(p_Table, value, p_IsSelected, hasFocus, p_Row, p_Column);
//	if (lastRow != p_Row) {
//		/* ------------------------------------------------------- */
//		/* ------------------------------------------------------- */
//	}
	// if the last name is unequal to the current name, switch colors
//	if (p_Row -1 >= 0) {
		/* ------------------------------------------------------- */
		// do something per row only once
		if (colorHash.get(p_Row) == null) {
			/* ------------------------------------------------------- */
			// get the color of the previous element
			int tempRow = p_Row;
			while (colorHash.get(tempRow) == null && tempRow > -1) {
				/* ------------------------------------------------------- */
				tempRow--;
				/* ------------------------------------------------------- */
			}
			if (tempRow > -1) {
				/* ------------------------------------------------------- */
				DrugBrowserModel dbModel = (DrugBrowserModel) p_Table.getModel();
				String curName 		= (String) dbModel.getValueAt(p_Row, DrugBrowserModel.getRowForName(DrugBrowserModel.HEADER_NAME));
				String previousName = (String) dbModel.getValueAt(p_Row - 1, DrugBrowserModel.getRowForName(DrugBrowserModel.HEADER_NAME));
				
				
				if (!previousName.equals(curName)) {
					/* ------------------------------------------------------- */
					l_Background = (colorHash.get(tempRow).equals(c_OddColor) ? c_EvenColor : c_OddColor);
					/* ------------------------------------------------------- */
				}
				// save the row in the hash
				/* ------------------------------------------------------- */
			} else
				l_Background = c_OddColor;
			/* ------------------------------------------------------- */
			colorHash.put(p_Row, l_Background);
			/* ------------------------------------------------------- */
//			// if there are bigger keys, adjust the color
//			if (colorHash.get(p_Row+1) != null) {
//				/* ------------------------------------------------------- */
//				List<Integer> keyList = new ArrayList<Integer>(colorHash.keySet());
//				Collections.sort(keyList);
//				/* ------------------------------------------------------- */
//				
//				for (Integer key : keyList.subList(keyList.indexOf(p_Row), keyList.size()-1)) {
//						
//					
//				}
//				/* ------------------------------------------------------- */
//			}
			/* ------------------------------------------------------- */
		} else
			l_Background = colorHash.get(p_Row);
//		if (lastRow != p_Row && !previousName.equals(curName)) {
//			/* ------------------------------------------------------- */
//			lastColor = l_Background; 
//			l_Background = (lastColor.equals(c_OddColor) ? c_EvenColor : c_OddColor);
//			lastRow = p_Row;
//			/* ------------------------------------------------------- */
//		}
		/* ------------------------------------------------------- */
//	} 
//	else
//		l_Background = ( p_Row % 2 == 0) ? c_OddColor : c_EvenColor;
	if (p_IsSelected) 
		 this.setBackground(p_Table.getSelectionBackground());
	else this.setBackground(l_Background);

      return this;
      /* ================================================== */
  }


	protected void clearHash() {
		/* ================================================== */
		try {
			this.colorHash.clear();
		} catch (Exception e) {}
		/* ================================================== */
	}
	


} 
