/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: NameFilter.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-02-08 14:47:38  mack
 * <br>Changes required by moving filtertablemodel into dedicated sub-package
 * <br>
 * <br>Revision 1.2  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.1  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.3  2007/03/06 13:33:24  heinemann
 * <br>Incomplete - # 4: Integrate a CEFIP Browser for the prescription part
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/4
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;

/**
 * Filter for the DrugBrowser table. Filters the name
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.02.2007
 * 09:37:31
 *
 *
 * @version
 * <br>$Log: NameFilter.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-02-08 14:47:38  mack
 * <br>Changes required by moving filtertablemodel into dedicated sub-package
 * <br>
 * <br>Revision 1.2  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.1  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.3  2007/03/06 13:33:24  heinemann
 * <br>Incomplete - # 4: Integrate a CEFIP Browser for the prescription part
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/4
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class NameFilter implements TableFilter {

	private String searchText = "";

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#accept(java.lang.Object)
	 */
	public boolean accept(Object p_Value) {
		/* ====================================================== */
		if (p_Value instanceof String) {
//			return ((String) p_Value).toUpperCase().matches(searchText.toUpperCase()+".*?");
			return ((String) p_Value).toUpperCase().startsWith(searchText.toUpperCase().trim());
		}
		return false;
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#compile()
	 */
	public void compile() {
		/* ====================================================== */

		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#isFiltering()
	 */
	public boolean isFiltering() {
		/* ====================================================== */
		return true;
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.TableFilter#setFilter(java.lang.Object)
	 */
	public void setFilter(Object searchText) {
		/* ====================================================== */
		if (searchText instanceof String)
			this.searchText = (String) searchText;
		/* ====================================================== */
	}

}
